/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.MimeBase64Decoder;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

class MozillaEntryConsumer
extends HandlerBase {
    private String _entryDN;
    private LDAPAttributeSet _attrSet;
    private LDAPAttribute _attr;
    private StringBuffer _value;
    private MimeBase64Decoder _decoder;
    private Vector _entries = new Vector();

    MozillaEntryConsumer() {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this._decoder != null) {
            this._decoder.translate(cArray, n, n2);
        } else if (this._value != null) {
            this._value.append(cArray, n, n2);
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("directory-entries")) {
            if (this._attrSet != null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", string));
            }
        } else if (string.equals("entry")) {
            if (this._attrSet == null || this._attr != null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", string));
            }
            this._entries.addElement(new LDAPEntry(this._entryDN, this._attrSet));
            this._entryDN = null;
            this._attrSet = null;
        } else if (string.equals("objectclass") || string.equals("attr")) {
            if (this._attrSet == null || this._attr == null || this._value != null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", string));
            }
            this._attrSet.add(this._attr);
            this._attr = null;
        } else if (string.equals("value") || string.equals("oc-value")) {
            if (this._attrSet == null || this._attr == null || this._value == null && this._decoder == null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", string));
            }
            if (this._decoder != null) {
                this._attr.addValue(this._decoder.getByteArray());
                this._decoder = null;
            } else {
                this._attr.addValue(this._value.toString());
                this._value = null;
            }
        } else {
            throw new SAXException(Messages.format("dsml.closingTagNotRecognized", string));
        }
    }

    public Enumeration getEntries() {
        return this._entries.elements();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (!string.equals("directory-entries")) {
            if (string.equals("entry")) {
                if (this._attrSet != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", string));
                }
                this._attrSet = new LDAPAttributeSet();
                this._entryDN = attributeList.getValue("dn");
            } else if (string.equals("objectclass")) {
                if (this._attrSet == null || this._attr != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", string));
                }
                this._attr = new LDAPAttribute("objectclass");
            } else if (string.equals("attr")) {
                if (this._attrSet == null || this._attr != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", string));
                }
                this._attr = new LDAPAttribute(attributeList.getValue("name"));
            } else if (string.equals("value") || string.equals("oc-value")) {
                if (this._attrSet == null || this._attr == null || this._value != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", string));
                }
                if ("base64".equals(attributeList.getValue("encoding"))) {
                    this._decoder = new MimeBase64Decoder();
                } else {
                    this._value = new StringBuffer();
                }
            } else {
                throw new SAXException(Messages.format("dsml.openingTagNotRecognized", string));
            }
        }
    }
}

