/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class SequenceKeyGenerator
implements KeyGenerator {
    protected final PersistenceFactory _factory;
    protected final String _factoryName;
    protected final String _seqName;
    private byte _style;
    private final int _sqlType;
    private int _increment;
    private boolean _triggerPresent;

    public SequenceKeyGenerator(PersistenceFactory persistenceFactory, Properties properties, int n) throws MappingException {
        this._factoryName = persistenceFactory.getFactoryName();
        boolean bl = "true".equals(properties.getProperty("returning"));
        this._triggerPresent = "true".equals(properties.getProperty("trigger", "false"));
        if (!(this._factoryName.equals("oracle") || this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") || this._factoryName.equals("sapdb"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), this._factoryName));
        }
        if (!this._factoryName.equals("oracle") && bl) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "returning=\"true\"", this.getClass().getName(), this._factoryName));
        }
        this._factory = persistenceFactory;
        this._seqName = properties.getProperty("sequence", "{0}_seq");
        this._style = (byte)(this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") ? -1 : (bl ? 0 : 1));
        if (this._triggerPresent && !bl) {
            this._style = 1;
        }
        if (this._triggerPresent && this._style == -1) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "trigger=\"true\"", this.getClass().getName(), this._factoryName));
        }
        this._sqlType = n;
        if (n != 4 && n != 2 && n != 3 && n != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
        try {
            this._increment = Integer.parseInt(properties.getProperty("increment", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            this._increment = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection connection, String string, String string2, Properties properties) throws PersistenceException {
        BigDecimal bigDecimal;
        Statement statement;
        block19: {
            Long l;
            block18: {
                Integer n;
                block17: {
                    statement = null;
                    try {
                        try {
                            ResultSet resultSet;
                            if (this._factory.getFactoryName().equals("interbase")) {
                                statement = connection.prepareStatement("select gen_id(" + MessageFormat.format(this._seqName, string) + "," + this._increment + ") from rdb$database");
                                resultSet = statement.executeQuery();
                            } else if (this._style == -1) {
                                statement = connection.prepareStatement("SELECT nextval('" + MessageFormat.format(this._seqName, string) + "')");
                                resultSet = statement.executeQuery();
                            } else if (this._triggerPresent && this._factoryName.equals("postgresql")) {
                                Object v = ((Hashtable)properties).get("insertStatement");
                                Class<?> clazz = Class.forName("org.postgresql.Statement");
                                Method method = clazz.getMethod("getInsertedOID", null);
                                int n2 = (Integer)method.invoke(v, null);
                                statement = connection.prepareStatement("SELECT " + this._factory.quoteName(string2) + " FROM " + this._factory.quoteName(string) + " WHERE OID=?");
                                statement.setInt(1, n2);
                                resultSet = statement.executeQuery();
                            } else {
                                statement = connection.prepareStatement("SELECT " + this._factory.quoteName(String.valueOf(MessageFormat.format(this._seqName, string)) + ".currval") + " FROM " + this._factory.quoteName(string));
                                resultSet = statement.executeQuery();
                            }
                            if (!resultSet.next()) throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                            int n3 = resultSet.getInt(1);
                            if (this._sqlType == 4) {
                                n = new Integer(n3);
                                Object var10_16 = null;
                                if (statement == null) return n;
                                break block17;
                            }
                            if (this._sqlType == -5) {
                                l = new Long(n3);
                                break block18;
                            }
                            bigDecimal = new BigDecimal((double)n3);
                            break block19;
                        }
                        catch (Exception exception) {
                            throw new PersistenceException(Messages.format("persist.keyGenSQL", exception.toString()));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_19 = null;
                        if (statement == null) throw throwable;
                        try {
                            statement.close();
                            throw throwable;
                        }
                        catch (SQLException sQLException) {
                            throw throwable;
                        }
                    }
                }
                try {}
                catch (SQLException sQLException) {}
                statement.close();
                return n;
            }
            Object var10_17 = null;
            if (statement == null) return l;
            try {}
            catch (SQLException sQLException) {}
            statement.close();
            return l;
        }
        Object var10_18 = null;
        if (statement == null) return bigDecimal;
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return bigDecimal;
    }

    public byte getStyle() {
        return this._style;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public String patchSQL(String string, String string2) throws MappingException {
        if (this._style == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("INSERT")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("INTO")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.startsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        String string4 = MessageFormat.format(this._seqName, string3);
        int n = string.indexOf(40);
        int n2 = string.indexOf(40, n + 1);
        if (n < 0) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!this._triggerPresent) {
            if (n2 < 0) {
                n2 = n;
                n = string.indexOf(" VALUES ");
                stringBuffer.insert(n2 + 1, this._factory.quoteName(String.valueOf(string4) + ".nextval"));
                stringBuffer.insert(n + 1, "(" + this._factory.quoteName(string2) + ") ");
            } else {
                stringBuffer.insert(n2 + 1, String.valueOf(this._factory.quoteName(String.valueOf(string4) + ".nextval")) + ",");
                stringBuffer.insert(n + 1, String.valueOf(this._factory.quoteName(string2)) + ",");
            }
        }
        if (this._style == 0) {
            stringBuffer.append(" RETURNING ");
            stringBuffer.append(this._factory.quoteName(string2));
            stringBuffer.append(" INTO ?");
        }
        return stringBuffer.toString();
    }
}

