/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.oql.ParamInfo;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.TokenTypes;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.QueryExpression;

public class ParseTreeWalker
implements TokenTypes {
    private LockEngine _dbEngine;
    private ParseTreeNode _parseTree;
    private String _projectionName;
    private String _projectionAlias;
    private int _projectionType;
    private String _fromClassName;
    private String _fromClassAlias;
    private ClassLoader _classLoader;
    private Class _objClass;
    private QueryExpression _queryExpr;
    private int _SQLParamIndex;
    private Hashtable _paramInfo;
    private Hashtable _fieldInfo;
    private Hashtable _pathInfo;
    private Hashtable _allPaths;
    private SQLEngine _engine;
    private JDOClassDescriptor _clsDesc;
    public static final int AGGREGATE = 1;
    public static final int FUNCTION = 2;
    public static final int PARENT_OBJECT = 3;
    public static final int DEPENDANT_OBJECT = 4;
    public static final int DEPENDANT_OBJECT_VALUE = 5;
    public static final int DEPENDANT_VALUE = 6;

    public ParseTreeWalker(LockEngine lockEngine, ParseTreeNode parseTreeNode, ClassLoader classLoader) throws QueryException {
        this._dbEngine = lockEngine;
        this._parseTree = parseTreeNode;
        this._classLoader = classLoader;
        this._SQLParamIndex = 1;
        this._paramInfo = new Hashtable();
        this._fieldInfo = new Hashtable();
        this._pathInfo = new Hashtable();
        this._allPaths = new Hashtable();
        if (!this._parseTree.isRoot()) {
            throw new QueryException("ParseTreeWalker must be created with the root node of the parse tree.");
        }
        this.checkErrors();
        this.createQueryExpression();
    }

    private void addJoinsForPathExpression(Vector vector) {
        if (vector == null) {
            throw new IllegalStateException("path = null !");
        }
        JDOClassDescriptor jDOClassDescriptor = this._clsDesc;
        int n = 1;
        while (n < vector.size() - 1) {
            FieldDescriptorImpl fieldDescriptorImpl = null;
            while (fieldDescriptorImpl == null) {
                fieldDescriptorImpl = jDOClassDescriptor.getField((String)vector.elementAt(n));
                if (fieldDescriptorImpl != null) continue;
                jDOClassDescriptor = (JDOClassDescriptor)jDOClassDescriptor.getExtends();
            }
            JDOClassDescriptor jDOClassDescriptor2 = (JDOClassDescriptor)fieldDescriptorImpl.getClassDescriptor();
            if (jDOClassDescriptor2 != null && jDOClassDescriptor2 != jDOClassDescriptor) {
                JDOFieldDescriptor jDOFieldDescriptor;
                if (((JDOFieldDescriptor)fieldDescriptorImpl).getManyKey() == null) {
                    jDOFieldDescriptor = (JDOFieldDescriptor)jDOClassDescriptor2.getIdentity();
                    this._queryExpr.addInnerJoin(jDOClassDescriptor.getTableName(), ((JDOFieldDescriptor)fieldDescriptorImpl).getSQLName(), jDOClassDescriptor2.getTableName(), jDOFieldDescriptor.getSQLName(), this.buildTableAlias(jDOClassDescriptor2.getTableName(), vector));
                } else {
                    jDOFieldDescriptor = (JDOFieldDescriptor)jDOClassDescriptor.getIdentity();
                    String string = jDOFieldDescriptor.getSQLName()[0];
                    this._queryExpr.addInnerJoin(jDOClassDescriptor.getTableName(), string, jDOClassDescriptor2.getTableName(), ((JDOFieldDescriptor)fieldDescriptorImpl).getManyKey()[0], this.buildTableAlias(jDOClassDescriptor2.getTableName(), vector));
                }
                jDOClassDescriptor = jDOClassDescriptor2;
            }
            ++n;
        }
    }

    private void addLimitClause(ParseTreeNode parseTreeNode) {
        String string = this.getSQLExpr(parseTreeNode);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf("?", n);
        int n3 = this._SQLParamIndex;
        while (n2 != -1) {
            int n4 = string.indexOf(" ", n2);
            Integer n5 = null;
            n5 = n4 != -1 ? new Integer(string.substring(n2 + 1, n4)) : new Integer(string.substring(n2 + 1));
            ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n5);
            paramInfo.mapToSQLParam(n3++);
            stringBuffer.append(string.substring(n, n2 + 1));
            n = n4 < 0 ? string.length() : n4;
            n2 = string.indexOf("?", n);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        this._queryExpr.addLimitClause(stringBuffer.toString());
        this._SQLParamIndex = n3;
    }

    private void addSelectFromJoins() {
        ParseTreeNode parseTreeNode = null;
        parseTreeNode = this._parseTree.getChild(0).getToken().getTokenType() == 41 ? this._parseTree.getChild(1) : this._parseTree.getChild(0);
        this._queryExpr.addTable(this._clsDesc.getTableName());
        this._queryExpr.addSelect(this.getSQLExpr(parseTreeNode));
    }

    private void addWhereClause(ParseTreeNode parseTreeNode) {
        String string = this.getSQLExpr(parseTreeNode.getChild(0));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf("?", n);
        int n3 = 1;
        while (n2 != -1) {
            int n4 = string.indexOf(" ", n2);
            Integer n5 = null;
            n5 = n4 != -1 ? new Integer(string.substring(n2 + 1, n4)) : new Integer(string.substring(n2 + 1));
            ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n5);
            paramInfo.mapToSQLParam(n3++);
            stringBuffer.append(string.substring(n, n2 + 1));
            n = n4 < 0 ? string.length() : n4;
            n2 = string.indexOf("?", n);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        this._queryExpr.addWhereClause(stringBuffer.toString());
        this._SQLParamIndex = n3;
    }

    public String buildTableAlias(String string, Vector vector) {
        String string2 = string;
        if (vector != null && vector.size() > 2) {
            int n;
            Integer n2 = (Integer)this._allPaths.get(vector);
            if (n2 == null) {
                n = this._allPaths.size();
                this._allPaths.put(vector, new Integer(n));
            } else {
                n = n2;
            }
            string2 = String.valueOf(string2) + "_" + n;
        }
        return string2;
    }

    private void checkErrors() throws QueryException {
        Enumeration enumeration = this._parseTree.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode = (ParseTreeNode)enumeration.nextElement();
            if (parseTreeNode.getToken().getTokenType() != 5) continue;
            this.checkFromPart(parseTreeNode.getChild(0));
            break;
        }
        if (this._parseTree.getChild(0).getToken().getTokenType() == 41) {
            this.checkSelectPart(this._parseTree.getChild(1));
        } else {
            this.checkSelectPart(this._parseTree.getChild(0));
        }
        int n = 2;
        while (n <= this._parseTree.getChildCount() - 1) {
            int n2 = this._parseTree.getChild(n).getToken().getTokenType();
            switch (n2) {
                case 7: {
                    this.checkWhereClause(this._parseTree.getChild(n));
                    break;
                }
                case 46: {
                    this.checkOrderClause(this._parseTree.getChild(n));
                    break;
                }
                case 55: {
                    this.checkLimitClause(this._parseTree.getChild(n));
                    break;
                }
            }
            ++n;
        }
    }

    private JDOFieldDescriptor checkField(ParseTreeNode parseTreeNode) throws QueryException {
        JDOFieldDescriptor jDOFieldDescriptor = (JDOFieldDescriptor)this._fieldInfo.get(parseTreeNode);
        if (jDOFieldDescriptor != null) {
            return jDOFieldDescriptor;
        }
        if (parseTreeNode.getToken().getTokenType() == 30) {
            jDOFieldDescriptor = this.checkProjection(parseTreeNode, false, false);
        } else {
            jDOFieldDescriptor = this.getFieldDesc(parseTreeNode.getToken().getTokenValue(), this._clsDesc);
            if (jDOFieldDescriptor != null) {
                this._fieldInfo.put(parseTreeNode, jDOFieldDescriptor);
            }
        }
        if (jDOFieldDescriptor == null) {
            throw new QueryException("The field " + parseTreeNode.getToken().getTokenValue() + " was not found.");
        }
        return jDOFieldDescriptor;
    }

    private void checkFromPart(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() == 3) {
            ParseTreeNode parseTreeNode2 = parseTreeNode.getChild(0);
            if (parseTreeNode2.getToken().getTokenType() == 30) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = parseTreeNode2.children();
                while (enumeration.hasMoreElements()) {
                    ParseTreeNode parseTreeNode3 = (ParseTreeNode)enumeration.nextElement();
                    stringBuffer.append(parseTreeNode3.getToken().getTokenValue()).append(".");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                this._fromClassName = stringBuffer.toString();
            } else {
                this._fromClassName = parseTreeNode2.getToken().getTokenValue();
            }
            this._fromClassAlias = parseTreeNode.getChild(1).getToken().getTokenValue();
        } else {
            if (parseTreeNode.getToken().getTokenType() == 30) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    ParseTreeNode parseTreeNode4 = (ParseTreeNode)enumeration.nextElement();
                    stringBuffer.append(parseTreeNode4.getToken().getTokenValue()).append(".");
                }
                this._fromClassName = stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
            } else {
                this._fromClassName = parseTreeNode.getToken().getTokenValue();
            }
            this._fromClassAlias = this._fromClassName;
        }
        try {
            this._objClass = this._classLoader == null ? Class.forName(this._fromClassName) : this._classLoader.loadClass(this._fromClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QueryException("Could not find class " + this._fromClassName);
        }
        this._engine = (SQLEngine)this._dbEngine.getPersistence(this._objClass);
        if (this._engine == null) {
            throw new QueryException("Could not find mapping for class " + this._fromClassName);
        }
        this._clsDesc = this._engine.getDescriptor();
        if (this._clsDesc == null) {
            throw new QueryException("Could not get a descriptor for class " + this._fromClassName);
        }
    }

    private void checkInClauseRightSide(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() != 44) {
            throw new QueryException("The right side of the IN operator must be a LIST.");
        }
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            switch (((ParseTreeNode)enumeration.nextElement()).getToken().getTokenType()) {
                default: {
                    throw new QueryException("The LIST can only contain literals and Keywords nil and undefined.");
                }
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
            }
        }
    }

    private void checkLimitClause(ParseTreeNode parseTreeNode) throws QueryException {
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 27: {
                this.checkParameter(parseTreeNode);
                break;
            }
            default: {
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    this.checkLimitClause((ParseTreeNode)enumeration.nextElement());
                }
                break block0;
            }
        }
    }

    private void checkOrderClause(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() != 46) {
            throw new QueryException("checkOrderClause was called on a subtree which is not an order clause.");
        }
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            switch (n) {
                case 48: 
                case 49: {
                    parseTreeNode2 = parseTreeNode2.getChild(0);
                    n = parseTreeNode2.getToken().getTokenType();
                }
            }
            switch (n) {
                case 30: {
                    this.checkProjection(parseTreeNode2, false, false);
                    break;
                }
                case 2: {
                    this.checkField(parseTreeNode2);
                    break;
                }
                default: {
                    throw new QueryException("Only identifiers, path expressions, and the keywords ASC and DESC are allowed in the ORDER BY clause.");
                }
            }
        }
    }

    private void checkParameter(ParseTreeNode parseTreeNode) throws QueryException {
        Integer n;
        String string = "";
        if (parseTreeNode.getChildCount() == 1) {
            n = Integer.decode(parseTreeNode.getChild(0).getToken().getTokenValue());
        } else {
            n = Integer.decode(parseTreeNode.getChild(1).getToken().getTokenValue());
            string = parseTreeNode.getChild(0).getToken().getTokenValue();
        }
        String string2 = "";
        JDOFieldDescriptor jDOFieldDescriptor = null;
        int n2 = parseTreeNode.getParent().getToken().getTokenType();
        switch (n2) {
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 55: {
                string2 = "java.lang.Number";
                break;
            }
            case 12: 
            case 19: {
                string2 = "java.lang.String";
                break;
            }
            case 8: 
            case 9: 
            case 24: {
                string2 = "java.lang.Boolean";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 40: {
                string2 = this.getTypeForComparison(parseTreeNode.getParent());
                jDOFieldDescriptor = this.getJDOFieldDescriptor(parseTreeNode.getParent());
            }
        }
        ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n);
        if (paramInfo == null) {
            paramInfo = new ParamInfo(string, string2, jDOFieldDescriptor);
            this._paramInfo.put(n, paramInfo);
        } else {
            paramInfo.check(string, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JDOFieldDescriptor checkProjection(ParseTreeNode parseTreeNode, boolean bl, boolean bl2) throws QueryException {
        FieldDescriptorImpl fieldDescriptorImpl = null;
        if (parseTreeNode.getChildCount() == 0) {
            if (bl) {
                this._projectionType = 3;
                this._projectionName = parseTreeNode.getToken().getTokenValue();
                if (this._projectionName.equals(this._fromClassAlias)) return fieldDescriptorImpl;
                throw new QueryException("Object name not the same in SELECT and FROM - select: " + this._projectionName + ", from: " + this._fromClassAlias);
            }
            if (!bl2) return null;
            throw new QueryException("Only primitive values are allowed to be passed as parameters to Aggregate and SQL functions.");
        }
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 2: {
                this._projectionType = 2;
                Enumeration enumeration = parseTreeNode.getChild(0).children();
                while (enumeration.hasMoreElements()) {
                    this.checkProjection((ParseTreeNode)enumeration.nextElement(), false, true);
                }
                return fieldDescriptorImpl;
            }
            case 30: {
                Enumeration enumeration = parseTreeNode.children();
                ParseTreeNode parseTreeNode2 = null;
                String string = null;
                StringBuffer stringBuffer = new StringBuffer();
                Vector<String> vector = new Vector<String>();
                if (enumeration.hasMoreElements()) {
                    parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
                    string = parseTreeNode2.getToken().getTokenValue();
                    if (!(string.equals(this._projectionName) || string.equals(this._projectionAlias) || string.equals(this._fromClassName) || string.equals(this._fromClassAlias))) {
                        enumeration = parseTreeNode.children();
                        string = this._fromClassAlias;
                    }
                    stringBuffer.append(string);
                    vector.addElement(string);
                }
                JDOClassDescriptor jDOClassDescriptor = this._clsDesc;
                FieldDescriptorImpl fieldDescriptorImpl2 = null;
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    fieldDescriptorImpl2 = null;
                    string = null;
                    while (fieldDescriptorImpl2 == null && enumeration.hasMoreElements()) {
                        parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
                        String string2 = parseTreeNode2.getToken().getTokenValue();
                        string = string == null ? string2 : String.valueOf(string) + "." + string2;
                        fieldDescriptorImpl2 = this.getFieldDesc(string, jDOClassDescriptor);
                    }
                    if (fieldDescriptorImpl2 == null) {
                        throw new QueryException("An unknown field was requested: " + string + " (" + jDOClassDescriptor + ")");
                    }
                    stringBuffer.append(".").append(string);
                    vector.addElement(string);
                    jDOClassDescriptor = (JDOClassDescriptor)fieldDescriptorImpl2.getClassDescriptor();
                    if (jDOClassDescriptor == null && enumeration.hasMoreElements()) {
                        throw new QueryException("An non-reference field was requested: " + string + " (" + jDOClassDescriptor + ")");
                    }
                    ++n2;
                }
                fieldDescriptorImpl = fieldDescriptorImpl2;
                this._pathInfo.put(parseTreeNode, vector);
                this._fieldInfo.put(parseTreeNode, fieldDescriptorImpl2);
                Class clazz = fieldDescriptorImpl2.getFieldType();
                boolean bl3 = Types.isSimpleType(clazz);
                if (bl) {
                    this._projectionName = stringBuffer.toString();
                    if (bl3) {
                        if (n2 > 1 || fieldDescriptorImpl.getContainingClassDescriptor() != this._clsDesc) {
                            this._projectionType = 5;
                            return fieldDescriptorImpl;
                        }
                        this._projectionType = 6;
                        return fieldDescriptorImpl;
                    }
                    this._projectionType = 4;
                    return fieldDescriptorImpl;
                }
                if (bl3 || !bl2) return fieldDescriptorImpl;
                throw new QueryException("Only primitive values are allowed to be passed as parameters to Aggregate and SQL functions.");
            }
            case 50: {
                this._projectionType = 1;
                if (parseTreeNode.getChild(0).getToken().getTokenType() == 20) return fieldDescriptorImpl;
                this.checkProjection(parseTreeNode.getChild(0), false, false);
                return fieldDescriptorImpl;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                this._projectionType = 1;
                this.checkProjection(parseTreeNode.getChild(0), false, true);
                return fieldDescriptorImpl;
            }
            default: {
                this._projectionType = 2;
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    this.checkProjection((ParseTreeNode)enumeration.nextElement(), false, false);
                }
                break block0;
            }
        }
        return fieldDescriptorImpl;
    }

    private void checkSelectPart(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() == 3) {
            this.checkProjection(parseTreeNode.getChild(0), true, false);
            this._projectionAlias = parseTreeNode.getChild(1).getToken().getTokenValue();
        } else {
            this.checkProjection(parseTreeNode, true, false);
            this._projectionAlias = "";
        }
    }

    private void checkWhereClause(ParseTreeNode parseTreeNode) throws QueryException {
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 30: {
                this.checkProjection(parseTreeNode, false, false);
                break;
            }
            case 2: {
                Enumeration enumeration = parseTreeNode.children();
                if (enumeration.hasMoreElements()) {
                    if (parseTreeNode.getChild(0).getToken().getTokenType() != 25) break;
                    while (enumeration.hasMoreElements()) {
                        this.checkWhereClause((ParseTreeNode)enumeration.nextElement());
                    }
                    break;
                }
                this.checkField(parseTreeNode);
                break;
            }
            case 27: {
                this.checkParameter(parseTreeNode);
                break;
            }
            case 6: {
                this.checkField(parseTreeNode.getChild(0));
                this.checkInClauseRightSide(parseTreeNode.getChild(1));
            }
            default: {
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    this.checkWhereClause((ParseTreeNode)enumeration.nextElement());
                }
                break block0;
            }
        }
    }

    private void createQueryExpression() {
        switch (this._projectionType) {
            case 3: 
            case 4: 
            case 5: {
                this._queryExpr = this._engine.getFinder();
                break;
            }
            default: {
                this._queryExpr = this._engine.getQueryExpression();
                this.addSelectFromJoins();
            }
        }
        if (this._parseTree.getChild(0).getToken().getTokenType() == 41) {
            this._queryExpr.setDistinct(true);
        }
        Enumeration enumeration = this._parseTree.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode.getToken().getTokenType();
            switch (n) {
                case 7: {
                    this.addWhereClause(parseTreeNode);
                    break;
                }
                case 46: {
                    this._queryExpr.addOrderClause(this.getOrderClause(parseTreeNode));
                    break;
                }
                case 55: {
                    this.addLimitClause(parseTreeNode);
                    break;
                }
            }
        }
    }

    public JDOClassDescriptor getClassDescriptor() {
        return this._clsDesc;
    }

    private JDOFieldDescriptor getFieldDesc(String string, JDOClassDescriptor jDOClassDescriptor) {
        JDOClassDescriptor jDOClassDescriptor2 = jDOClassDescriptor;
        while (jDOClassDescriptor2 != null) {
            JDOFieldDescriptor jDOFieldDescriptor = jDOClassDescriptor2.getField(string);
            if (jDOFieldDescriptor != null) {
                return jDOFieldDescriptor;
            }
            jDOClassDescriptor2 = (JDOClassDescriptor)jDOClassDescriptor2.getExtends();
        }
        return null;
    }

    private JDOFieldDescriptor getJDOFieldDescriptor(ParseTreeNode parseTreeNode) throws QueryException {
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            if (n != 30 && n != 2) continue;
            return this.checkField(parseTreeNode2);
        }
        return null;
    }

    public Class getObjClass() {
        return this._objClass;
    }

    private String getOrderClause(ParseTreeNode parseTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(", ");
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            switch (n) {
                case 48: {
                    stringBuffer.append(this.getSQLExpr(parseTreeNode2.getChild(0))).append(" ASC ");
                    break;
                }
                case 49: {
                    stringBuffer.append(this.getSQLExpr(parseTreeNode2.getChild(0))).append(" DESC ");
                    break;
                }
                case 2: 
                case 30: {
                    stringBuffer.append(this.getSQLExpr(parseTreeNode2)).append(" ");
                    break;
                }
            }
        }
        stringBuffer.deleteCharAt(0).deleteCharAt(0);
        return stringBuffer.toString();
    }

    public Hashtable getParamInfo() {
        return this._paramInfo;
    }

    public Vector getPathInfo() {
        switch (this._projectionType) {
            case 4: 
            case 5: {
                ParseTreeNode parseTreeNode = this._parseTree.getChild(0).getToken().getTokenType() == 41 ? this._parseTree.getChild(1) : this._parseTree.getChild(0);
                if (parseTreeNode.getToken().getTokenType() == 3) {
                    parseTreeNode = parseTreeNode.getChild(0);
                }
                return (Vector)this._pathInfo.get(parseTreeNode);
            }
        }
        return null;
    }

    public int getProjectionType() {
        return this._projectionType;
    }

    public QueryExpression getQueryExpression() {
        return this._queryExpr;
    }

    private String getSQLExpr(ParseTreeNode parseTreeNode) {
        StringBuffer stringBuffer = null;
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 25: {
                return "( " + this.getSQLExpr(parseTreeNode.getChild(0)) + " )";
            }
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                if (parseTreeNode.getChildCount() == 1) {
                    return String.valueOf(parseTreeNode.getToken().getTokenValue()) + " " + this.getSQLExpr(parseTreeNode.getChild(0));
                }
                return String.valueOf(this.getSQLExpr(parseTreeNode.getChild(0))) + " " + parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(1));
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return String.valueOf(this.getSQLExpr(parseTreeNode.getChild(0))) + " " + parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(1));
            }
            case 40: {
                return String.valueOf(this.getSQLExpr(parseTreeNode.getChild(0))) + " " + parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(1)) + " AND " + this.getSQLExpr(parseTreeNode.getChild(2));
            }
            case 42: {
                return String.valueOf(this.getSQLExpr(parseTreeNode.getChild(0))) + " IS NOT NULL ";
            }
            case 43: {
                return String.valueOf(this.getSQLExpr(parseTreeNode.getChild(0))) + " IS NULL ";
            }
            case 50: {
                if (parseTreeNode.getChild(0).getToken().getTokenType() == 20) {
                    return " COUNT(*) ";
                }
                return " COUNT(" + this.getSQLExpr(parseTreeNode.getChild(0)) + ") ";
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return " " + parseTreeNode.getToken().getTokenValue() + "(" + this.getSQLExpr(parseTreeNode.getChild(0)) + ") ";
            }
            case 44: {
                stringBuffer = new StringBuffer("( ");
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(this.getSQLExpr((ParseTreeNode)enumeration.nextElement())).append(" , ");
                }
                stringBuffer.replace(stringBuffer.length() - 2, stringBuffer.length() - 1, " )").append(" ");
                return stringBuffer.toString();
            }
            case 2: 
            case 30: {
                Object object;
                Object object2;
                Object object3;
                if (parseTreeNode.getChildCount() > 0 && parseTreeNode.getChild(0).getToken().getTokenType() == 25) {
                    stringBuffer = new StringBuffer(parseTreeNode.getToken().getTokenValue()).append("(");
                    int n2 = 0;
                    Enumeration enumeration = parseTreeNode.children();
                    enumeration = ((ParseTreeNode)enumeration.nextElement()).children();
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append(this.getSQLExpr((ParseTreeNode)enumeration.nextElement())).append(" , ");
                        ++n2;
                    }
                    if (n2 > 0) {
                        stringBuffer.replace(stringBuffer.length() - 2, stringBuffer.length() - 1, " )");
                    } else {
                        stringBuffer.append(") ");
                    }
                    return stringBuffer.toString();
                }
                if (n == 30) {
                    object3 = (Vector)this._pathInfo.get(parseTreeNode);
                    if (object3 == null) {
                        System.err.println("exprTree=" + parseTreeNode.toStringEx() + "\npathInfo = {");
                        object2 = this._pathInfo.keys();
                        while (object2.hasMoreElements()) {
                            object = (ParseTreeNode)object2.nextElement();
                            System.err.println("\t" + ((ParseTreeNode)object).toStringEx());
                        }
                    }
                    this.addJoinsForPathExpression((Vector)object3);
                }
                if ((object3 = (JDOFieldDescriptor)this._fieldInfo.get(parseTreeNode)) == null) {
                    throw new IllegalStateException("fieldInfo for " + parseTreeNode.toStringEx() + " not found");
                }
                object2 = (JDOClassDescriptor)((FieldDescriptorImpl)object3).getContainingClassDescriptor();
                if (object2 == null) {
                    throw new IllegalStateException("ContainingClass of " + ((JDOFieldDescriptor)object3).toString() + " is null !");
                }
                object = this.buildTableAlias(((JDOClassDescriptor)object2).getTableName(), (Vector)this._pathInfo.get(parseTreeNode));
                this._queryExpr.addTable(((JDOClassDescriptor)object2).getTableName(), (String)object);
                return this._queryExpr.encodeColumn((String)object, ((JDOFieldDescriptor)object3).getSQLName()[0]);
            }
            case 27: {
                return "?" + parseTreeNode.getChild(parseTreeNode.getChildCount() - 1).getToken().getTokenValue();
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return parseTreeNode.getToken().getTokenValue();
            }
            case 36: {
                stringBuffer = new StringBuffer();
                String string = new String(parseTreeNode.getToken().getTokenValue());
                int n3 = string.indexOf("\\\"", 1);
                while (n3 != -1) {
                    stringBuffer.append(string.substring(0, n3)).append("\"\"");
                    string = string.substring(n3 + 2);
                    n3 = string.indexOf("\\\"");
                }
                stringBuffer.append(string);
                string = stringBuffer.deleteCharAt(0).toString();
                stringBuffer.setLength(0);
                stringBuffer.append("'");
                n3 = string.indexOf("'", 1);
                while (n3 != -1) {
                    stringBuffer.append(string.substring(0, n3)).append("''");
                    string = string.substring(n3 + 1);
                    n3 = string.indexOf("'");
                }
                stringBuffer.append(string);
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "'");
                return stringBuffer.toString();
            }
            case 37: 
            case 38: {
                return parseTreeNode.getToken().getTokenValue().substring(5);
            }
            case 39: {
                return parseTreeNode.getToken().getTokenValue().substring(10);
            }
            case 28: 
            case 29: {
                return " NULL ";
            }
            case 55: {
                return this.getSQLExprForLimit(parseTreeNode);
            }
        }
        return "";
    }

    private String getSQLExprForLimit(ParseTreeNode parseTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            switch (n) {
                case 27: {
                    stringBuffer.append("?" + parseTreeNode2.getChild(parseTreeNode2.getChildCount() - 1).getToken().getTokenValue());
                    break;
                }
                case 45: {
                    stringBuffer.append(" , ");
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    return parseTreeNode2.getToken().getTokenValue();
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getTypeForComparison(ParseTreeNode parseTreeNode) throws QueryException {
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            if (n != 30 && n != 2) continue;
            JDOFieldDescriptor jDOFieldDescriptor = this.checkField(parseTreeNode2);
            return jDOFieldDescriptor.getFieldType().getName();
        }
        throw new QueryException("Could not get type for comparison.");
    }
}

