/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ClassValidator;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XPathLocation;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;

public class Validator
implements ClassValidator {
    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ClassDescriptorResolver classDescriptorResolver) throws ValidationException {
        if (object == null) {
            throw new ValidationException("Cannot validate a null Object.");
        }
        if (classDescriptorResolver == null) {
            classDescriptorResolver = new ClassDescriptorResolverImpl();
        }
        XMLClassDescriptor xMLClassDescriptor = null;
        if (!MarshalFramework.isPrimitive(object.getClass())) {
            xMLClassDescriptor = classDescriptorResolver.resolve(object.getClass());
        }
        if (xMLClassDescriptor == null) {
            return;
        }
        TypeValidator typeValidator = xMLClassDescriptor.getValidator();
        XMLFieldDescriptor xMLFieldDescriptor = null;
        try {
            if (typeValidator != null) {
                if (typeValidator instanceof ClassValidator) {
                    ((ClassValidator)typeValidator).validate(object, classDescriptorResolver);
                } else {
                    typeValidator.validate(object);
                }
            } else {
                FieldDescriptor[] fieldDescriptorArray = xMLClassDescriptor.getFields();
                if (fieldDescriptorArray != null) {
                    int n = 0;
                    while (n < fieldDescriptorArray.length) {
                        FieldValidator fieldValidator;
                        xMLFieldDescriptor = (XMLFieldDescriptor)fieldDescriptorArray[n];
                        if (xMLFieldDescriptor != null && (fieldValidator = xMLFieldDescriptor.getValidator()) != null) {
                            fieldValidator.validate(object, classDescriptorResolver);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (ValidationException validationException) {
            XPathLocation xPathLocation = (XPathLocation)validationException.getLocation();
            if (xPathLocation == null) {
                xPathLocation = new XPathLocation();
                validationException.setLocation(xPathLocation);
                if (xMLFieldDescriptor != null) {
                    if (xMLFieldDescriptor.getNodeType() == NodeType.Attribute) {
                        xPathLocation.addAttribute(xMLFieldDescriptor.getXMLName());
                    } else {
                        xPathLocation.addChild(xMLFieldDescriptor.getXMLName());
                    }
                }
            }
            xPathLocation.addParent(xMLClassDescriptor.getXMLName());
            throw validationException;
        }
    }
}

