/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.xml.XMLFieldHandler;

public class DateFieldHandler
extends XMLFieldHandler {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String DATE_FORMAT_2 = "yyyy-MM-dd'T'HH:mm:ss";
    private FieldHandler handler = null;

    public DateFieldHandler(FieldHandler fieldHandler) {
        if (fieldHandler == null) {
            String string = "The FieldHandler argument passed to the constructor of DateFieldHandler must not be null.";
            throw new IllegalArgumentException(string);
        }
        this.handler = fieldHandler;
    }

    public void checkValidity(Object object) throws ValidityException, IllegalStateException {
    }

    public Object getValue(Object object) throws IllegalStateException {
        Object object2 = this.handler.getValue(object);
        if (object2 == null) {
            return object2;
        }
        Object object3 = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        if (object2.getClass().isArray()) {
            int n = Array.getLength(object2);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                Object object4 = Array.get(object2, n2);
                stringArray[n2] = object4 instanceof Date ? simpleDateFormat.format((Date)object4) : object4.toString();
                ++n2;
            }
            object3 = stringArray;
        } else {
            object3 = object2 instanceof Date ? simpleDateFormat.format((Date)object2) : object2.toString();
        }
        return object3;
    }

    public Object newInstance(Object object) throws IllegalStateException {
        return new Date();
    }

    public void resetValue(Object object) throws IllegalStateException {
        this.handler.resetValue(object);
    }

    public void setValue(Object object, Object object2) throws IllegalStateException {
        Date date = null;
        if (!(object2 instanceof Date)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            if (object2.toString().indexOf(".") == -1) {
                simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_2);
            }
            try {
                date = simpleDateFormat.parse(object2.toString());
            }
            catch (ParseException parseException) {
                if (object2 == null) {
                    date = new Date();
                }
                throw new IllegalStateException("Bad 'timeInstant' format:it should be yyyy-MM-dd'T'HH:mm:ss.SSS.\n");
            }
        } else {
            date = (Date)object2;
        }
        this.handler.setValue(object, date);
    }
}

