/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;

public class ComplexType
extends XMLType
implements ContentModelGroup,
Referable {
    private AttributeGroupDecl attributes = null;
    private ContentType content = ContentType.elemOnly;
    private String type = null;
    private boolean _complexContent = false;
    private boolean _simpleContent = false;
    private boolean _restricted = false;
    private String base = null;
    private ContentModelGroup _contentModel = null;
    private String block = null;
    private Wildcard _anyAttribute = null;
    private Structure _parent = null;

    public ComplexType(Schema schema) {
        this(schema, null);
    }

    public ComplexType(Schema schema, String string) {
        if (schema == null) {
            String string2 = String.valueOf(XMLType.NULL_ARGUMENT) + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this.setSchema(schema);
        this.setName(string);
        this.attributes = new AttributeGroupDecl(schema);
        this._contentModel = new ContentModelGroupImpl();
    }

    public void addAttributeDecl(AttributeDecl attributeDecl) throws SchemaException {
        this.attributes.addAttribute(attributeDecl);
    }

    public void addAttributeGroupReference(AttributeGroupReference attributeGroupReference) {
        this.attributes.addReference(attributeGroupReference);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        this._contentModel.addElementDecl(elementDecl);
    }

    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    public void addGroup(ModelGroup modelGroup) throws SchemaException {
        this._contentModel.addGroup(modelGroup);
        modelGroup.setParent(this);
    }

    public AttributeDecl createAttributeDecl(String string) {
        return new AttributeDecl(this.getSchema(), string);
    }

    public Enumeration enumerate() {
        return this._contentModel.enumerate();
    }

    public Wildcard getAnyAttribute() {
        return this._anyAttribute;
    }

    public AttributeDecl getAttributeDecl(String string) {
        return this.attributes.getAttribute(string);
    }

    public Enumeration getAttributeDecls() {
        return this.attributes.getAttributes();
    }

    public AttributeGroupDecl getAttributeGroup() {
        return this.attributes;
    }

    public XMLType getBaseType() {
        if (this.base != null && super.getBaseType() == null) {
            this.setBaseType(this.getSchema().getType(this.base));
        }
        return super.getBaseType();
    }

    public String getBlock() {
        return this.block;
    }

    public ContentType getContentType() {
        return this.content;
    }

    public int getMaxOccurs() {
        Particle particle;
        if (this._contentModel.getParticleCount() > 0 && (particle = this._contentModel.getParticle(0)) instanceof ContentModelGroup) {
            return particle.getMaxOccurs();
        }
        return this._contentModel.getMaxOccurs();
    }

    public int getMinOccurs() {
        Particle particle;
        if (this._contentModel.getParticleCount() > 0 && (particle = this._contentModel.getParticle(0)) instanceof ContentModelGroup) {
            return particle.getMinOccurs();
        }
        return this._contentModel.getMinOccurs();
    }

    public Structure getParent() {
        return this._parent;
    }

    public Particle getParticle(int n) {
        return this._contentModel.getParticle(n);
    }

    public int getParticleCount() {
        return this._contentModel.getParticleCount();
    }

    public String getReferenceId() {
        return "archetype:" + this.getName();
    }

    public short getStructureType() {
        return 5;
    }

    public boolean isComplexContent() {
        return this._complexContent;
    }

    public boolean isRestricted() {
        return this._restricted;
    }

    public boolean isSimpleContent() {
        return this._simpleContent;
    }

    public boolean isTopLevel() {
        if (this.getName() == null) {
            return false;
        }
        if (this.getSchema() == null) {
            return false;
        }
        return this.getSchema().getComplexType(this.getName()) == this;
    }

    public void setAnyAttribute(Wildcard wildcard) throws SchemaException {
        if (wildcard != null) {
            if (this._anyAttribute != null) {
                String string = "<anyAttribute> already set in this complexType: " + this.getName();
                throw new SchemaException(string);
            }
            if (!wildcard.isAttributeWildcard()) {
                String string = "In complexType, " + this.getName() + "the wildcard must be an <anyAttribute>";
                throw new SchemaException(string);
            }
        }
        this._anyAttribute = wildcard;
    }

    public void setBase(String string) {
        this.base = string;
    }

    public void setBlock(String string) {
        this.block = string;
    }

    public void setComplexContent(boolean bl) {
        this._complexContent = bl;
    }

    public void setContentType(ContentType contentType) {
        this.content = contentType;
    }

    protected void setParent(Structure structure) {
        if (structure != null) {
            switch (structure.getStructureType()) {
                default: {
                    String string = "Invalid parent for ComplexType";
                    throw new IllegalArgumentException(string);
                }
                case 7: 
                case 12: 
            }
        }
        this._parent = structure;
    }

    public void setRestriction(boolean bl) {
        this._restricted = bl;
    }

    public void setSimpleContent(boolean bl) {
        this._simpleContent = bl;
    }

    public void useResolver(Resolver resolver) {
    }
}

