/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;

public class Group
extends Particle
implements ContentModelGroup,
Referable {
    private ContentModelGroup _contentModel = null;
    private String name = null;
    private boolean export = false;
    private Order order = Order.seq;
    private String _id = null;
    private boolean _isModelGroupDefinition = false;
    private Vector _wildcard;
    private Structure _parent = null;

    public Group() {
        this(null);
    }

    public Group(String string) {
        this.name = string;
        this._contentModel = new ContentModelGroupImpl();
        this._wildcard = new Vector();
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        this._contentModel.addElementDecl(elementDecl);
    }

    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    public void addGroup(ModelGroup modelGroup) throws SchemaException {
        this._contentModel.addGroup(modelGroup);
        modelGroup.setParent(this);
    }

    public void addWildcard(Wildcard wildcard) throws SchemaException {
        if (wildcard.isAttributeWildcard()) {
            throw new SchemaException("only <any> should be add in a group.");
        }
        this._wildcard.addElement(wildcard);
    }

    public Enumeration enumerate() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 9 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).enumerate();
        }
        return this._contentModel.enumerate();
    }

    public ContentModelGroup getContentModelGroup() {
        return this._contentModel;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.name;
    }

    public Order getOrder() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 9 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getOrder();
        }
        return this.order;
    }

    public Structure getParent() {
        return this._parent;
    }

    public Particle getParticle(int n) {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 9 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getParticle(n);
        }
        return this._contentModel.getParticle(n);
    }

    public int getParticleCount() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 9 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getParticleCount();
        }
        return this._contentModel.getParticleCount();
    }

    public String getReferenceId() {
        if (this.name != null) {
            return "group:" + this.name;
        }
        return null;
    }

    public short getStructureType() {
        return 9;
    }

    public Enumeration getWildcard() {
        return this._wildcard.elements();
    }

    public boolean isModelGroupDefinition() {
        return this._isModelGroupDefinition;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setIsModelGroupDefinition(boolean bl) {
        this._isModelGroupDefinition = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOrder(Order order) {
        this.order = order == null ? Order.all : order;
    }

    protected void setParent(Structure structure) {
        if (structure != null) {
            switch (structure.getStructureType()) {
                default: {
                    String string = "Invalid parent for group";
                    throw new IllegalArgumentException(string);
                }
                case 5: 
                case 9: 
                case 10: 
            }
        }
        this._parent = structure;
    }

    public void validate() throws ValidationException {
    }
}

