/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class FacetUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller = null;
    private int depth = 0;
    private Facet _facet = null;
    private String _elementName = null;

    public FacetUnmarshaller(String string, AttributeList attributeList) throws SAXException {
        this._elementName = string;
        if (!FacetUnmarshaller.isFacet(string)) {
            String string2 = "'" + string + "' is not a valid or supported facet.";
            throw new IllegalArgumentException(string2);
        }
        Object var3_4 = null;
        this._facet = new Facet(string, attributeList.getValue("value"));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return this._elementName;
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        if (this.unmarshaller == null) {
            throw new SAXException("missing start element: " + string);
        }
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._facet.addAnnotation(annotation);
        }
    }

    public Facet getFacet() {
        return this._facet;
    }

    public Object getObject() {
        return this.getFacet();
    }

    protected static boolean isFacet(String string) {
        if ("enumeration".equals(string)) {
            return true;
        }
        if ("length".equals(string)) {
            return true;
        }
        if ("pattern".equals(string)) {
            return true;
        }
        if ("maxExclusive".equals(string)) {
            return true;
        }
        if ("minExclusive".equals(string)) {
            return true;
        }
        if ("maxInclusive".equals(string)) {
            return true;
        }
        if ("minInclusive".equals(string)) {
            return true;
        }
        if ("maxLength".equals(string)) {
            return true;
        }
        if ("minLength".equals(string)) {
            return true;
        }
        if ("whiteSpace".equals(string)) {
            return true;
        }
        if ("totalDigits".equals(string)) {
            return true;
        }
        return "fractionDigits".equals(string);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else {
            this.illegalElement(string);
        }
    }
}

