/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JMethod
implements JMember {
    private JModifiers modifiers = null;
    private JType returnType = null;
    private String name = null;
    private JNamedMap params = null;
    private JClass declaringClass = null;
    private JSourceCode source = null;
    private Vector exceptions = null;
    private JDocComment jdc = new JDocComment();

    public JMethod(JType jType, String string) {
        this.returnType = jType;
        this.name = string;
        this.modifiers = new JModifiers();
        this.params = new JNamedMap(3);
        this.source = new JSourceCode();
        this.exceptions = new Vector(1);
    }

    public void addException(JClass jClass) {
        if (jClass == null) {
            return;
        }
        String string = jClass.getName();
        int n = 0;
        while (n < this.exceptions.size()) {
            JClass jClass2 = (JClass)this.exceptions.elementAt(n);
            if (string.equals(jClass2.getName())) {
                return;
            }
            ++n;
        }
        this.exceptions.addElement(jClass);
    }

    public void addParameter(JParameter jParameter) throws IllegalArgumentException {
        if (jParameter == null) {
            return;
        }
        String string = jParameter.getName();
        if (this.params.get(string) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("A parameter already exists for this method, ");
            stringBuffer.append(this.name);
            stringBuffer.append(", with the name: ");
            stringBuffer.append(string);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        this.params.put(string, jParameter);
        this.jdc.addDescriptor(JDocDescriptor.createParamDesc(string, null));
        if (this.declaringClass != null && !jParameter.getType().isPrimitive()) {
            JClass jClass = (JClass)jParameter.getType();
            this.declaringClass.addImport(jClass.getName());
        }
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public JClass[] getExceptions() {
        Object[] objectArray = new JClass[this.exceptions.size()];
        this.exceptions.copyInto(objectArray);
        return objectArray;
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public JParameter getParameter(int n) {
        return (JParameter)this.params.get(n);
    }

    protected String[] getParameterClassNames() {
        Object object;
        Vector<String> vector = new Vector<String>(this.params.size());
        int n = 0;
        while (n < this.params.size()) {
            object = ((JParameter)this.params.get(n)).getType();
            while (((JType)object).isArray()) {
                object = ((JType)object).getComponentType();
            }
            if (!((JType)object).isPrimitive()) {
                JClass jClass = (JClass)object;
                vector.addElement(jClass.getName());
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public synchronized JParameter[] getParameters() {
        JParameter[] jParameterArray = new JParameter[this.params.size()];
        int n = 0;
        while (n < jParameterArray.length) {
            jParameterArray[n] = (JParameter)this.params.get(n);
            ++n;
        }
        return jParameterArray;
    }

    public JType getReturnType() {
        return this.returnType;
    }

    public JSourceCode getSourceCode() {
        return this.source;
    }

    public void print(JSourceWriter jSourceWriter) {
        this.jdc.print(jSourceWriter);
        jSourceWriter.write(this.modifiers.toString());
        jSourceWriter.write(32);
        if (this.returnType != null) {
            jSourceWriter.write(this.returnType);
        } else {
            jSourceWriter.write("void");
        }
        jSourceWriter.write(32);
        jSourceWriter.write(this.name);
        jSourceWriter.write(40);
        int n = 0;
        while (n < this.params.size()) {
            if (n > 0) {
                jSourceWriter.write(", ");
            }
            jSourceWriter.write(this.params.get(n));
            ++n;
        }
        jSourceWriter.write(")");
        if (this.exceptions.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.write("    throws ");
            int n2 = 0;
            while (n2 < this.exceptions.size()) {
                if (n2 > 0) {
                    jSourceWriter.write(", ");
                }
                JClass jClass = (JClass)this.exceptions.elementAt(n2);
                jSourceWriter.write(jClass.getName());
                ++n2;
            }
        }
        if (this.modifiers.isAbstract()) {
            jSourceWriter.writeln(";");
        } else {
            jSourceWriter.writeln();
            jSourceWriter.writeln("{");
            this.source.print(jSourceWriter);
            jSourceWriter.write("} //-- ");
            jSourceWriter.writeln(this.toString());
        }
    }

    public void setComment(String string) {
        this.jdc.setComment(string);
    }

    protected void setDeclaringClass(JClass jClass) {
        this.declaringClass = jClass;
    }

    public void setModifiers(JModifiers jModifiers) {
        this.modifiers = jModifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void setName(String string) throws IllegalArgumentException {
        this.name = string;
    }

    public void setSourceCode(String string) {
        this.source = new JSourceCode(string);
    }

    public void setSourceCode(JSourceCode jSourceCode) {
        this.source = jSourceCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.returnType != null) {
            stringBuffer.append(this.returnType);
        } else {
            stringBuffer.append("void");
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        int n = 0;
        while (n < this.params.size()) {
            JParameter jParameter = (JParameter)this.params.get(n);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(jParameter.getType().getName());
            ++n;
        }
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }
}

