/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JCodeStatement;
import org.exolab.javasource.JSourceWriter;

public class JSourceCode {
    private Vector source = null;
    private short indentSize;
    private short currentIndent = this.indentSize = (short)4;

    public JSourceCode() {
        this.source = new Vector();
    }

    public JSourceCode(String string) {
        this();
        this.source.addElement(string);
    }

    public void add(String string) {
        JCodeStatement jCodeStatement = new JCodeStatement(string, this.currentIndent);
        this.source.addElement(jCodeStatement);
    }

    public void add(String string, short s) {
        JCodeStatement jCodeStatement = new JCodeStatement(string, s);
        this.source.addElement(jCodeStatement);
    }

    private void addCodeStatement(JCodeStatement jCodeStatement) {
        short s = (short)(jCodeStatement.getIndent() + this.currentIndent);
        this.source.addElement(new JCodeStatement(jCodeStatement.getStatement(), this.indentSize));
    }

    public void append(String string) {
        if (this.source.isEmpty()) {
            this.add(string);
        } else {
            JCodeStatement jCodeStatement = (JCodeStatement)this.source.lastElement();
            jCodeStatement.append(string);
        }
    }

    public void clear() {
        this.source.removeAllElements();
    }

    public void copyInto(JSourceCode jSourceCode) {
        int n = 0;
        while (n < this.source.size()) {
            this.addCodeStatement((JCodeStatement)this.source.elementAt(n));
            ++n;
        }
    }

    public void indent() {
        this.currentIndent = (short)(this.currentIndent + this.indentSize);
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public void print(JSourceWriter jSourceWriter) {
        int n = 0;
        while (n < this.source.size()) {
            jSourceWriter.writeln(this.source.elementAt(n));
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        int n = 0;
        while (n < this.source.size()) {
            stringBuffer.append(this.source.elementAt(n).toString());
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void unindent() {
        this.currentIndent = (short)(this.currentIndent - this.indentSize);
    }
}

