/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.engine;

import com.tombrus.cleanImports.model.Dependency;
import com.tombrus.cleanImports.model.Import;
import com.tombrus.cleanImports.model.ImportList;
import com.tombrus.cleanImports.parser.ImportInfoProvider;
import com.tombrus.util.DB;
import com.tombrus.util.InternalProblem;
import com.tombrus.util.MapOfSets;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ImportGenerator {
    public boolean DEBUG = false;
    private ImportList imports = new ImportList();
    private ImportList ownImports = new ImportList();
    private ImportList javaLangImports = new ImportList();

    public ImportGenerator(File file, ImportInfoProvider importInfoProvider) {
        this.DEBUG = DB.ONE(file);
        this.makeImportLists(file, importInfoProvider);
    }

    public ImportList getImportList() {
        return this.imports;
    }

    public ImportList getOwnImportList() {
        return this.ownImports;
    }

    public ImportList getJavaLangImportList() {
        return this.javaLangImports;
    }

    private void makeImportLists(File file, ImportInfoProvider importInfoProvider) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Iterator<Object> iterator;
        Map map;
        Object object6;
        Object object7;
        if (this.DEBUG) {
            System.err.println("\nDetermining imports for " + file);
        }
        Set set = importInfoProvider.getDefinedClassNames(file);
        String string = importInfoProvider.getPackageName(file);
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            object7 = (String)iterator2.next();
            object6 = importInfoProvider.getUsedClassNames((String)object7);
            map = importInfoProvider.getVisibleInners((String)object7);
            if (this.DEBUG) {
                System.err.println("  within " + (String)object7);
            }
            iterator = ((HashMap)object6).keySet().iterator();
            block1: while (iterator.hasNext()) {
                object5 = (String)iterator.next();
                object4 = ImportGenerator.getLastBit((String)object5);
                object3 = (Set)((HashMap)object6).get(object5);
                if (this.DEBUG) {
                    System.err.println("    used=" + (String)object5);
                }
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Dependency)object2.next();
                    if (this.DEBUG) {
                        System.err.println("      as=" + ((Dependency)object).id);
                    }
                    if (((Dependency)object).id.equals(((Dependency)object).toFull)) {
                        if (!this.DEBUG) continue;
                        System.err.println("        import FQN removed             : " + (String)object5);
                        continue;
                    }
                    bl = ((Dependency)object).id.indexOf(46) == -1;
                    Object object8 = object5;
                    if (!bl) {
                        object4 = ImportGenerator.getFirstBit(((Dependency)object).id);
                        object8 = ((String)object5).substring(0, ((String)object5).length() - ((Dependency)object).id.length() + ((String)object4).length());
                        if (this.DEBUG) {
                            System.err.println("         PARTIAL QUAL NAME: " + (String)object5 + " (" + ((Dependency)object).id + ") => " + (String)object8 + " (" + (String)object4 + ")");
                        }
                    }
                    if (map.containsKey(object4)) {
                        if (!((String)map.get(object4)).equals(object8)) {
                            new InternalProblem("PROBLEM: " + (String)object4 + " should resolve to " + (String)object8 + " but resolves to " + map.get(object4) + " in " + file);
                        } else if (this.DEBUG) {
                            System.err.println("        import auto resolved removed   : " + (String)object8);
                        }
                    } else {
                        if (this.DEBUG) {
                            System.err.println("         ACCEPTED: " + (String)object8);
                        }
                        this.imports.add(object8);
                    }
                    if (bl) continue block1;
                }
            }
        }
        object7 = new HashSet();
        object6 = this.imports.iterator();
        while (object6.hasNext()) {
            object7.add(((Import)object6.next()).getPackageName());
        }
        map = new MapOfSets();
        iterator = object7.iterator();
        while (iterator.hasNext()) {
            object5 = (String)iterator.next();
            object4 = importInfoProvider.getClassesInPackage((String)object5);
            if (object4 == null) {
                System.err.println("WARNING: no classes found for package " + (String)object5);
                System.err.println("         file  = " + file.getPath());
                continue;
            }
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                ((MapOfSets)map).putadd(object2, object5);
            }
        }
        object5 = ((HashMap)map).keySet().iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            object3 = (Set)((HashMap)map).get(object4);
            if (object3.size() == 1) {
                if (this.DEBUG) {
                    System.err.println("NO-AMBIG: " + (String)object4 + ": " + object3);
                }
                object5.remove();
                continue;
            }
            if (!this.DEBUG) continue;
            System.err.println("AMBIG   : " + (String)object4 + ": " + object3);
        }
        object4 = this.imports.iterator();
        while (object4.hasNext()) {
            object3 = (Import)object4.next();
            object2 = ((Import)object3).getPackageName();
            object = ((Import)object3).getClassName();
            bl = ((String)object2).equals(string);
            boolean bl2 = ((String)object2).equals("java.lang");
            boolean bl3 = importInfoProvider.getDefinedClassNames(file).contains(((Import)object3).getFullClassName());
            boolean bl4 = ((HashMap)map).containsKey(object);
            if (bl3) {
                if (this.DEBUG) {
                    System.err.println("    import of file's own class removed: " + object3);
                }
                object4.remove();
                continue;
            }
            if (bl4) {
                if (this.DEBUG) {
                    System.err.println("    import marked as ambiguous: " + object3 + " found in " + ((HashMap)map).get(object));
                }
                Set set2 = (Set)((HashMap)map).get(object);
                Iterator iterator3 = set2.iterator();
                while (iterator3.hasNext()) {
                    String string2 = (String)iterator3.next();
                    if (string2.equals(object2)) continue;
                    ((Import)object3).addAmbiguousWith(string2 + "." + (String)object);
                }
                continue;
            }
            if (bl) {
                if (this.DEBUG) {
                    System.err.println("    import from own package moved: " + object3);
                }
                object4.remove();
                this.ownImports.add(object3);
                continue;
            }
            if (!bl2) continue;
            if (this.DEBUG) {
                System.err.println("    import from java.lang moved  : " + object3);
            }
            object4.remove();
            this.javaLangImports.add(object3);
        }
        if (this.DEBUG) {
            System.err.println("  need      imports: " + this.imports);
            System.err.println("  own       imports: " + this.ownImports);
            System.err.println("  java.lang imports: " + this.javaLangImports);
        }
    }

    static String getFirstBit(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    static String getLastBit(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

