/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class FileSetSpecification {
    public File[] getFileArray() {
        return this.getFileSet().toArray(new File[0]);
    }

    public abstract Set getFileSet();

    public static ArrayList stringPathToArrayList(String string) {
        return FileSetSpecification.stringPathToArrayList(string, File.pathSeparatorChar);
    }

    public static ArrayList stringPathToArrayList(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(c, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (1 < n2 - n) {
                arrayList.add(string.substring(n, n2));
            }
            n = n2 + 1;
        }
        return arrayList;
    }

    public static class FileSetExcludes
    extends FileSetFilter {
        public FileSetExcludes(String string, FileSetSpecification fileSetSpecification) {
            super(new FileFilter(string){
                Pattern pattern;
                private final /* synthetic */ String val$re;
                {
                    this.val$re = string;
                    this.pattern = Pattern.compile(this.val$re);
                }

                public boolean accept(File file) {
                    return !this.pattern.matcher(file.getPath()).matches();
                }
            }, fileSetSpecification);
        }
    }

    public static class FileSetIncludes
    extends FileSetFilter {
        public FileSetIncludes(String string, FileSetSpecification fileSetSpecification) {
            super(new FileFilter(string){
                Pattern pattern;
                private final /* synthetic */ String val$re;
                {
                    this.val$re = string;
                    this.pattern = Pattern.compile(this.val$re);
                }

                public boolean accept(File file) {
                    return this.pattern.matcher(file.getPath()).matches();
                }
            }, fileSetSpecification);
        }
    }

    public static class FileSetWithExtension
    extends FileSetFilter {
        public FileSetWithExtension(String string, FileSetSpecification fileSetSpecification) {
            super(new FileFilter(string){
                private String extension;
                private final /* synthetic */ String val$ext;
                {
                    this.val$ext = string;
                    this.extension = this.val$ext.startsWith(".") ? this.val$ext : "." + this.val$ext;
                }

                public boolean accept(File file) {
                    return file.getPath().endsWith(this.extension);
                }
            }, fileSetSpecification);
        }
    }

    public static class FileSetFilter
    extends FileSetSpecification {
        private FileFilter filter;
        private FileSetSpecification spec;

        public FileSetFilter(FileFilter fileFilter, FileSetSpecification fileSetSpecification) {
            this.filter = fileFilter;
            this.spec = fileSetSpecification;
        }

        public Set getFileSet() {
            Set set = this.spec.getFileSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (this.filter.accept((File)iterator.next())) continue;
                iterator.remove();
            }
            return set;
        }
    }

    public static class FileSetMulti
    extends FileSetSpecification {
        private FileSetSpecification[] specs;

        public FileSetMulti(FileSetSpecification fileSetSpecification, FileSetSpecification fileSetSpecification2) {
            this.specs = new FileSetSpecification[]{fileSetSpecification, fileSetSpecification2};
        }

        public FileSetMulti(FileSetSpecification[] fileSetSpecificationArray) {
            this.specs = fileSetSpecificationArray;
        }

        public Set getFileSet() {
            HashSet<Set> hashSet = new HashSet<Set>();
            int n = 0;
            while (n < this.specs.length) {
                hashSet.add(this.specs[n].getFileSet());
                ++n;
            }
            return hashSet;
        }
    }

    public static class FileSetRoot
    extends FileSetSpecification {
        private File[] filesOrDirs;

        public FileSetRoot(String string) {
            this(FileSetSpecification.stringPathToArrayList(string).toArray(new String[0]));
        }

        public FileSetRoot(String[] stringArray) {
            this.filesOrDirs = new File[stringArray.length];
            int n = 0;
            while (n < this.filesOrDirs.length) {
                this.filesOrDirs[n] = new File(stringArray[n]);
                ++n;
            }
        }

        public FileSetRoot(File file) {
            this(new File[]{file});
        }

        public FileSetRoot(File[] fileArray) {
            this.filesOrDirs = fileArray;
        }

        public Set getFileSet() {
            return this.addAllFiles(new HashSet(), this.filesOrDirs);
        }

        private Set addAllFiles(Set set, File[] fileArray) {
            int n = 0;
            while (n < fileArray.length) {
                set = this.addAllFiles(set, fileArray[n]);
                ++n;
            }
            return set;
        }

        private Set addAllFiles(Set set, File file) {
            if (file.isDirectory()) {
                set = this.addAllFiles(set, file.listFiles());
            } else {
                set.add(file);
            }
            return set;
        }
    }
}

