/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FTPClient {
    private static String cvsId = "@(#)$Id: FTPClient.java,v 1.4 2002/11/19 22:01:25 bruceb Exp $";
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private FTPControlSocket control = null;
    private FTPDataSocket data = null;
    private int timeout = 0;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    private FTPReply lastValidReply;

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, controlPort);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, controlPort);
    }

    public void chdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void debugResponses(boolean on) {
        this.control.debugResponses(on);
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        String reply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        String command;
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string = command = full ? "LIST " : "NLST ";
        if (dirname != null) {
            command = String.valueOf(command) + dirname;
        }
        command = command.trim();
        String reply = this.control.sendCommand(command);
        String[] validCodes1 = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes1);
        LineNumberReader in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        Vector<String> lines = new Vector<String>();
        String line = null;
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        try {
            in.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        String[] validCodes2 = new String[]{"226", "250", "550"};
        reply = this.control.readReply();
        this.lastValidReply = this.control.validateReply(reply, validCodes2);
        String[] result = new String[]{};
        if (!this.lastValidReply.getReplyCode().equals("550")) {
            result = lines.toArray(new String[0]);
        }
        return result;
    }

    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(destStream, remoteFile);
        } else {
            this.getBinary(destStream, remoteFile);
        }
        this.validateTransfer();
    }

    public byte[] get(String remoteFile) throws IOException, FTPException {
        int count;
        this.initGet(remoteFile);
        BufferedInputStream in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        byte[] resultBuf = null;
        ByteArrayOutputStream temp = new ByteArrayOutputStream(chunksize);
        while ((count = in.read(chunk, 0, chunksize)) >= 0) {
            temp.write(chunk, 0, count);
        }
        temp.close();
        resultBuf = temp.toByteArray();
        try {
            in.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        this.validateTransfer();
        return resultBuf;
    }

    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(localPath, remoteFile);
        } else {
            this.getBinary(localPath, remoteFile);
        }
        this.validateTransfer();
    }

    private void getASCII(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(destStream));
        LineNumberReader in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        IOException storedEx = null;
        String line = null;
        try {
            try {
                while ((line = in.readLine()) != null) {
                    out.write(line, 0, line.length());
                    out.newLine();
                }
            }
            catch (IOException ex) {
                storedEx = ex;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            out.close();
            throw throwable;
        }
        out.close();
        try {
            in.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        if (storedEx != null) {
            throw storedEx;
        }
    }

    private void getASCII(String localPath, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        File localFile = new File(localPath);
        BufferedWriter out = new BufferedWriter(new FileWriter(localPath));
        LineNumberReader in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        IOException storedEx = null;
        String line = null;
        try {
            try {
                while ((line = in.readLine()) != null) {
                    out.write(line, 0, line.length());
                    out.newLine();
                }
            }
            catch (IOException ex) {
                storedEx = ex;
                localFile.delete();
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            out.close();
            throw throwable;
        }
        out.close();
        try {
            in.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        if (storedEx != null) {
            throw storedEx;
        }
    }

    private void getBinary(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        BufferedOutputStream out = new BufferedOutputStream(destStream);
        BufferedInputStream in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        IOException storedEx = null;
        try {
            try {
                int count;
                while ((count = in.read(chunk, 0, chunksize)) >= 0) {
                    out.write(chunk, 0, count);
                }
            }
            catch (IOException ex) {
                storedEx = ex;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            out.close();
            throw throwable;
        }
        out.close();
        try {
            in.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        if (storedEx != null) {
            throw storedEx;
        }
    }

    private void getBinary(String localPath, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        File localFile = new File(localPath);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localPath, false));
        BufferedInputStream in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        IOException storedEx = null;
        try {
            try {
                int count;
                while ((count = in.read(chunk, 0, chunksize)) >= 0) {
                    out.write(chunk, 0, count);
                }
            }
            catch (IOException ex) {
                storedEx = ex;
                localFile.delete();
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            out.close();
            throw throwable;
        }
        out.close();
        try {
            in.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        if (storedEx != null) {
            throw storedEx;
        }
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public String help(String command) throws IOException, FTPException {
        String reply = this.control.sendCommand("HELP " + command);
        String[] validCodes = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    private void initGet(String remoteFile) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String reply = this.control.sendCommand("RETR " + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes1);
    }

    private void initPut(String remoteFile, boolean append) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String cmd = append ? "APPE " : "STOR ";
        String reply = this.control.sendCommand(String.valueOf(cmd) + remoteFile);
        String[] validCodes = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public static void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        ((Hashtable)props).put("socksProxyPort", port);
        ((Hashtable)props).put("socksProxyHost", host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        ((Hashtable)props).put("java.net.socks.username", username);
        ((Hashtable)props).put("java.net.socks.password", password);
        System.setProperties(props);
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] list = this.dir(dirname, full);
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        int i = 0;
        while (i < list.length) {
            result.append(list[i]);
            result.append(sep);
            ++i;
        }
        return result.toString();
    }

    public void login(String user, String password) throws IOException, FTPException {
        String response = this.control.sendCommand("USER " + user);
        this.lastValidReply = this.control.validateReply(response, "331");
        response = this.control.sendCommand("PASS " + password);
        this.lastValidReply = this.control.validateReply(response, "230");
    }

    public void mkdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("MKD " + dir);
        this.lastValidReply = this.control.validateReply(reply, "257");
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        String reply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "213");
        Date ts = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return ts;
    }

    public void password(String password) throws IOException, FTPException {
        String reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        this.put(srcStream, remoteFile, false);
    }

    public void put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(srcStream, remoteFile, append);
        } else {
            this.putBinary(srcStream, remoteFile, append);
        }
        this.validateTransfer();
    }

    public void put(String localPath, String remoteFile) throws IOException, FTPException {
        this.put(localPath, remoteFile, false);
    }

    public void put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(localPath, remoteFile, append);
        } else {
            this.putBinary(localPath, remoteFile, append);
        }
        this.validateTransfer();
    }

    public void put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        this.put(bytes, remoteFile, false);
    }

    public void put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        this.initPut(remoteFile, append);
        BufferedOutputStream out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        out.write(bytes, 0, bytes.length);
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
        this.validateTransfer();
    }

    private void putASCII(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(srcStream));
        this.initPut(remoteFile, append);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.data.getOutputStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            out.write(line, 0, line.length());
            out.write("\r\n", 0, "\r\n".length());
        }
        in.close();
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    private void putASCII(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        this.putASCII(srcStream, remoteFile, append);
    }

    private void putBinary(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        BufferedInputStream in = new BufferedInputStream(srcStream);
        this.initPut(remoteFile, append);
        BufferedOutputStream out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        byte[] buf = new byte[512];
        int count = 0;
        while ((count = in.read(buf)) > 0) {
            out.write(buf, 0, count);
        }
        in.close();
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    private void putBinary(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        this.putBinary(srcStream, remoteFile, append);
    }

    public String pwd() throws IOException, FTPException {
        String reply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(reply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start >= 0 && end > start) {
            return text.substring(start, end);
        }
        return text;
    }

    public void quit() throws IOException, FTPException {
        try {
            String reply = this.control.sendCommand("QUIT");
            String[] validCodes = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(reply, validCodes);
        }
        finally {
            Object var2_3 = null;
            this.control.logout();
            this.control = null;
        }
    }

    public void quote(String command, String[] validCodes) throws IOException, FTPException {
        String reply = this.control.sendCommand(command);
        if (validCodes != null && validCodes.length > 0) {
            this.lastValidReply = this.control.validateReply(reply, validCodes);
        }
    }

    public void rename(String from, String to) throws IOException, FTPException {
        String reply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("RMD " + dir);
        String[] validCodes = new String[]{"250", "257"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public void setLogStream(PrintWriter log) {
        this.control.setLogStream(log);
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        this.control.setTimeout(millis);
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        String reply = this.control.sendCommand("TYPE " + typeStr);
        this.lastValidReply = this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public boolean site(String command) throws IOException, FTPException {
        String reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "502"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return reply.substring(0, 3).equals("200");
    }

    public String system() throws IOException, FTPException {
        String reply = this.control.sendCommand("SYST");
        this.lastValidReply = this.control.validateReply(reply, "215");
        return this.lastValidReply.getReplyText();
    }

    public void user(String user) throws IOException, FTPException {
        String reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void validateTransfer() throws IOException, FTPException {
        String[] validCodes = new String[]{"226", "250"};
        String reply = this.control.readReply();
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }
}

