/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hsqldb.Embedded_Server;
import org.hsqldb.jdbcDriver;
import org.hsqldb.util.Embedded_DatabaseManager;
import org.jboss.jdbc.HypersonicDatabaseMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class HypersonicDatabase
extends ServiceMBeanSupport
implements HypersonicDatabaseMBean,
MBeanRegistration {
    Embedded_Server embeddedDBServer;
    File dbPath;
    String name = "default";
    int port = 1476;
    boolean silent = true;
    boolean trace = false;

    public void setDatabase(String name) {
        this.name = name;
    }

    public String getDatabase() {
        return this.name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public String getDatabasePath() {
        return this.dbPath.toString();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? HypersonicDatabaseMBean.OBJECT_NAME : name;
    }

    public void startDatabaseManager() {
        new Thread(){

            public void run() {
                try {
                    String[] args = new String[]{Integer.toString(HypersonicDatabase.this.port)};
                    Embedded_DatabaseManager.main((String[])args);
                }
                catch (Exception e) {
                    ServiceMBeanSupport.access$001((HypersonicDatabase)HypersonicDatabase.this).error((Object)"Failed to start database manager", (Throwable)e);
                }
            }
        }.start();
    }

    protected void startService() throws Exception {
        File dataDir = ServerConfigLocator.locate().getServerDataDir();
        this.dbPath = new File(dataDir, "hypersonic");
        if (!this.dbPath.exists()) {
            this.dbPath.mkdirs();
        }
        if (!this.dbPath.isDirectory()) {
            throw new IOException("Failed to create directory: " + this.dbPath);
        }
        final File prefix = new File(this.dbPath, this.name);
        new Thread("hypersonic-" + this.name){

            public void run() {
                try {
                    String[] args = new String[]{"-database", prefix.toString(), "-port", String.valueOf(HypersonicDatabase.this.port), "-silent", String.valueOf(HypersonicDatabase.this.silent), "-trace", String.valueOf(HypersonicDatabase.this.trace)};
                    Embedded_Server.main((String[])args);
                }
                catch (Exception e) {
                    ServiceMBeanSupport.access$101((HypersonicDatabase)HypersonicDatabase.this).error((Object)"Failed to start database", (Throwable)e);
                }
            }
        }.start();
    }

    protected void stopService() throws Exception {
        String cmd = "SHUTDOWN";
        String jdbcDriver2 = "org.hsqldb.jdbcDriver";
        String dbStrVersion_1_6 = "jdbc:hsqldb:hsql://localhost:" + this.port;
        String user = "sa";
        String password = "";
        try {
            new jdbcDriver();
            Class.forName(jdbcDriver2).newInstance();
            Connection connection = DriverManager.getConnection(dbStrVersion_1_6, user, password);
            Statement statement = connection.createStatement();
            statement.executeQuery(cmd);
            this.log.info((Object)"Database closed clean");
            Object var9_8 = null;
            this.embeddedDBServer = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.embeddedDBServer = null;
            throw throwable;
        }
    }

    static /* synthetic */ Logger access$001(HypersonicDatabase x0) {
        return x0.log;
    }

    static /* synthetic */ Logger access$101(HypersonicDatabase x0) {
        return x0.log;
    }
}

