/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsqldb.Cache;
import org.hsqldb.Channel;
import org.hsqldb.Database;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.StringConverter;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Log
implements Runnable {
    private static final int COPY_BLOCK_SIZE = 65536;
    private FileInputStream fProperties;
    private Properties pProperties;
    private String sName;
    private Database dDatabase;
    private Channel cSystem;
    private Writer wScript;
    private String sFileProperties;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize = 200;
    private int iLogCount;
    private Thread tRunner;
    private volatile boolean bNeedFlush;
    private volatile boolean bWriteDelay;
    private int mLastId;
    Cache cCache;

    Log(Database db, Channel system, String name) throws SQLException {
        this.dDatabase = db;
        this.cSystem = system;
        this.sName = name;
        this.sFileProperties = this.sName + ".properties";
        this.pProperties = new Properties();
        this.tRunner = new Thread(this);
        this.tRunner.start();
    }

    public void run() {
        while (this.tRunner != null) {
            try {
                Thread.sleep(1000L);
                if (!this.bNeedFlush) continue;
                this.wScript.flush();
                this.bNeedFlush = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setWriteDelay(boolean delay) {
        this.bWriteDelay = delay;
    }

    boolean open() throws SQLException {
        if (!new File(this.sFileProperties).exists()) {
            this.create();
            this.open();
            return true;
        }
        this.loadProperties();
        this.sFileScript = this.pProperties.getProperty("script", this.sName + ".script");
        this.sFileCache = this.pProperties.getProperty("data", this.sName + ".data");
        this.sFileBackup = this.pProperties.getProperty("backup", this.sName + ".backup");
        String version = this.pProperties.getProperty("version", "1.0");
        boolean check = version.substring(0, 3).compareTo("1.6") <= 0;
        this.pProperties.setProperty("version", "1.6");
        Trace.check(check, 29);
        if (this.pProperties.getProperty("readonly", "false").equals("true")) {
            this.bReadOnly = true;
            this.dDatabase.setReadOnly();
            this.cCache = new Cache(this.sFileCache);
            this.cCache.open(true);
            this.runScript();
            return false;
        }
        boolean needbackup = false;
        String state = this.pProperties.getProperty("modified", "no");
        if (state.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (state.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(0);
            }
            this.restoreBackup();
            needbackup = true;
        }
        ((Hashtable)this.pProperties).put("modified", "yes");
        this.saveProperties();
        this.cCache = new Cache(this.sFileCache);
        this.cCache.open(false);
        this.runScript();
        if (needbackup) {
            this.close(false);
            ((Hashtable)this.pProperties).put("modified", "yes");
            this.saveProperties();
            this.cCache.open(false);
        }
        this.openScript();
        return false;
    }

    void stop() {
        this.tRunner = null;
    }

    void close(boolean compact) throws SQLException {
        if (this.bReadOnly) {
            return;
        }
        this.closeScript();
        this.writeScript(compact);
        this.cCache.flush();
        this.backup();
        ((Hashtable)this.pProperties).put("modified", "yes-new-files");
        this.saveProperties();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        ((Hashtable)this.pProperties).put("modified", "no");
        this.saveProperties();
        this.closeProperties();
        if (compact) {
            this.stop();
            new File(this.sFileCache).delete();
            new File(this.sFileBackup).delete();
            Database db = new Database(this.sName);
            db.getLog().close(false);
        }
    }

    void checkpoint() throws SQLException {
        this.close(false);
        ((Hashtable)this.pProperties).put("modified", "yes");
        this.saveProperties();
        this.cCache.open(false);
        this.openScript();
    }

    void setLogSize(int mb) {
        this.iLogSize = mb;
    }

    void write(Channel c, String s) throws SQLException {
        if (this.bRestoring || s == null || s.equals("")) {
            return;
        }
        if (!this.bReadOnly) {
            int id = 0;
            if (c != null) {
                id = c.getId();
            }
            if (id != this.mLastId) {
                s = "/*C" + id + "*/" + s;
                this.mLastId = id;
            }
            try {
                Log.writeLine(this.wScript, s);
                if (this.bWriteDelay) {
                    this.bNeedFlush = true;
                } else {
                    this.wScript.flush();
                }
            }
            catch (IOException e) {
                Trace.error(28, this.sFileScript);
            }
            if (this.iLogSize > 0 && this.iLogCount++ > 100) {
                this.iLogCount = 0;
                if (new File(this.sFileScript).length() > (long)(this.iLogSize * 1024 * 1024)) {
                    this.checkpoint();
                }
            }
        }
    }

    void shutdown() throws SQLException {
        this.tRunner = null;
        this.cCache.shutdown();
        this.closeScript();
        this.closeProperties();
    }

    static void scriptToFile(Database db, String file, boolean full, Channel channel) throws SQLException {
        if (new File(file).exists()) {
            throw Trace.error(28, file);
        }
        try {
            long time = System.currentTimeMillis();
            Result r = full ? db.getScript(false, false, false, channel) : db.getScript(false, false, true, channel);
            Record n = r.rRoot;
            FileWriter w = new FileWriter(file);
            while (n != null) {
                Log.writeLine(w, (String)n.data[0]);
                n = n.next;
            }
            Vector tables = db.getTables();
            int i = 0;
            while (i < tables.size()) {
                Table t = (Table)tables.elementAt(i);
                if (full || !t.isCached()) {
                    Index primary = t.getPrimaryIndex();
                    Node x = primary.first();
                    while (x != null) {
                        Log.writeLine(w, t.getInsertStatement(x.getData()));
                        x = primary.next(x);
                    }
                }
                ++i;
            }
            w.close();
            time = System.currentTimeMillis() - time;
        }
        catch (IOException e) {
            Trace.error(28, file + " " + e);
        }
    }

    private void renameNewToCurrent(String file) {
        if (new File(file + ".new").exists()) {
            new File(file).delete();
            new File(file + ".new").renameTo(new File(file));
        }
    }

    private void closeProperties() throws SQLException {
        try {
            if (this.fProperties != null) {
                this.fProperties.close();
                this.fProperties = null;
            }
        }
        catch (Exception e) {
            throw Trace.error(28, this.sFileProperties + " " + e);
        }
    }

    private void create() throws SQLException {
        ((Hashtable)this.pProperties).put("modified", "no");
        ((Hashtable)this.pProperties).put("version", "1.6");
        this.saveProperties();
    }

    private boolean isAlreadyOpen() throws SQLException {
        File f = new File(this.sName + ".lock");
        long l1 = f.lastModified();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        long l2 = f.lastModified();
        if (l1 != l2) {
            return true;
        }
        this.closeProperties();
        if (!new File(this.sFileProperties).delete()) {
            return true;
        }
        this.saveProperties();
        return false;
    }

    private void loadProperties() throws SQLException {
        File f = new File(this.sFileProperties);
        this.closeProperties();
        try {
            this.fProperties = new FileInputStream(f);
            this.pProperties.load(this.fProperties);
        }
        catch (Exception e) {
            throw Trace.error(28, this.sFileProperties);
        }
    }

    private void saveProperties() throws SQLException {
        File f = new File(this.sFileProperties);
        this.closeProperties();
        try {
            FileOutputStream out = new FileOutputStream(f);
            this.pProperties.store(out, "HSQL database");
            out.close();
            this.loadProperties();
        }
        catch (Exception e) {
            throw Trace.error(28, this.sFileProperties);
        }
    }

    private void backup() throws SQLException {
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int l;
            long time = System.currentTimeMillis();
            DeflaterOutputStream f = new DeflaterOutputStream((OutputStream)new FileOutputStream(this.sFileBackup + ".new"), new Deflater(1), 65536);
            byte[] b = new byte[65536];
            FileInputStream in = new FileInputStream(this.sFileCache);
            while ((l = in.read(b, 0, 65536)) != -1) {
                f.write(b, 0, l);
            }
            f.close();
            in.close();
            time = System.currentTimeMillis() - time;
        }
        catch (Exception e) {
            throw Trace.error(28, this.sFileBackup);
        }
    }

    private void restoreBackup() throws SQLException {
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int l;
            long time = System.currentTimeMillis();
            InflaterInputStream f = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream cache = new FileOutputStream(this.sFileCache);
            byte[] b = new byte[65536];
            while ((l = f.read(b, 0, 65536)) != -1) {
                cache.write(b, 0, l);
            }
            cache.close();
            f.close();
            time = System.currentTimeMillis() - time;
        }
        catch (Exception e) {
            throw Trace.error(28, this.sFileBackup);
        }
    }

    private void openScript() throws SQLException {
        try {
            this.wScript = new BufferedWriter(new FileWriter(this.sFileScript, true), 4096);
        }
        catch (Exception e) {
            Trace.error(28, this.sFileScript);
        }
    }

    private void closeScript() throws SQLException {
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
            }
        }
        catch (Exception e) {
            Trace.error(28, this.sFileScript);
        }
    }

    private void runScript() throws SQLException {
        if (!new File(this.sFileScript).exists()) {
            return;
        }
        this.bRestoring = true;
        this.dDatabase.setReferentialIntegrity(false);
        Vector<Channel> channel = new Vector<Channel>();
        channel.addElement(this.cSystem);
        Channel current = this.cSystem;
        int size = 1;
        try {
            String s;
            long time = System.currentTimeMillis();
            LineNumberReader r = new LineNumberReader(new FileReader(this.sFileScript));
            while ((s = Log.readLine(r)) != null) {
                int id;
                if (s.startsWith("/*C")) {
                    id = Integer.parseInt(s.substring(3, s.indexOf(42, 4)));
                    if (id >= size) {
                        channel.setSize(id + 1);
                    }
                    if ((current = (Channel)channel.elementAt(id)) == null) {
                        current = new Channel(this.cSystem, id);
                        channel.setElementAt(current, id);
                        this.dDatabase.registerChannel(current);
                    }
                    s = s.substring(s.indexOf(47, 1) + 1);
                }
                if (!s.equals("")) {
                    this.dDatabase.execute(s, current);
                }
                if (!s.equals("DISCONNECT")) continue;
                id = current.getId();
                current = new Channel(this.cSystem, id);
                channel.setElementAt(current, id);
            }
            r.close();
            int i = 0;
            while (i < size) {
                current = (Channel)channel.elementAt(i);
                if (current != null) {
                    current.rollback();
                }
                ++i;
            }
            time = System.currentTimeMillis() - time;
        }
        catch (IOException e) {
            throw Trace.error(28, this.sFileScript + " " + e);
        }
        this.dDatabase.setReferentialIntegrity(true);
        this.bRestoring = false;
    }

    private void writeScript(boolean full) throws SQLException {
        new File(this.sFileScript + ".new").delete();
        Log.scriptToFile(this.dDatabase, this.sFileScript + ".new", full, this.cSystem);
    }

    private static void writeLine(Writer w, String s) throws IOException {
        w.write(StringConverter.unicodeToAscii(s) + "\r\n");
    }

    private static String readLine(LineNumberReader r) throws IOException {
        String s = r.readLine();
        return StringConverter.asciiToUnicode(s);
    }
}

