/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Vector;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;

class Parser {
    private Database dDatabase;
    private Tokenizer tTokenizer;
    private Channel cChannel;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;

    Parser(Database db, Tokenizer t, Channel channel) {
        this.dDatabase = db;
        this.tTokenizer = t;
        this.cChannel = channel;
    }

    Result processSelect() throws SQLException {
        Select select = this.parseSelect();
        if (select.sIntoTable == null) {
            return select.getResult(select.limitStart, select.limitCount);
        }
        Result r = select.getResult(0);
        Table t = new Table(this.dDatabase, true, select.sIntoTable, false);
        t.addColumns(r);
        t.createPrimaryKey();
        t.insert(r, this.cChannel);
        this.dDatabase.linkTable(t);
        int i = r.getSize();
        r = new Result();
        r.iUpdateCount = i;
        return r;
    }

    Result processCall() throws SQLException {
        Expression e = this.parseExpression();
        e.resolve(null);
        int type = e.getDataType();
        Object o = e.getValue();
        Result r = new Result(1);
        r.sTable[0] = "";
        r.iType[0] = type;
        r.sLabel[0] = "";
        r.sName[0] = "";
        Object[] row = new Object[]{o};
        r.add(row);
        return r;
    }

    Result processUpdate() throws SQLException {
        String token = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(token, 8);
        Table table = this.dDatabase.getTable(token, this.cChannel);
        TableFilter filter = new TableFilter(table, null, false);
        this.tTokenizer.getThis("SET");
        Vector<Integer> vColumn = new Vector<Integer>();
        Vector<Expression> eColumn = new Vector<Expression>();
        int len = 0;
        token = null;
        do {
            ++len;
            int i = table.getColumnNr(this.tTokenizer.getString());
            vColumn.addElement(new Integer(i));
            this.tTokenizer.getThis("=");
            Expression e = this.parseExpression();
            e.resolve(filter);
            eColumn.addElement(e);
        } while ((token = this.tTokenizer.getString()).equals(","));
        Expression eCondition = null;
        if (token.equals("WHERE")) {
            eCondition = this.parseExpression();
            eCondition.resolve(filter);
            filter.setCondition(eCondition);
        } else {
            this.tTokenizer.back();
        }
        table.fireAll(5);
        Object[] exp = new Expression[len];
        eColumn.copyInto(exp);
        int[] col = new int[len];
        int[] type = new int[len];
        int i = 0;
        while (i < len) {
            col[i] = (Integer)vColumn.elementAt(i);
            type[i] = table.getType(col[i]);
            ++i;
        }
        int count = 0;
        if (filter.findFirst()) {
            Object ni;
            Object nd;
            Result del = new Result();
            Result ins = new Result();
            int size = table.getColumnCount();
            do {
                if (eCondition != null && !eCondition.test()) continue;
                nd = filter.oCurrentData;
                del.add((Object[])nd);
                ni = table.getNewRow();
                int i2 = 0;
                while (i2 < size) {
                    ni[i2] = nd[i2];
                    ++i2;
                }
                int i3 = 0;
                while (i3 < len) {
                    ni[col[i3]] = ((Expression)exp[i3]).getValue(type[i3]);
                    ++i3;
                }
                ins.add((Object[])ni);
            } while (filter.next());
            this.cChannel.beginNestedTransaction();
            try {
                nd = del.rRoot;
                while (nd != null) {
                    table.fireAll(11, nd.data);
                    table.deleteNoCheck(nd.data, this.cChannel);
                    nd = nd.next;
                }
                ni = ins.rRoot;
                while (ni != null) {
                    table.insertNoCheck(ni.data, this.cChannel);
                    ni = ni.next;
                    ++count;
                }
                table.checkUpdate(col, del, ins);
                ni = ins.rRoot;
                while (ni != null) {
                    table.fireAll(8, ni.data);
                    ni = ni.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException e) {
                this.cChannel.endNestedTransaction(true);
                throw e;
            }
        }
        table.fireAll(2);
        Result r = new Result();
        r.iUpdateCount = count;
        return r;
    }

    Result processDelete() throws SQLException {
        this.tTokenizer.getThis("FROM");
        String token = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(token, 2);
        Table table = this.dDatabase.getTable(token, this.cChannel);
        TableFilter filter = new TableFilter(table, null, false);
        token = this.tTokenizer.getString();
        Expression eCondition = null;
        if (token.equals("WHERE")) {
            eCondition = this.parseExpression();
            eCondition.resolve(filter);
            filter.setCondition(eCondition);
        } else {
            this.tTokenizer.back();
        }
        table.fireAll(4);
        int count = 0;
        if (filter.findFirst()) {
            Result del = new Result();
            do {
                if (eCondition != null && !eCondition.test()) continue;
                del.add(filter.oCurrentData);
            } while (filter.next());
            Record n = del.rRoot;
            while (n != null) {
                table.delete(n.data, this.cChannel);
                ++count;
                n = n.next;
            }
        }
        table.fireAll(1);
        Result r = new Result();
        r.iUpdateCount = count;
        return r;
    }

    Result processInsert() throws SQLException {
        this.tTokenizer.getThis("INTO");
        String token = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(token, 4);
        Table t = this.dDatabase.getTable(token, this.cChannel);
        token = this.tTokenizer.getString();
        Vector<String> vcolumns = null;
        if (token.equals("(")) {
            block15: {
                vcolumns = new Vector<String>();
                int i = 0;
                do {
                    vcolumns.addElement(this.tTokenizer.getString());
                    ++i;
                    token = this.tTokenizer.getString();
                    if (token.equals(")")) break block15;
                } while (token.equals(","));
                throw Trace.error(10, token);
            }
            token = this.tTokenizer.getString();
        }
        int count = 0;
        int len = vcolumns == null ? t.getColumnCount() : vcolumns.size();
        if (token.equals("VALUES")) {
            Object[] row;
            block16: {
                this.tTokenizer.getThis("(");
                row = t.getNewRow();
                int i = 0;
                do {
                    int column;
                    if (vcolumns == null) {
                        column = i;
                        if (i > len) {
                            throw Trace.error(4);
                        }
                    } else {
                        column = t.getColumnNr((String)vcolumns.elementAt(i));
                    }
                    row[column] = this.getValue(t.getType(column));
                    ++i;
                    token = this.tTokenizer.getString();
                    if (token.equals(")")) break block16;
                } while (token.equals(","));
                throw Trace.error(10, token);
            }
            t.insert(row, this.cChannel);
            count = 1;
        } else if (token.equals("SELECT")) {
            Result result = this.processSelect();
            Record r = result.rRoot;
            Trace.check(len == result.getColumnCount(), 4);
            int[] col = new int[len];
            int[] type = new int[len];
            int i = 0;
            while (i < len) {
                int j = vcolumns == null ? i : t.getColumnNr((String)vcolumns.elementAt(i));
                col[i] = j;
                type[i] = t.getType(j);
                ++i;
            }
            this.cChannel.beginNestedTransaction();
            try {
                while (r != null) {
                    Object[] row = t.getNewRow();
                    int i2 = 0;
                    while (i2 < len) {
                        row[col[i2]] = Column.convertObject(r.data[i2], type[i2]);
                        ++i2;
                    }
                    t.insert(row, this.cChannel);
                    ++count;
                    r = r.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException e) {
                this.cChannel.endNestedTransaction(true);
                throw e;
            }
        } else {
            throw Trace.error(10, token);
        }
        Result r = new Result();
        r.iUpdateCount = count;
        return r;
    }

    private Select parseSelect() throws SQLException {
        Expression e;
        Select select = new Select();
        select.limitStart = 0;
        select.limitCount = this.cChannel.getMaxRows();
        String token = this.tTokenizer.getString();
        if (token.equals("DISTINCT")) {
            select.bDistinct = true;
        } else if (token.equals("LIMIT")) {
            String limStart = this.tTokenizer.getString();
            String limEnd = this.tTokenizer.getString();
            select.limitStart = new Integer(limStart);
            select.limitCount = new Integer(limEnd);
        } else {
            this.tTokenizer.back();
        }
        Vector<Expression> vcolumn = new Vector<Expression>();
        do {
            Expression e2 = this.parseExpression();
            token = this.tTokenizer.getString();
            if (token.equals("AS")) {
                e2.setAlias(this.tTokenizer.getName());
                token = this.tTokenizer.getString();
            } else if (this.tTokenizer.wasName()) {
                e2.setAlias(token);
                token = this.tTokenizer.getString();
            }
            vcolumn.addElement(e2);
        } while (token.equals(","));
        if (token.equals("INTO")) {
            select.sIntoTable = this.tTokenizer.getString();
            token = this.tTokenizer.getString();
        }
        if (!token.equals("FROM")) {
            throw Trace.error(10, token);
        }
        Expression condition = null;
        Vector<TableFilter> vfilter = new Vector<TableFilter>();
        vfilter.addElement(this.parseTableFilter(false));
        while (true) {
            if ((token = this.tTokenizer.getString()).equals("LEFT")) {
                token = this.tTokenizer.getString();
                if (token.equals("OUTER")) {
                    token = this.tTokenizer.getString();
                }
                Trace.check(token.equals("JOIN"), 10, token);
                vfilter.addElement(this.parseTableFilter(true));
                this.tTokenizer.getThis("ON");
                condition = this.addCondition(condition, this.parseExpression());
                continue;
            }
            if (token.equals("INNER")) {
                this.tTokenizer.getThis("JOIN");
                vfilter.addElement(this.parseTableFilter(false));
                this.tTokenizer.getThis("ON");
                condition = this.addCondition(condition, this.parseExpression());
                continue;
            }
            if (!token.equals(",")) break;
            vfilter.addElement(this.parseTableFilter(false));
        }
        this.tTokenizer.back();
        int len = vfilter.size();
        Object[] filter = new TableFilter[len];
        vfilter.copyInto(filter);
        select.tFilter = filter;
        len = vcolumn.size();
        int i = 0;
        while (i < len) {
            e = (Expression)vcolumn.elementAt(i);
            if (e.getType() == 6) {
                int current = i;
                Table table = null;
                String n = e.getTableName();
                int t = 0;
                while (t < filter.length) {
                    Object f = filter[t];
                    e.resolve((TableFilter)f);
                    if (n == null || n.equals(((TableFilter)f).getName())) {
                        table = ((TableFilter)f).getTable();
                        int col = table.getColumnCount();
                        int c = 0;
                        while (c < col) {
                            Expression ins = new Expression(((TableFilter)f).getName(), table.getColumnName(c));
                            vcolumn.insertElementAt(ins, current++);
                            ++len;
                            ++c;
                        }
                    }
                    ++t;
                }
                Trace.check(table != null, 21, n);
                --len;
                vcolumn.removeElementAt(current);
            } else if (e.getType() == 2 && e.getTableName() == null) {
                int filterIndex = 0;
                while (filterIndex < filter.length) {
                    e.resolve((TableFilter)filter[filterIndex]);
                    ++filterIndex;
                }
            }
            ++i;
        }
        select.iResultLen = len;
        token = this.tTokenizer.getString();
        if (token.equals("WHERE")) {
            condition = this.addCondition(condition, this.parseExpression());
            token = this.tTokenizer.getString();
        }
        select.eCondition = condition;
        if (token.equals("GROUP")) {
            this.tTokenizer.getThis("BY");
            len = 0;
            do {
                vcolumn.addElement(this.parseExpression());
                token = this.tTokenizer.getString();
                ++len;
            } while (token.equals(","));
            select.iGroupLen = len;
        }
        if (token.equals("ORDER")) {
            this.tTokenizer.getThis("BY");
            len = 0;
            do {
                if ((e = this.parseExpression()).getType() == 1) {
                    if (e.getDataType() == 4) {
                        int i2 = (Integer)e.getValue();
                        e = (Expression)vcolumn.elementAt(i2 - 1);
                    }
                } else if (e.getType() == 2 && e.getTableName() == null) {
                    String s = e.getColumnName();
                    int i3 = 0;
                    while (i3 < vcolumn.size()) {
                        Expression ec = (Expression)vcolumn.elementAt(i3);
                        if (s.equals(ec.getAlias())) {
                            e = ec;
                            break;
                        }
                        ++i3;
                    }
                }
                if ((token = this.tTokenizer.getString()).equals("DESC")) {
                    e.setDescending();
                    token = this.tTokenizer.getString();
                } else if (token.equals("ASC")) {
                    token = this.tTokenizer.getString();
                }
                vcolumn.addElement(e);
                ++len;
            } while (token.equals(","));
            select.iOrderLen = len;
        }
        len = vcolumn.size();
        select.eColumn = new Expression[len];
        vcolumn.copyInto(select.eColumn);
        if (token.equals("UNION")) {
            token = this.tTokenizer.getString();
            if (token.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tTokenizer.back();
            }
            this.tTokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (token.equals("INTERSECT")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (token.equals("EXCEPT") || token.equals("MINUS")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tTokenizer.back();
        }
        return select;
    }

    private TableFilter parseTableFilter(boolean outerjoin) throws SQLException {
        String token = this.tTokenizer.getString();
        Table t = null;
        if (token.equals("(")) {
            this.tTokenizer.getThis("SELECT");
            Select s = this.parseSelect();
            Result r = s.getResult(0);
            t = new Table(this.dDatabase, false, "SYSTEM_SUBQUERY", false);
            this.tTokenizer.getThis(")");
            t.addColumns(r);
            t.createPrimaryKey();
            t.insert(r, this.cChannel);
        } else {
            this.cChannel.check(token, 1);
            t = this.dDatabase.getTable(token, this.cChannel);
        }
        String sAlias = null;
        token = this.tTokenizer.getString();
        if (token.equals("AS")) {
            sAlias = this.tTokenizer.getName();
        } else if (this.tTokenizer.wasName()) {
            sAlias = token;
        } else {
            this.tTokenizer.back();
        }
        return new TableFilter(t, sAlias, outerjoin);
    }

    private Expression addCondition(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return new Expression(28, e1, e2);
    }

    private Object getValue(int type) throws SQLException {
        Expression r = this.parseExpression();
        r.resolve(null);
        return r.getValue(type);
    }

    private Expression parseExpression() throws SQLException {
        this.read();
        if (this.iToken == 42 || this.iToken == 43 || this.iToken == 40 || this.iToken == 41 || this.iToken == 44) {
            int type = this.iToken;
            this.read();
            Expression r = new Expression(type, this.readOr(), null);
            this.tTokenizer.back();
            return r;
        }
        Expression r = this.readOr();
        this.tTokenizer.back();
        return r;
    }

    private Expression readOr() throws SQLException {
        Expression r = this.readAnd();
        while (this.iToken == 29) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() throws SQLException {
        Expression r = this.readCondition();
        while (this.iToken == 28) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() throws SQLException {
        if (this.iToken == 20) {
            int type = this.iToken;
            this.read();
            return new Expression(type, this.readCondition(), null);
        }
        if (this.iToken == 31) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            Trace.check(this.iToken == 103, 10);
            Expression s = new Expression(this.parseSelect());
            this.read();
            this.readThis(102);
            return new Expression(type, s, null);
        }
        Expression a = this.readConcat();
        boolean not = false;
        if (this.iToken == 20) {
            not = true;
            this.read();
        }
        if (this.iToken == 27) {
            this.read();
            Expression b = this.readConcat();
            char escape = '\u0000';
            if (this.sToken.equals("ESCAPE")) {
                this.read();
                Expression c = this.readTerm();
                Trace.check(c.getType() == 1, 6);
                String s = (String)c.getValue(12);
                if (s == null || s.length() < 1) {
                    throw Trace.error(6, s);
                }
                escape = s.charAt(0);
            }
            a = new Expression(27, a, b);
            a.setLikeEscape(escape);
        } else if (this.iToken == 106) {
            this.read();
            Expression l = new Expression(22, a, this.readConcat());
            this.readThis(28);
            Expression h = new Expression(25, a, this.readConcat());
            a = new Expression(28, l, h);
        } else if (this.iToken == 30) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            Expression b = null;
            if (this.iToken == 103) {
                b = new Expression(this.parseSelect());
                this.read();
            } else {
                this.tTokenizer.back();
                Vector<Object> v = new Vector<Object>();
                do {
                    v.addElement(this.getValue(12));
                    this.read();
                } while (this.iToken == 104);
                b = new Expression(v);
            }
            this.readThis(102);
            a = new Expression(type, a, b);
        } else {
            Trace.check(!not, 10);
            if (Expression.isCompare(this.iToken)) {
                int type = this.iToken;
                this.read();
                return new Expression(type, a, this.readConcat());
            }
            return a;
        }
        if (not) {
            a = new Expression(20, a, null);
        }
        return a;
    }

    private void readThis(int type) throws SQLException {
        Trace.check(this.iToken == type, 10);
        this.read();
    }

    private Expression readConcat() throws SQLException {
        Expression r = this.readSum();
        while (this.iToken == 105) {
            int type = 15;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readSum());
        }
        return r;
    }

    private Expression readSum() throws SQLException {
        Expression r = this.readFactor();
        while (true) {
            int type;
            if (this.iToken == 100) {
                type = 10;
            } else {
                if (this.iToken != 9) break;
                type = 11;
            }
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() throws SQLException {
        Expression r = this.readTerm();
        while (this.iToken == 12 || this.iToken == 14) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readTerm());
        }
        return r;
    }

    private Expression readTerm() throws SQLException {
        Expression r = null;
        if (this.iToken == 2) {
            String name = this.sToken;
            r = new Expression(this.sTable, this.sToken);
            this.read();
            if (this.iToken == 101) {
                Function f = new Function(this.dDatabase.getAlias(name), this.cChannel);
                int len = f.getArgCount();
                int i = 0;
                this.read();
                if (this.iToken != 102) {
                    while (true) {
                        f.setArgument(i++, this.readOr());
                        if (this.iToken != 104) break;
                        this.read();
                    }
                }
                this.readThis(102);
                r = new Expression(f);
            }
        } else if (this.iToken == 9) {
            int type = this.iToken;
            this.read();
            r = new Expression(type, this.readTerm(), null);
        } else if (this.iToken == 100) {
            this.read();
            r = this.readTerm();
        } else if (this.iToken == 101) {
            this.read();
            r = this.readOr();
            if (this.iToken != 102) {
                throw Trace.error(10, this.sToken);
            }
            this.read();
        } else if (this.iToken == 1) {
            r = new Expression(this.iType, this.oData);
            this.read();
        } else if (this.iToken == 103) {
            r = new Expression(this.parseSelect());
            this.read();
        } else if (this.iToken == 12) {
            r = new Expression(this.sTable, null);
            this.read();
        } else if (this.iToken == 60 || this.iToken == 15) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            r = this.readOr();
            this.readThis(104);
            r = new Expression(type, r, this.readOr());
            this.readThis(102);
        } else if (this.iToken == 62) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            r = this.readOr();
            this.readThis(104);
            Expression thenelse = this.readOr();
            this.readThis(104);
            thenelse = new Expression(type, thenelse, this.readOr());
            r = new Expression(type, r, thenelse);
            this.readThis(102);
        } else if (this.iToken == 61) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            r = this.readOr();
            this.readThis(104);
            int t = Column.getTypeNr(this.sToken);
            r = new Expression(type, r, null);
            r.setDataType(t);
            this.read();
            this.readThis(102);
        } else if (this.iToken == 107) {
            this.read();
            this.readThis(101);
            r = this.readOr();
            Trace.check(this.sToken.equals("AS"), 10, this.sToken);
            this.read();
            int t = Column.getTypeNr(this.sToken);
            r = new Expression(61, r, null);
            r.setDataType(t);
            this.read();
            this.readThis(102);
        } else {
            throw Trace.error(10, this.sToken);
        }
        return r;
    }

    private void read() throws SQLException {
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tTokenizer.getAsValue();
            this.iType = this.tTokenizer.getType();
        } else if (this.tTokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tTokenizer.wasLongName()) {
            this.sTable = this.tTokenizer.getLongNameFirst();
            this.sToken = this.tTokenizer.getLongNameLast();
            this.iToken = this.sToken.equals("*") ? 12 : 2;
        } else if (this.sToken.equals("")) {
            this.iToken = 108;
        } else if (this.sToken.equals("AND")) {
            this.iToken = 28;
        } else if (this.sToken.equals("OR")) {
            this.iToken = 29;
        } else if (this.sToken.equals("NOT")) {
            this.iToken = 20;
        } else if (this.sToken.equals("IN")) {
            this.iToken = 30;
        } else if (this.sToken.equals("EXISTS")) {
            this.iToken = 31;
        } else if (this.sToken.equals("BETWEEN")) {
            this.iToken = 106;
        } else if (this.sToken.equals("+")) {
            this.iToken = 100;
        } else if (this.sToken.equals("-")) {
            this.iToken = 9;
        } else if (this.sToken.equals("*")) {
            this.iToken = 12;
            this.sTable = null;
        } else if (this.sToken.equals("/")) {
            this.iToken = 14;
        } else if (this.sToken.equals("||")) {
            this.iToken = 105;
        } else if (this.sToken.equals("(")) {
            this.iToken = 101;
        } else if (this.sToken.equals(")")) {
            this.iToken = 102;
        } else if (this.sToken.equals("SELECT")) {
            this.iToken = 103;
        } else if (this.sToken.equals("<")) {
            this.iToken = 24;
        } else if (this.sToken.equals("<=")) {
            this.iToken = 25;
        } else if (this.sToken.equals(">=")) {
            this.iToken = 22;
        } else if (this.sToken.equals(">")) {
            this.iToken = 23;
        } else if (this.sToken.equals("=")) {
            this.iToken = 21;
        } else if (this.sToken.equals("IS")) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("NOT")) {
                this.iToken = 26;
            } else {
                this.iToken = 21;
                this.tTokenizer.back();
            }
        } else {
            this.iToken = this.sToken.equals("<>") || this.sToken.equals("!=") ? 26 : (this.sToken.equals("LIKE") ? 27 : (this.sToken.equals("COUNT") ? 40 : (this.sToken.equals("SUM") ? 41 : (this.sToken.equals("MIN") ? 42 : (this.sToken.equals("MAX") ? 43 : (this.sToken.equals("AVG") ? 44 : (this.sToken.equals("IFNULL") ? 60 : (this.sToken.equals("CONVERT") ? 61 : (this.sToken.equals("CAST") ? 107 : (this.sToken.equals("CASEWHEN") ? 62 : (this.sToken.equals(",") ? 104 : 108)))))))))));
        }
    }
}

