/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.Trace;

class User {
    private boolean bAdministrator;
    private Hashtable hRight = new Hashtable();
    private String sName;
    private String sPassword;
    private User uPublic;

    User(String name, String password, boolean admin, User pub) {
        this.sName = name;
        this.setPassword(password);
        this.bAdministrator = admin;
        this.uPublic = pub;
    }

    String getName() {
        return this.sName;
    }

    String getPassword() {
        return this.sPassword;
    }

    Hashtable getRights() {
        return this.hRight;
    }

    void setPassword(String password) {
        this.sPassword = password;
    }

    void checkPassword(String test) throws SQLException {
        Trace.check(test.equals(this.sPassword), 31);
    }

    void grant(String object, int right) {
        Integer n = (Integer)this.hRight.get(object);
        n = n == null ? new Integer(right) : new Integer(n | right);
        this.hRight.put(object, n);
    }

    void revoke(String object, int right) {
        Integer n = (Integer)this.hRight.get(object);
        n = n == null ? new Integer(right) : new Integer(n & 15 - right);
        this.hRight.put(object, n);
    }

    void revokeAll() {
        this.hRight = null;
        this.bAdministrator = false;
    }

    void check(String object, int right) throws SQLException {
        if (this.bAdministrator) {
            return;
        }
        Integer n = (Integer)this.hRight.get(object);
        if (n != null && (n & right) != 0) {
            return;
        }
        if (this.uPublic != null && (n = (Integer)this.uPublic.hRight.get(object)) != null && (n & right) != 0) {
            return;
        }
        throw Trace.error(31);
    }

    void checkAdmin() throws SQLException {
        Trace.check(this.isAdmin(), 31);
    }

    boolean isAdmin() {
        return this.bAdministrator;
    }
}

