/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;
import org.hsqldb.StringConverter;
import org.hsqldb.WebServer;

class WebServerConnection
extends Thread {
    static final String ENCODING = "8859_1";
    private Socket mSocket;
    private WebServer mServer;
    private static final int GET = 1;
    private static final int HEAD = 2;
    private static final int POST = 3;
    private static final int BAD_REQUEST = 400;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;

    WebServerConnection(Socket socket, WebServer server) {
        this.mServer = server;
        this.mSocket = socket;
    }

    public void run() {
        try {
            StringTokenizer tokenizer;
            String request;
            BufferedReader input = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream(), ENCODING));
            String name = null;
            int method = 400;
            int len = -1;
            while ((request = input.readLine()) != null && (tokenizer = new StringTokenizer(request, " ")).hasMoreTokens()) {
                String first = tokenizer.nextToken();
                if (first.equals("GET")) {
                    method = 1;
                    name = tokenizer.nextToken();
                    continue;
                }
                if (first.equals("HEAD")) {
                    method = 2;
                    name = tokenizer.nextToken();
                    continue;
                }
                if (first.equals("POST")) {
                    method = 3;
                    name = tokenizer.nextToken();
                    continue;
                }
                if (!request.toUpperCase().startsWith("CONTENT-LENGTH:")) continue;
                len = Integer.parseInt(tokenizer.nextToken());
            }
            switch (method) {
                case 400: {
                    this.processError(400);
                    break;
                }
                case 1: {
                    this.processGet(name, true);
                    break;
                }
                case 2: {
                    this.processGet(name, false);
                    break;
                }
                case 3: {
                    this.processPost(input, name, len);
                }
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processGet(String name, boolean send) {
        try {
            String header;
            if (name.endsWith("/")) {
                name = name + this.mServer.mDefaultFile;
            }
            if (name.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            name = this.mServer.mRoot + name;
            if (this.mServer.mPathSeparatorChar != '/') {
                name = name.replace('/', this.mServer.mPathSeparatorChar);
            }
            String mime = null;
            int i = name.lastIndexOf(".");
            if (i != -1) {
                String ending = name.substring(i).toLowerCase();
                mime = this.mServer.mProperties.getProperty(ending);
            }
            if (mime == null) {
                mime = "text/html";
            }
            BufferedInputStream file = null;
            try {
                file = new BufferedInputStream(new FileInputStream(new File(name)));
                int len = file.available();
                header = this.getHead("HTTP/1.0 200 OK", "Content-Type: " + mime + "\n" + "Content-Length: " + len);
            }
            catch (IOException e) {
                this.processError(404);
                return;
            }
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            output.write(header.getBytes(ENCODING));
            if (send) {
                int b;
                while ((b = file.read()) != -1) {
                    output.writeByte(b);
                }
            }
            output.flush();
            output.close();
        }
        catch (Exception e) {
            this.mServer.traceError("processGet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getHead(String start, String end) {
        return start + "\nAllow: GET, HEAD, POST\nMIME-Version: 1.0\n" + "Server: " + "HypersonicSQL/1.0" + "\n" + end + "\n\n";
    }

    private void processPost(BufferedReader input, String name, int len) {
        if (len < 0) {
            this.processError(400);
            return;
        }
        char[] b = new char[len];
        try {
            input.read(b, 0, len);
        }
        catch (IOException e) {
            this.processError(400);
            return;
        }
        String s = new String(b);
        int p = s.indexOf(43);
        int q = s.indexOf(43, p + 1);
        if (p == -1 || q == -1) {
            this.processError(400);
            return;
        }
        String user = s.substring(0, p);
        user = StringConverter.hexStringToUnicode(user);
        String password = s.substring(p + 1, q);
        password = StringConverter.hexStringToUnicode(password);
        s = s.substring(q + 1);
        s = StringConverter.hexStringToUnicode(s);
        this.processQuery(user, password, s);
    }

    private void processError(int code) {
        this.mServer.trace("processError " + code);
        String message = null;
        switch (code) {
            case 400: {
                message = this.getHead("HTTP/1.0 400 Bad Request", "") + "<HTML><BODY><H1>Bad Request</H1>" + "The server could not understand this request.<P></BODY></HTML>";
                break;
            }
            case 404: {
                message = this.getHead("HTTP/1.0 404 Not Found", "") + "<HTML><BODY><H1>Not Found</H1>" + "The server could not find this file.<P></BODY></HTML>";
                break;
            }
            case 403: {
                message = this.getHead("HTTP/1.0 403 Forbidden", "") + "<HTML><BODY><H1>Forbidden</H1>" + "Access is not allowed.<P></BODY></HTML>";
            }
        }
        try {
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            output.write(message.getBytes(ENCODING));
            output.flush();
            output.close();
        }
        catch (Exception e) {
            this.mServer.traceError("processError: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void processQuery(String user, String password, String statement) {
        try {
            this.mServer.trace(statement);
            byte[] result = this.mServer.mDatabase.execute(user, password, statement);
            int len = result.length;
            String header = this.getHead("HTTP/1.0 200 OK", "Content-Type: application/octet-stream\nContent-Length: " + len);
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            output.write(header.getBytes(ENCODING));
            output.write(result);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            this.mServer.traceError("processQuery: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.mServer.mDatabase.isShutdown()) {
            this.mServer.trace("The database is shutdown");
            System.exit(0);
        }
    }
}

