/*
 * Decompiled with CFR 0.152.
 */
package com.indollar.naming;

import com.indollar.naming.LoadableContextEntry;
import com.indollar.naming.LoadableContextUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoadableContext
extends LoadableContextUtils
implements Context {
    static Logger logger = Logger.getLogger((String)(class$com$indollar$naming$LoadableContext == null ? (class$com$indollar$naming$LoadableContext = LoadableContext.class$("com.indollar.naming.LoadableContext")) : class$com$indollar$naming$LoadableContext).getName());
    private Hashtable environment;
    private Map bindings = new HashMap(100);
    private boolean readonly;
    private DocumentBuilderFactory documentBuilderFactory = null;
    private static final NameParser nameParser = new NameParser(){

        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    };
    static /* synthetic */ Class class$com$indollar$naming$LoadableContext;

    public LoadableContext() {
    }

    public LoadableContext(String locations) throws NamingException {
        this.loadMultiple(locations);
    }

    public LoadableContext(Hashtable env) throws NamingException {
        if (env != null) {
            this.environment = (Hashtable)env.clone();
            String locations = (String)env.get("java.naming.provider.url");
            this.loadMultiple(locations);
        }
    }

    private void loadMultiple(String locations) throws NamingException {
        if (locations != null) {
            logger.debug((Object)(" locations : " + locations));
            StringTokenizer t = new StringTokenizer(locations, ",");
            while (t.hasMoreTokens()) {
                String location = t.nextToken();
                logger.debug((Object)(" location : " + location));
                while (location.startsWith(" ")) {
                    location = location.substring(1);
                }
                location.trim();
                this.load(location);
            }
        }
    }

    public void load(String location) throws NamingException {
        if (location == null) {
            return;
        }
        String resoleLocation = this.resolveLocation(location, null);
        logger.debug((Object)("resoleLocation : " + resoleLocation));
        InputSource source = new InputSource(resoleLocation);
        this.load(source);
    }

    public void load(InputSource source) throws NamingException {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(source);
            this.loadInitialContext(document.getDocumentElement(), source);
        }
        catch (IOException e) {
            throw LoadableContextUtils.newNamingException(e);
        }
        catch (SAXException e) {
            throw LoadableContextUtils.newNamingException(e);
        }
        catch (ParserConfigurationException e) {
            throw LoadableContextUtils.newNamingException(e);
        }
    }

    private void loadInitialContext(Element element, InputSource source) throws NamingException {
        HashMap defaults = new HashMap(10);
        NodeList list = element.getChildNodes();
        int index = 0;
        while (index < list.getLength()) {
            Node node = list.item(index);
            String name = node.getNodeName();
            if (node.getNodeType() == 1) {
                logger.debug((Object)("loadInitialContext() node.name() : " + node.getNodeName()));
                logger.debug((Object)("loadInitialContext() node.getNodeValue() : " + node.getNodeValue()));
                if ("default".equals(name)) {
                    this.loadDefaults((Element)node, element, source, defaults);
                }
            }
            ++index;
        }
        this.loadContext(element, source, defaults, this);
    }

    private void loadDefaults(Element element, Element parent, InputSource source, Map defaults) throws NamingException {
        NamedNodeMap list = element.getAttributes();
        int index = 0;
        while (index < list.getLength()) {
            Node node = list.item(index);
            logger.debug((Object)("defaults key=" + node.getNodeName() + " value=" + node.getNodeValue()));
            defaults.put(node.getNodeName(), node.getNodeValue());
            ++index;
        }
    }

    private void loadContext(Element element, InputSource source, Map defaults, Context initCtx) throws NamingException {
        this.readonly = LoadableContextUtils.getBooleanAttribute(element, "read-only", defaults, false);
        NodeList list = element.getChildNodes();
        int index = 0;
        while (index < list.getLength()) {
            Node node = list.item(index);
            String name = node.getNodeName();
            if (node.getNodeType() == 1) {
                if ("include".equals(name)) {
                    this.loadInclude((Element)node, element, source, defaults);
                } else if ("entry".equals(name)) {
                    this.loadEntry((Element)node, element, source, defaults, initCtx);
                } else if ("context".equals(name)) {
                    this.loadSubcontext((Element)node, element, source, defaults, initCtx);
                } else if ("link".equals(name)) {
                    this.loadLink((Element)node, element, source, defaults, initCtx);
                }
            }
            ++index;
        }
    }

    private void loadInclude(Element element, Element parent, InputSource source, Map defaults) throws NamingException {
        String location = LoadableContextUtils.getAttribute(element, "location");
        try {
            location = this.resolveLocation(location, source.getSystemId());
            this.load(location);
        }
        catch (NamingException e) {
            String message = "Warning: System context not found for include=" + location;
            if (!(e instanceof ConfigurationException)) {
                message = message + " with exception " + e.getExplanation();
            }
            System.out.println(message);
        }
    }

    private void loadEntry(Element element, Element parent, InputSource source, Map defaults, Context initCtx) throws NamingException {
        String name = LoadableContextUtils.getAttribute(element, "name");
        logger.debug((Object)("loadEntry() name :  " + name));
        if (!LoadableContext.isValidName(name)) {
            throw LoadableContextUtils.newNamingException("Invalid entry name: \"" + name + "\"");
        }
        String duplicate = LoadableContextUtils.getAttribute(element, "duplicate", defaults, "merge");
        Object entry = this.bindings.get(name);
        if (entry != null) {
            if ("error".equals(duplicate)) {
                throw LoadableContextUtils.newNamingException("Duplicate name defined: " + name);
            }
            if ("discard".equals(duplicate)) {
                return;
            }
            if ("merge".equals(duplicate) && entry instanceof LoadableContext) {
                throw LoadableContextUtils.newNamingException("Replacing a context with an entry using merge option is not allowed; name=" + name);
            }
        }
        this.bindings.put(name, new LoadableContextEntry(element, defaults, initCtx));
    }

    private void loadSubcontext(Element element, Element parent, InputSource source, Map defaults, Context initCtx) throws NamingException {
        LoadableContext context;
        String name = LoadableContextUtils.getAttribute(element, "name");
        if (!LoadableContext.isValidName(name)) {
            throw LoadableContextUtils.newNamingException("Invalid context name: \"" + name + "\"");
        }
        String duplicate = LoadableContextUtils.getAttribute(element, "duplicate", defaults, "merge");
        Object entry = this.bindings.get(name);
        if (entry != null) {
            if ("error".equals(duplicate)) {
                throw LoadableContextUtils.newNamingException("Duplicate name defined: " + name);
            }
            if ("discard".equals(duplicate)) {
                return;
            }
            if ("merge".equals(duplicate) && !(entry instanceof LoadableContext)) {
                throw LoadableContextUtils.newNamingException("Replacing an entry with a context using merge option is not allowed; name=" + name);
            }
        }
        if ("replace".equals(duplicate) || entry == null || !(entry instanceof LoadableContext)) {
            context = this.createContext(this.environment);
            this.bindings.put(name, context);
        } else {
            context = (LoadableContext)entry;
        }
        context.loadContext(element, source, defaults, initCtx);
    }

    private void loadLink(Element element, Element parent, InputSource source, Map defaults, Context initCtx) throws NamingException {
    }

    /*
     * Unable to fully structure code
     */
    private String resolveLocation(String location, String parent) throws NamingException {
        block6: {
            try {
                return new URL(location).toExternalForm();
            }
            catch (MalformedURLException e) {
                if (!location.startsWith("/") && parent != null) break block6;
                ** while (location.startsWith((String)"/"))
            }
lbl-1000:
            // 1 sources

            {
                location = location.substring(1);
                continue;
            }
lbl8:
            // 1 sources

            loader = Thread.currentThread().getContextClassLoader();
            url = loader.getResource(location);
            if (url != null) {
                return url.toExternalForm();
            }
            throw new ConfigurationException("Unable to load context from location: " + location);
        }
        try {
            url = new URL(parent.substring(0, parent.lastIndexOf(47) + 1) + location);
            return url.toExternalForm();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load context from location: " + location);
        }
    }

    private static boolean isValidName(String name) {
        return name.indexOf(47) == -1 && name.indexOf(32) == -1;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return this.environment.put(propName, propVal);
    }

    public void bind(Name name, Object obj) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 1);
        String lastName = name.get(name.size() - 1);
        if (lastName.equals("")) {
            throw new InvalidNameException(name.toString());
        }
        if (ctx.bindings.containsKey(lastName)) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this.checkReadOnly(name, ctx, null);
        ctx.bindings.put(lastName, new LoadableContextEntry(obj));
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(nameParser.parse(name), obj);
    }

    public void close() throws NamingException {
        this.environment = null;
        this.bindings = null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(nameParser.parse(name), nameParser.parse(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(nameParser.parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 1);
        String lastName = name.get(name.size() - 1);
        if (lastName.equals("")) {
            throw new InvalidNameException(name.toString());
        }
        if (ctx.bindings.containsKey(lastName)) {
            throw new NameAlreadyBoundException("Cannot create subcontext; name already bound: " + name.toString());
        }
        this.checkReadOnly(name, ctx, null);
        LoadableContext subctx = this.createContext(this.environment);
        ctx.bindings.put(lastName, subctx);
        return ctx;
    }

    public void destroySubcontext(Name name) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 1);
        String lastName = name.get(name.size() - 1);
        Object entry = ctx.bindings.get(lastName);
        if (entry == null) {
            return;
        }
        this.checkReadOnly(name, ctx, entry);
        if (entry instanceof LoadableContext) {
            LoadableContext subctx = (LoadableContext)entry;
            if (subctx.bindings.size() > 0) {
                throw new ContextNotEmptyException(name.toString());
            }
        } else {
            throw new NotContextException(name.toString());
        }
        ctx.bindings.remove(lastName);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(nameParser.parse(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable();
        }
        return (Hashtable)this.environment.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 0);
        return new Names(ctx.bindings.entrySet().iterator());
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 0);
        return new Bindings(ctx.bindings.entrySet().iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(nameParser.parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 1);
        int lastIndex = name.size() - 1;
        Object entry = ctx.bindings.get(name.get(lastIndex));
        if (entry == null) {
            NameNotFoundException e = new NameNotFoundException(name + " not found");
            e.setResolvedName(name.getPrefix(lastIndex));
            e.setRemainingName(name.getSuffix(lastIndex));
            throw e;
        }
        if (entry instanceof LoadableContext) {
            return this.createContext((LoadableContext)entry);
        }
        if (entry instanceof LoadableContextEntry) {
            return ((LoadableContextEntry)entry).getObject();
        }
        throw LoadableContextUtils.newNamingException("Unknown bindings in context: " + entry);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(nameParser.parse(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 1);
        int lastIndex = name.size() - 1;
        String lastName = name.get(lastIndex);
        if (lastName.equals("")) {
            throw new InvalidNameException(name.toString());
        }
        Object entry = ctx.bindings.get(lastName);
        if (entry instanceof LoadableContext && ((LoadableContext)entry).bindings.size() > 0) {
            throw new ContextNotEmptyException(name + " not empty; cannot rebind it");
        }
        this.checkReadOnly(name, ctx, entry);
        ctx.bindings.put(lastName, new LoadableContextEntry(obj));
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(nameParser.parse(name), obj);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.environment != null) {
            return this.environment.remove(propName);
        }
        return null;
    }

    public void rename(Name name1, Name name2) throws NamingException {
        if (name1.equals(name2)) {
            return;
        }
        LoadableContext ctx1 = this.resolveContext(name1, 1);
        String lastName1 = name1.get(name1.size() - 1);
        Object entry1 = ctx1.bindings.get(lastName1);
        if (entry1 == null) {
            throw new NameNotFoundException(name1 + " not found; cannot be renamed");
        }
        this.checkReadOnly(name1, ctx1, entry1);
        LoadableContext ctx2 = this.resolveContext(name2, 1);
        String lastName2 = name2.get(name2.size() - 1);
        if (lastName2.equals("")) {
            throw new InvalidNameException(name2.toString());
        }
        Object entry2 = ctx2.bindings.get(lastName2);
        if (entry2 instanceof LoadableContext && ((LoadableContext)entry2).bindings.size() > 0) {
            throw new ContextNotEmptyException(name2 + " not empty; cannot be target of rename");
        }
        this.checkReadOnly(name2, ctx2, entry2);
        ctx1.bindings.remove(lastName1);
        ctx2.bindings.put(name2, entry1);
    }

    public void rename(String name1, String name2) throws NamingException {
        this.rename(nameParser.parse(name1), nameParser.parse(name2));
    }

    public void unbind(Name name) throws NamingException {
        LoadableContext ctx = this.resolveContext(name, 1);
        int lastIndex = name.size() - 1;
        String lastName = name.get(lastIndex);
        Object entry = ctx.bindings.get(lastName);
        this.checkReadOnly(name, ctx, entry);
        if (entry instanceof LoadableContext && ((LoadableContext)entry).bindings.size() > 0) {
            throw new ContextNotEmptyException(name + " not empty; cannot unbind it");
        }
        ctx.bindings.remove(lastName);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(nameParser.parse(name));
    }

    private LoadableContext resolveContext(Name name, int remain) throws NamingException {
        int lastIndex = name.size() - remain;
        if (lastIndex < 0) {
            throw new InvalidNameException("Empty name");
        }
        LoadableContext ctx = this;
        int index = 0;
        while (index < lastIndex) {
            Object entry = ctx.bindings.get(name.get(index));
            if (!(entry instanceof LoadableContext)) {
                if (entry == null) {
                    NameNotFoundException e = new NameNotFoundException();
                    e.setResolvedName(name.getPrefix(index));
                    e.setRemainingName(name.getSuffix(index));
                    throw e;
                }
                NotContextException e = new NotContextException();
                e.setResolvedName(name.getPrefix(index));
                e.setRemainingName(name.getSuffix(index));
                throw e;
            }
            ctx = (LoadableContext)entry;
            ++index;
        }
        return ctx;
    }

    private LoadableContext createContext(Hashtable env) {
        LoadableContext context = new LoadableContext();
        context.documentBuilderFactory = this.documentBuilderFactory;
        context.environment = env != null ? (Hashtable)env.clone() : null;
        return context;
    }

    private LoadableContext createContext(LoadableContext ctx) {
        LoadableContext context = new LoadableContext();
        context.documentBuilderFactory = this.documentBuilderFactory;
        context.environment = ctx.environment != null ? (Hashtable)ctx.environment.clone() : null;
        context.bindings = ctx.bindings;
        return context;
    }

    private void checkReadOnly(Name name, LoadableContext ctx, Object entry) throws NamingException {
        if (ctx.readonly) {
            throw new OperationNotSupportedException("Context of " + name + " is read only.");
        }
        if (entry == null) {
            return;
        }
        if (entry instanceof LoadableContext && ((LoadableContext)entry).readonly || entry instanceof LoadableContextEntry && ((LoadableContextEntry)entry).isReadOnly()) {
            throw new OperationNotSupportedException("Context entry " + name + " is read only.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Bindings
    implements NamingEnumeration {
        private Iterator entries;

        public Bindings(Iterator entries) {
            this.entries = entries;
        }

        public boolean hasMoreElements() {
            return this.entries.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Object next() throws NamingException {
            Map.Entry entry = (Map.Entry)this.entries.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LoadableContext) {
                return new Binding(name, value);
            }
            if (value instanceof LoadableContextEntry) {
                Object object = ((LoadableContextEntry)value).getObject();
                return new Binding(name, object);
            }
            throw LoadableContextUtils.newNamingException("Unknown binding in context: " + value);
        }

        public void close() {
        }
    }

    private static class Names
    implements NamingEnumeration {
        private Iterator entries;

        public Names(Iterator entries) {
            this.entries = entries;
        }

        public boolean hasMoreElements() {
            return this.entries.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Object next() throws NamingException {
            Map.Entry entry = (Map.Entry)this.entries.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LoadableContext) {
                return new NameClassPair(name, value.getClass().getName());
            }
            if (value instanceof LoadableContextEntry) {
                Object object = ((LoadableContextEntry)value).getObject();
                return new NameClassPair(name, object.getClass().getName());
            }
            throw LoadableContextUtils.newNamingException("Unknown bindings in context: " + value);
        }

        public void close() {
        }
    }
}

