/*
 * Decompiled with CFR 0.152.
 */
package com.indollar.naming;

import com.indollar.naming.LoadableContextUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.w3c.dom.Element;

public class LoadableContextEntry
extends LoadableContextUtils {
    private Object entryObject;
    private Element entryElement;
    private Context initCtx;
    private boolean readonly;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;

    public LoadableContextEntry(Object object) {
        this.entryObject = object;
    }

    public LoadableContextEntry(Element element, Map defaults, Context initCtx) throws NamingException {
        this.entryElement = element;
        this.initCtx = initCtx;
        this.readonly = LoadableContextUtils.getBooleanAttribute(element, "read-only", defaults, false);
        if (LoadableContextUtils.getBooleanAttribute(element, "lazy", defaults, false)) {
            return;
        }
        this.loadEntryObject(element);
    }

    public Object getObject() throws NamingException {
        if (this.entryObject == null) {
            this.loadEntryObject(this.entryElement);
        }
        return this.entryObject;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    private synchronized void loadEntryObject(Element element) throws NamingException {
        if (this.entryObject != null) {
            return;
        }
        this.entryObject = this.loadInstance(element, class$java$lang$String == null ? (class$java$lang$String = LoadableContextEntry.class$("java.lang.String")) : class$java$lang$String);
        this.entryElement = null;
        this.initCtx = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object loadInstance(Element element, Class typeClass) throws NamingException {
        typeClass = LoadableContextUtils.hasAttribute(element, "type") ? LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(element, "type")) : typeClass;
        List list = LoadableContextUtils.findElements(element, new String[]{"new", "bean", "array", "call", "null"}, false);
        Element instantiationElement = list.isEmpty() ? null : (Element)list.get(0);
        Object object = null;
        if (LoadableContextUtils.hasAttribute(element, "value")) {
            if (LoadableContextUtils.hasAttribute(element, "ref")) {
                throw LoadableContextUtils.newNamingException("The ref attribute cannot be specified when value is specified");
            }
            if (instantiationElement != null) {
                throw LoadableContextUtils.newNamingException("No instantiation elements allowed when value is specified");
            }
            String value = LoadableContextEntry.expandValue(LoadableContextUtils.getAttribute(element, "value"), this.initCtx);
            if (typeClass.equals(class$java$lang$String == null ? (class$java$lang$String = LoadableContextEntry.class$("java.lang.String")) : class$java$lang$String)) {
                object = value;
            } else if (typeClass.equals(Integer.TYPE) || typeClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = LoadableContextEntry.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                object = Integer.valueOf(value);
            } else if (typeClass.equals(Long.TYPE) || typeClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = LoadableContextEntry.class$("java.lang.Long")) : class$java$lang$Long)) {
                object = Long.valueOf(value);
            } else if (typeClass.equals(Short.TYPE) || typeClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = LoadableContextEntry.class$("java.lang.Short")) : class$java$lang$Short)) {
                object = Short.valueOf(value);
            } else if (typeClass.equals(Byte.TYPE) || typeClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = LoadableContextEntry.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                object = Byte.valueOf(value);
            } else if (typeClass.equals(Character.TYPE) || typeClass.equals(class$java$lang$Character == null ? (class$java$lang$Character = LoadableContextEntry.class$("java.lang.Character")) : class$java$lang$Character)) {
                object = new Character(value.charAt(0));
            } else if (typeClass.equals(Float.TYPE) || typeClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = LoadableContextEntry.class$("java.lang.Float")) : class$java$lang$Float)) {
                object = Float.valueOf(value);
            } else if (typeClass.equals(Double.TYPE) || typeClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = LoadableContextEntry.class$("java.lang.Double")) : class$java$lang$Double)) {
                object = Double.valueOf(value);
            } else if (typeClass.equals(Boolean.TYPE) || typeClass.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = LoadableContextEntry.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                object = Boolean.valueOf(value);
            } else if (typeClass.equals(class$java$util$Date == null ? (class$java$util$Date = LoadableContextEntry.class$("java.util.Date")) : class$java$util$Date)) {
                try {
                    SimpleDateFormat format = LoadableContextUtils.hasAttribute(element, "format") ? new SimpleDateFormat(LoadableContextUtils.getAttribute(element, "format")) : new SimpleDateFormat();
                    object = format.parse(value);
                }
                catch (ParseException e) {
                    throw LoadableContextUtils.newNamingException("Failed to parse date '" + value + "' using format '" + LoadableContextUtils.getAttribute(element, "format") + "'");
                }
            } else {
                try {
                    object = typeClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = LoadableContextEntry.class$("java.lang.String")) : class$java$lang$String).newInstance(value);
                }
                catch (Exception e) {
                    throw LoadableContextUtils.newNamingException("Unable to instantiate " + typeClass.getName() + " using value=" + value, e);
                }
            }
        } else if (LoadableContextUtils.hasAttribute(element, "ref")) {
            if (instantiationElement != null) {
                throw LoadableContextUtils.newNamingException("No instantiation elements allowed when attribute \"value\" is specified");
            }
            String ref = LoadableContextUtils.getAttribute(element, "ref");
            Object instance = this.initCtx.lookup(ref);
            if (!typeClass.isAssignableFrom(instance.getClass())) throw LoadableContextUtils.newNamingException("Object referenced by name: " + ref + " not compatible with " + typeClass.getName());
            object = instance;
        } else if (instantiationElement == null) {
            try {
                object = typeClass.newInstance();
            }
            catch (Exception e) {
                throw LoadableContextUtils.newNamingException("Failed to instantiate " + typeClass.getName() + " using default constructor", e);
            }
        } else {
            String tagName = instantiationElement.getTagName();
            if (tagName.equals("new")) {
                object = this.loadByConstructor(instantiationElement, typeClass);
            } else if (tagName.equals("bean")) {
                object = this.loadByBean(instantiationElement, typeClass);
            } else if (tagName.equals("call")) {
                object = this.loadByCall(instantiationElement, typeClass);
            } else if (tagName.equals("array")) {
                if (!typeClass.isArray()) throw LoadableContextUtils.newNamingException(typeClass.getName() + " is not an array type");
                object = this.loadArray(instantiationElement, typeClass.getComponentType());
            } else {
                if (!tagName.equals("null")) throw LoadableContextUtils.newNamingException("Invalid tag " + tagName);
                object = null;
            }
        }
        List initElements = LoadableContextUtils.findElements(element, "init");
        if (initElements.size() <= 0) return object;
        this.doInitActions((Element)initElements.get(0), object);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private Object loadArray(Element element, Class typeClass) throws NamingException {
        if (LoadableContextUtils.hasAttribute(element, "type")) {
            cls = LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(element, "type"));
            if (!typeClass.isAssignableFrom(cls)) {
                throw LoadableContextUtils.newNamingException("Class " + cls.getName() + " is not compatible with " + typeClass.getName());
            }
            typeClass = cls;
        }
        arraySize = 0;
        if (LoadableContextUtils.hasAttribute(element, "size")) {
            try {
                arraySize = Integer.parseInt(LoadableContextUtils.getAttribute(element, "size"));
            }
            catch (Exception e) {
                throw LoadableContextUtils.newNamingException("Invalid array size=" + LoadableContextUtils.getAttribute(element, "size"), e);
            }
            if (arraySize <= 0) {
                throw LoadableContextUtils.newNamingException("Invalid array size=" + LoadableContextUtils.getAttribute(element, "size"));
            }
        }
        list = new ArrayList<Object>(arraySize > 0 ? arraySize : 20);
        it = LoadableContextUtils.findElements(element, "element").iterator();
        while (it.hasNext()) {
            childElement = (Element)it.next();
            if (LoadableContextUtils.hasAttribute(childElement, "index")) {
                try {
                    index = Integer.parseInt(LoadableContextUtils.getAttribute(childElement, "index"));
                }
                catch (Exception e) {
                    throw LoadableContextUtils.newNamingException("Invalid array index=" + LoadableContextUtils.getAttribute(element, "size"), e);
                }
            } else {
                index = list.size();
            }
            if (arraySize > 0 && index >= arraySize || index < 0) {
                throw LoadableContextUtils.newNamingException("Array index out of bound = " + index);
            }
            if (index >= list.size()) ** GOTO lbl34
            list.set(index, this.loadInstance(childElement, typeClass));
            continue;
lbl-1000:
            // 1 sources

            {
                list.add(null);
lbl34:
                // 2 sources

                ** while (index > list.size())
            }
lbl35:
            // 1 sources

            list.add(this.loadInstance(childElement, typeClass));
        }
        array = Array.newInstance(typeClass, arraySize > 0 ? arraySize : list.size());
        index = 0;
        while (index < list.size()) {
            item = list.get(index);
            if (item != null) {
                Array.set(array, index, item);
            }
            ++index;
        }
        return array;
    }

    private Object loadByConstructor(Element element, Class typeClass) throws NamingException {
        if (LoadableContextUtils.hasAttribute(element, "class")) {
            Class cls = LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(element, "class"));
            if (!typeClass.isAssignableFrom(cls)) {
                throw LoadableContextUtils.newNamingException("Class " + cls.getName() + " is not compatible with " + typeClass.getName());
            }
            typeClass = cls;
        }
        List list = LoadableContextUtils.findElements(element, "parameter");
        Class[] paramClasses = new Class[list.size()];
        Object[] paramObjects = new Object[list.size()];
        int index = 0;
        while (index < list.size()) {
            Class paramClass;
            Element param = (Element)list.get(index);
            paramClasses[index] = paramClass = LoadableContextUtils.hasAttribute(param, "type") ? LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(param, "type")) : (class$java$lang$String == null ? LoadableContextEntry.class$("java.lang.String") : class$java$lang$String);
            paramObjects[index] = this.loadInstance(param, paramClass);
            ++index;
        }
        Object object = null;
        try {
            object = paramClasses.length == 0 ? typeClass.newInstance() : typeClass.getConstructor(paramClasses).newInstance(paramObjects);
        }
        catch (Exception e) {
            throw LoadableContextUtils.newNamingException("Failed to invoke constructor for class " + typeClass.getName());
        }
        return object;
    }

    private Object loadByCall(Element element, Class typeClass) throws NamingException {
        return this.callMethod(element, this.entryObject, typeClass);
    }

    private Object loadByBean(Element element, Class typeClass) throws NamingException {
        if (LoadableContextUtils.hasAttribute(element, "class")) {
            Class cls = LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(element, "class"));
            if (typeClass.isAssignableFrom(cls)) {
                typeClass = cls;
            } else {
                throw LoadableContextUtils.newNamingException("Bean class " + cls.getName() + " not compatible with " + typeClass.getName());
            }
        }
        Object bean = null;
        try {
            bean = typeClass.newInstance();
        }
        catch (Exception e) {
            throw LoadableContextUtils.newNamingException("Unable to instantiate bean " + typeClass.getName());
        }
        PropertyDescriptor[] descriptors = null;
        try {
            descriptors = Introspector.getBeanInfo(typeClass).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw LoadableContextUtils.newNamingException("Failed to introspect bean " + typeClass.getName());
        }
        List list = LoadableContextUtils.findElements(element, "property");
        int index = 0;
        while (index < list.size()) {
            Method propWriteMethod;
            Element prop = (Element)list.get(index);
            String propName = LoadableContextUtils.getAttribute(prop, "name");
            if (propName != null && (propWriteMethod = LoadableContextUtils.getBeanPropertyWriteMethod(descriptors, propName)) != null) {
                Object propObject = this.loadInstance(prop, class$java$lang$String == null ? LoadableContextEntry.class$("java.lang.String") : class$java$lang$String);
                try {
                    propWriteMethod.invoke(bean, propObject);
                }
                catch (Exception e) {
                    throw LoadableContextUtils.newNamingException("Failed to set property " + propName + " for bean " + typeClass.getName(), e);
                }
            }
            ++index;
        }
        return bean;
    }

    private Object doInitActions(Element element, Object instance) throws NamingException {
        List list = LoadableContextUtils.findElements(element, new String[]{"call", "put", "add"}, false);
        int index = 0;
        while (index < list.size()) {
            Element actionElement = (Element)list.get(index);
            String tagName = actionElement.getTagName();
            if (tagName.equals("call")) {
                this.doActionCall(actionElement, instance, null);
            } else if (tagName.equals("put")) {
                this.doActionPut(actionElement, instance);
            } else if (tagName.equals("add")) {
                this.doActionAdd(actionElement, instance);
            }
            ++index;
        }
        return instance;
    }

    private Object doActionCall(Element element, Object instance, Class returnTypeClass) throws NamingException {
        return this.callMethod(element, instance, returnTypeClass);
    }

    private Object doActionPut(Element element, Object instance) throws NamingException {
        if (!(instance instanceof Map)) {
            throw LoadableContextUtils.newNamingException("Cannot perform \"put\" action for instance of class " + instance.getClass().getName());
        }
        Map map = (Map)instance;
        Object item = this.loadInstance(element, class$java$lang$String == null ? (class$java$lang$String = LoadableContextEntry.class$("java.lang.String")) : class$java$lang$String);
        String key = LoadableContextUtils.getAttribute(element, "key");
        map.put(key, item);
        return instance;
    }

    private Object doActionAdd(Element element, Object instance) throws NamingException {
        if (!(instance instanceof Collection)) {
            throw LoadableContextUtils.newNamingException("Cannot perform \"add\" action for instance of class " + instance.getClass().getName());
        }
        Collection coll = (Collection)instance;
        Object item = this.loadInstance(element, class$java$lang$String == null ? (class$java$lang$String = LoadableContextEntry.class$("java.lang.String")) : class$java$lang$String);
        coll.add(item);
        return instance;
    }

    private Object callMethod(Element element, Object instance, Class returnTypeClass) throws NamingException {
        List list = LoadableContextUtils.findElements(element, "target");
        Element targetElement = list.size() > 0 ? (Element)list.get(0) : null;
        Class<?> instanceClass = null;
        if (LoadableContextUtils.hasAttribute(element, "ref")) {
            if (LoadableContextUtils.hasAttribute(element, "class")) {
                throw LoadableContextUtils.newNamingException("The ref and class attributes cannot be specified togther in factory/invoke tag");
            }
            if (targetElement != null) {
                throw LoadableContextUtils.newNamingException("The ref attribute cannot be specified when the <target> tag is specified");
            }
            instance = this.initCtx.lookup(LoadableContextUtils.getAttribute(element, "ref"));
            instanceClass = instance.getClass();
        } else if (LoadableContextUtils.hasAttribute(element, "class")) {
            if (targetElement != null) {
                throw LoadableContextUtils.newNamingException("The class attribute cannot be specified when the <target> tag is specified");
            }
            instanceClass = LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(element, "class"));
            instance = null;
        } else if (targetElement != null) {
            instance = this.loadInstance(targetElement, null);
            instanceClass = instance.getClass();
        } else if (instance != null) {
            instanceClass = instance.getClass();
        } else {
            throw LoadableContextUtils.newNamingException("Invalid call: no target is specified");
        }
        list = LoadableContextUtils.findElements(element, "parameter");
        Class[] paramClasses = new Class[list.size()];
        int index = 0;
        while (index < list.size()) {
            Class paramClass;
            Element param = (Element)list.get(index);
            paramClasses[index] = paramClass = LoadableContextUtils.hasAttribute(param, "type") ? LoadableContextEntry.resolveClass(LoadableContextUtils.getAttribute(param, "type")) : (class$java$lang$String == null ? LoadableContextEntry.class$("java.lang.String") : class$java$lang$String);
            ++index;
        }
        Method method = null;
        try {
            method = instanceClass.getMethod(LoadableContextUtils.getAttribute(element, "method"), paramClasses);
        }
        catch (NoSuchMethodException e) {
            throw LoadableContextUtils.newNamingException("No such method: " + LoadableContextUtils.getAttribute(element, "method") + " for class " + instanceClass.getName());
        }
        if (returnTypeClass != null && !returnTypeClass.isAssignableFrom(method.getReturnType())) {
            throw LoadableContextUtils.newNamingException("Return type of method " + method.getName() + " is not compatible with " + returnTypeClass.getName());
        }
        if (instance == null && !Modifier.isStatic(method.getModifiers())) {
            try {
                instance = instanceClass.newInstance();
            }
            catch (Exception e) {
                throw LoadableContextUtils.newNamingException("Failed to instantiate " + instanceClass.getName(), e);
            }
        }
        Object[] paramObjects = new Object[list.size()];
        int index2 = 0;
        while (index2 < list.size()) {
            Element param = (Element)list.get(index2);
            paramObjects[index2] = this.loadInstance(param, paramClasses[index2]);
            ++index2;
        }
        try {
            return method.invoke(instance, paramObjects);
        }
        catch (Exception e) {
            throw LoadableContextUtils.newNamingException("Failed to invoke method " + method.getName(), e);
        }
    }

    private static Class resolveClass(String type) throws NamingException {
        Class typeClass = null;
        boolean array = false;
        if (type.endsWith("[]")) {
            array = true;
            type = type.substring(0, type.length() - 2);
        }
        if (type.equals("String") || type.equals("java.lang.String")) {
            typeClass = class$java$lang$String == null ? (class$java$lang$String = LoadableContextEntry.class$("java.lang.String")) : class$java$lang$String;
        } else if (type.equals("int")) {
            typeClass = Integer.TYPE;
        } else if (type.equals("long")) {
            typeClass = Long.TYPE;
        } else if (type.equals("short")) {
            typeClass = Short.TYPE;
        } else if (type.equals("boolean")) {
            typeClass = Boolean.TYPE;
        } else if (type.equals("byte")) {
            typeClass = Byte.TYPE;
        } else if (type.equals("char")) {
            typeClass = Character.TYPE;
        } else if (type.equals("float")) {
            typeClass = Float.TYPE;
        } else if (type.equals("double")) {
            typeClass = Double.TYPE;
        } else if (type.equals("Date") || type.equals("java.util.Date")) {
            typeClass = class$java$util$Date == null ? (class$java$util$Date = LoadableContextEntry.class$("java.util.Date")) : class$java$util$Date;
        } else if (type.indexOf(46) == -1) {
            try {
                typeClass = Class.forName("java.lang." + type);
            }
            catch (Exception e) {
                try {
                    typeClass = Class.forName("java.util." + type);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        if (typeClass == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                typeClass = loader.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw LoadableContextUtils.newNamingException("Class not found: " + type, e);
            }
        }
        if (array) {
            typeClass = Array.newInstance(typeClass, 0).getClass();
        }
        return typeClass;
    }

    private static String expandValue(String value, Context ctx) {
        int q;
        int len = value.length();
        char ch = '\u0000';
        int p = 0;
        while (p < len) {
            ch = value.charAt(p);
            if (ch == '$' || ch == '#' || ch == '%') break;
            ++p;
        }
        if (p + 1 < len && value.charAt(p + 1) == '{' && (q = value.indexOf(125, p + 1)) > p + 1) {
            String tail;
            String head;
            String name = value.substring(p + 2, q);
            String expandedValue = null;
            if (!name.equals("")) {
                switch (ch) {
                    case '$': {
                        expandedValue = System.getProperty(name);
                        break;
                    }
                    case '#': {
                        try {
                            expandedValue = new InitialContext().lookup(name).toString();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case '%': {
                        try {
                            expandedValue = ctx.lookup(name).toString();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case '@': {
                        try {
                            expandedValue = ctx.getEnvironment().get(name).toString();
                        }
                        catch (Exception e) {}
                        break;
                    }
                }
            }
            if (expandedValue != null) {
                head = value.substring(0, p) + expandedValue;
                tail = value.substring(q + 1);
            } else {
                head = value.substring(0, q + 1);
                tail = value.substring(q + 1);
            }
            return head + LoadableContextEntry.expandValue(tail, ctx);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

