/*
 * Decompiled with CFR 0.152.
 */
package com.indollar.naming;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadableContextUtils {
    static List findAllElements(Element parent) {
        NodeList nodeList = parent.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    static List findElements(Element parent, String tagName) {
        NodeList nodeList = parent.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals(tagName)) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    static List findElements(Element parent, String[] tagNames, boolean exclude) {
        NodeList nodeList = parent.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            block10: {
                Node node = nodeList.item(i);
                String name = node.getNodeName();
                if (node.getNodeType() == 1) {
                    int j;
                    if (tagNames == null) {
                        list.add(node);
                    } else if (exclude) {
                        j = 0;
                        while (j < tagNames.length) {
                            if (!name.equals(tagNames[j])) {
                                ++j;
                                continue;
                            }
                            break block10;
                        }
                        list.add(node);
                    } else {
                        j = 0;
                        while (j < tagNames.length) {
                            if (name.equals(tagNames[j])) {
                                list.add(node);
                                break;
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        return list;
    }

    static String getAttribute(Element element, String name) {
        return LoadableContextUtils.getAttribute(element, name, null, null);
    }

    static String getAttribute(Element element, String name, String def) {
        return LoadableContextUtils.getAttribute(element, name, null, def);
    }

    static String getAttribute(Element element, String name, Map defaults, String def) {
        Attr attr = element.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        if (defaults != null && defaults.containsKey(name)) {
            return (String)defaults.get(name);
        }
        return def;
    }

    static boolean getBooleanAttribute(Element element, String name) {
        return LoadableContextUtils.getBooleanAttribute(element, name, null, false);
    }

    static boolean getBooleanAttribute(Element element, String name, boolean def) {
        return LoadableContextUtils.getBooleanAttribute(element, name, null, def);
    }

    static boolean getBooleanAttribute(Element element, String name, Map defaults, boolean def) {
        Attr attr = element.getAttributeNode(name);
        if (attr != null) {
            return "true".equals(attr.getValue());
        }
        if (defaults != null && defaults.containsKey(name)) {
            return "true".equals(defaults.get(name));
        }
        return def;
    }

    static boolean hasAttribute(Element element, String name) {
        return element.getAttributeNode(name) != null;
    }

    static Method getBeanPropertyWriteMethod(PropertyDescriptor[] descriptors, String name) {
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getName().equals(name)) {
                return descriptors[i].getWriteMethod();
            }
            ++i;
        }
        return null;
    }

    static NamingException newNamingException(Throwable cause) {
        NamingException e = new NamingException();
        e.setRootCause(cause);
        return e;
    }

    static NamingException newNamingException(String msg) {
        return new NamingException(msg);
    }

    static NamingException newNamingException(String msg, Throwable cause) {
        NamingException e = new NamingException(msg);
        e.setRootCause(cause);
        return e;
    }
}

