/*
 * Decompiled with CFR 0.152.
 */
package com.indollar.system;

import com.indollar.naming.LoadableContextFactory;
import com.indollar.system.SystemRuntimeException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.apache.log4j.Logger;

public class SystemContext
implements Context {
    static Logger logger = Logger.getLogger((String)(class$com$indollar$system$SystemContext == null ? (class$com$indollar$system$SystemContext = SystemContext.class$("com.indollar.system.SystemContext")) : class$com$indollar$system$SystemContext).getName());
    private static SystemContext instance = null;
    private Context ctx;
    static /* synthetic */ Class class$com$indollar$system$SystemContext;

    public static synchronized SystemContext getInstance() {
        if (instance == null) {
            instance = new SystemContext();
        }
        return instance;
    }

    public static synchronized boolean isInitialized() {
        return instance != null;
    }

    protected SystemContext() {
        try {
            this.init();
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    protected void init() throws NamingException {
        InitialContext initCtx = null;
        String url = null;
        String factory = null;
        try {
            initCtx = new InitialContext();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (initCtx != null) {
            try {
                url = (String)initCtx.lookup("java:comp/env/system/context/url");
            }
            catch (NameNotFoundException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                factory = (String)initCtx.lookup("java:comp/env/system/context/factory");
            }
            catch (NameNotFoundException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (url == null) {
            try {
                url = System.getProperty("com.indollar.system.context.url");
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        if (factory == null) {
            try {
                factory = System.getProperty("com.indollar.system.context.factory");
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        if (factory == null) {
            factory = "com.indollar.naming.LoadableContextFactory";
        }
        this.init(url, factory);
    }

    public void init(String url) throws NamingException {
        this.init(url, null);
    }

    public void init(String url, String factory) throws NamingException {
        logger.info((Object)("init() url :  " + url + " factory : " + factory));
        Hashtable<String, String> env = new Hashtable<String, String>(10);
        if (url != null) {
            env.put("java.naming.provider.url", url);
        }
        if (factory == null) {
            this.ctx = new LoadableContextFactory().getInitialContext((Hashtable)env);
        } else {
            env.put("java.naming.factory.initial", factory);
            this.ctx = NamingManager.getInitialContext(env);
        }
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        try {
            return (Integer)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long def) {
        try {
            return (Long)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    public short getShort(String name, short def) {
        try {
            return (Short)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte getByte(String name, byte def) {
        try {
            return (Byte)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public char getChar(String name) {
        return this.getChar(name, '\u0000');
    }

    public char getChar(String name, char def) {
        try {
            return ((Character)this.lookup(name)).charValue();
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float def) {
        try {
            return ((Float)this.lookup(name)).floatValue();
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double def) {
        try {
            return (Double)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        try {
            return (Boolean)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String def) {
        try {
            return (String)this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public Object getObject(String name) {
        return this.getObject(name, null);
    }

    public Object getObject(String name, Object def) {
        try {
            return this.lookup(name);
        }
        catch (NameNotFoundException e) {
            return def;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setInt(String name, int value) {
        try {
            this.rebind(name, (Object)new Integer(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setLong(String name, long value) {
        try {
            this.rebind(name, (Object)new Long(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setShort(String name, short value) {
        try {
            this.rebind(name, (Object)new Short(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setByte(String name, byte value) {
        try {
            this.rebind(name, (Object)new Byte(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setChar(String name, char value) {
        try {
            this.rebind(name, (Object)new Character(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setFloat(String name, float value) {
        try {
            this.rebind(name, (Object)new Float(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setDouble(String name, double value) {
        try {
            this.rebind(name, (Object)new Double(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setBoolean(String name, boolean value) {
        try {
            this.rebind(name, (Object)new Boolean(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setString(String name, String value) {
        try {
            this.rebind(name, (Object)value);
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setObject(String name, Object value) {
        try {
            this.rebind(name, value);
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.ctx.lookup(name);
    }

    public Object lookup(String name) throws NamingException {
        return this.ctx.lookup(name);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.ctx.bind(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.ctx.bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.ctx.rebind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.ctx.rebind(name, obj);
    }

    public void unbind(Name name) throws NamingException {
        this.ctx.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this.ctx.unbind(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.ctx.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.ctx.rename(oldName, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.ctx.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.ctx.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.ctx.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.ctx.listBindings(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.ctx.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.ctx.destroySubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.ctx.createSubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.ctx.createSubcontext(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.ctx.lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.ctx.lookup(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.ctx.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.ctx.getNameParser(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.ctx.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.ctx.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.ctx.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.ctx.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.ctx.getEnvironment();
    }

    public void close() throws NamingException {
        this.ctx.close();
    }

    public String getNameInNamespace() throws NamingException {
        return this.ctx.getNameInNamespace();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("<initial-context>");
        SystemContext.dumpContext(SystemContext.getInstance(), "    ");
        System.out.println("</initial-context>");
    }

    private static void dumpContext(Context ctx, String inden) throws NamingException {
        NamingEnumeration<Binding> en = ctx.listBindings("");
        while (en.hasMore()) {
            Binding binding = en.next();
            String name = binding.getName();
            Object value = binding.getObject();
            if (value instanceof Context) {
                System.out.println(inden + "<context name=" + name + ">");
                SystemContext.dumpContext((Context)value, inden + "    ");
                System.out.println(inden + "</context>");
                continue;
            }
            System.out.println(inden + "<entry name=" + name + " value=" + value.toString() + " />");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TestClass {
        private Hashtable table;

        public TestClass(Hashtable table) {
            this.table = table;
        }

        public String toString() {
            return this.table.toString();
        }
    }
}

