/*
 * Decompiled with CFR 0.152.
 */
package com.indollar.naming;

import com.indollar.naming.LoadableContextEntry;
import com.indollar.naming.LoadableContextUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoadableContext
extends LoadableContextUtils
implements Context {
    static Logger logger = Logger.getLogger((String)(class$com$indollar$naming$LoadableContext == null ? (class$com$indollar$naming$LoadableContext = LoadableContext.class$("com.indollar.naming.LoadableContext")) : class$com$indollar$naming$LoadableContext).getName());
    private Hashtable _$4812;
    private Map _$4813 = new HashMap(100);
    private boolean _$4814;
    private DocumentBuilderFactory _$4815 = null;
    private static final NameParser _$4863 = new NameParser(){

        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    };
    static Class class$com$indollar$naming$LoadableContext;

    public LoadableContext() {
    }

    public LoadableContext(String locations) throws NamingException {
        this._$4819(locations);
    }

    public LoadableContext(Hashtable env) throws NamingException {
        if (env != null) {
            this._$4812 = (Hashtable)env.clone();
            String locations = (String)env.get("java.naming.provider.url");
            this._$4819(locations);
        }
    }

    private void _$4819(String locations) throws NamingException {
        if (locations != null) {
            logger.debug((Object)" locations : ".concat(String.valueOf(String.valueOf(locations))));
            StringTokenizer t = new StringTokenizer(locations, ",");
            while (t.hasMoreTokens()) {
                String location = t.nextToken();
                logger.debug((Object)" location : ".concat(String.valueOf(String.valueOf(location))));
                while (location.startsWith(" ")) {
                    location = location.substring(1);
                }
                location.trim();
                this.load(location);
            }
        }
    }

    public void load(String location) throws NamingException {
        if (location == null) {
            return;
        }
        String resoleLocation = this._$4828(location, null);
        logger.debug((Object)"resoleLocation : ".concat(String.valueOf(String.valueOf(resoleLocation))));
        InputSource source = new InputSource(resoleLocation);
        this.load(source);
    }

    public void load(InputSource source) throws NamingException {
        if (this._$4815 == null) {
            this._$4815 = DocumentBuilderFactory.newInstance();
        }
        try {
            DocumentBuilder builder = this._$4815.newDocumentBuilder();
            Document document = builder.parse(source);
            this._$4832(document.getDocumentElement(), source);
        }
        catch (IOException e) {
            throw LoadableContextUtils.newNamingException(e);
        }
        catch (SAXException e) {
            throw LoadableContextUtils.newNamingException(e);
        }
        catch (ParserConfigurationException e) {
            throw LoadableContextUtils.newNamingException(e);
        }
    }

    private void _$4832(Element element, InputSource source) throws NamingException {
        HashMap defaults = new HashMap(10);
        NodeList list = element.getChildNodes();
        for (int index = 0; index < list.getLength(); ++index) {
            Node node = list.item(index);
            String name = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            logger.debug((Object)"loadInitialContext() node.name() : ".concat(String.valueOf(String.valueOf(node.getNodeName()))));
            logger.debug((Object)"loadInitialContext() node.getNodeValue() : ".concat(String.valueOf(String.valueOf(node.getNodeValue()))));
            if (!"default".equals(name)) continue;
            this._$4835((Element)node, element, source, defaults);
        }
        this._$4836(element, source, defaults, this);
    }

    private void _$4835(Element element, Element parent, InputSource source, Map defaults) throws NamingException {
        NamedNodeMap list = element.getAttributes();
        for (int index = 0; index < list.getLength(); ++index) {
            Node node = list.item(index);
            logger.debug((Object)String.valueOf(String.valueOf(new StringBuffer("defaults key=").append(node.getNodeName()).append(" value=").append(node.getNodeValue()))));
            defaults.put(node.getNodeName(), node.getNodeValue());
        }
    }

    private void _$4836(Element element, InputSource source, Map defaults, Context initCtx) throws NamingException {
        this._$4814 = LoadableContextUtils.getBooleanAttribute(element, "read-only", defaults, false);
        NodeList list = element.getChildNodes();
        for (int index = 0; index < list.getLength(); ++index) {
            Node node = list.item(index);
            String name = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            if ("include".equals(name)) {
                this._$4838((Element)node, element, source, defaults);
                continue;
            }
            if ("entry".equals(name)) {
                this._$4839((Element)node, element, source, defaults, initCtx);
                continue;
            }
            if ("context".equals(name)) {
                this._$4840((Element)node, element, source, defaults, initCtx);
                continue;
            }
            if (!"link".equals(name)) continue;
            this._$4841((Element)node, element, source, defaults, initCtx);
        }
    }

    private void _$4838(Element element, Element parent, InputSource source, Map defaults) throws NamingException {
        String location = LoadableContextUtils.getAttribute(element, "location");
        try {
            location = this._$4828(location, source.getSystemId());
            this.load(location);
        }
        catch (NamingException e) {
            String message = "Warning: System context not found for include=".concat(String.valueOf(String.valueOf(location)));
            if (!(e instanceof ConfigurationException)) {
                message = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(message))).append(" with exception ").append(e.getExplanation())));
            }
            System.out.println(message);
        }
    }

    private void _$4839(Element element, Element parent, InputSource source, Map defaults, Context initCtx) throws NamingException {
        String name = LoadableContextUtils.getAttribute(element, "name");
        logger.debug((Object)"loadEntry() name :  ".concat(String.valueOf(String.valueOf(name))));
        if (!LoadableContext._$4844(name)) {
            throw LoadableContextUtils.newNamingException(String.valueOf(String.valueOf(new StringBuffer("Invalid entry name: \"").append(name).append("\""))));
        }
        String duplicate = LoadableContextUtils.getAttribute(element, "duplicate", defaults, "merge");
        Object entry = this._$4813.get(name);
        if (entry != null) {
            if ("error".equals(duplicate)) {
                throw LoadableContextUtils.newNamingException("Duplicate name defined: ".concat(String.valueOf(String.valueOf(name))));
            }
            if ("discard".equals(duplicate)) {
                return;
            }
            if ("merge".equals(duplicate) && entry instanceof LoadableContext) {
                throw LoadableContextUtils.newNamingException("Replacing a context with an entry using merge option is not allowed; name=".concat(String.valueOf(String.valueOf(name))));
            }
        }
        this._$4813.put(name, new LoadableContextEntry(element, defaults, initCtx));
    }

    private void _$4840(Element element, Element parent, InputSource source, Map defaults, Context initCtx) throws NamingException {
        LoadableContext context;
        String name = LoadableContextUtils.getAttribute(element, "name");
        if (!LoadableContext._$4844(name)) {
            throw LoadableContextUtils.newNamingException(String.valueOf(String.valueOf(new StringBuffer("Invalid context name: \"").append(name).append("\""))));
        }
        String duplicate = LoadableContextUtils.getAttribute(element, "duplicate", defaults, "merge");
        Object entry = this._$4813.get(name);
        if (entry != null) {
            if ("error".equals(duplicate)) {
                throw LoadableContextUtils.newNamingException("Duplicate name defined: ".concat(String.valueOf(String.valueOf(name))));
            }
            if ("discard".equals(duplicate)) {
                return;
            }
            if ("merge".equals(duplicate) && !(entry instanceof LoadableContext)) {
                throw LoadableContextUtils.newNamingException("Replacing an entry with a context using merge option is not allowed; name=".concat(String.valueOf(String.valueOf(name))));
            }
        }
        if ("replace".equals(duplicate) || entry == null || !(entry instanceof LoadableContext)) {
            context = this._$4848(this._$4812);
            this._$4813.put(name, context);
        } else {
            context = (LoadableContext)entry;
        }
        context._$4836(element, source, defaults, initCtx);
    }

    private void _$4841(Element element, Element parent, InputSource source, Map defaults, Context initCtx) throws NamingException {
    }

    private String _$4828(String location, String parent) throws NamingException {
        try {
            String string = new URL(location).toExternalForm();
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            if (location.startsWith("/") || parent == null) {
                while (location.startsWith("/")) {
                    location = location.substring(1);
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                URL url = loader.getResource(location);
                if (url != null) {
                    return url.toExternalForm();
                }
                throw new ConfigurationException("Unable to load context from location: ".concat(String.valueOf(String.valueOf(location))));
            }
            try {
                URL url = new URL(String.valueOf(String.valueOf(parent.substring(0, parent.lastIndexOf(47) + 1))).concat(String.valueOf(String.valueOf(location))));
                String string = url.toExternalForm();
                return string;
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to load context from location: ".concat(String.valueOf(String.valueOf(location))));
            }
        }
    }

    private static boolean _$4844(String name) {
        return name.indexOf(47) == -1 && name.indexOf(32) == -1;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this._$4812 == null) {
            this._$4812 = new Hashtable();
        }
        return this._$4812.put(propName, propVal);
    }

    public void bind(Name name, Object obj) throws NamingException {
        LoadableContext ctx = this._$4860(name, 1);
        String lastName = name.get(name.size() - 1);
        if (lastName.equals("")) {
            throw new InvalidNameException(name.toString());
        }
        if (ctx._$4813.containsKey(lastName)) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this._$4862(name, ctx, null);
        ctx._$4813.put(lastName, new LoadableContextEntry(obj));
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(_$4863.parse(name), obj);
    }

    public void close() throws NamingException {
        this._$4812 = null;
        this._$4813 = null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(_$4863.parse(name), _$4863.parse(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(_$4863.parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        LoadableContext ctx = this._$4860(name, 1);
        String lastName = name.get(name.size() - 1);
        if (lastName.equals("")) {
            throw new InvalidNameException(name.toString());
        }
        if (ctx._$4813.containsKey(lastName)) {
            throw new NameAlreadyBoundException("Cannot create subcontext; name already bound: ".concat(String.valueOf(String.valueOf(name.toString()))));
        }
        this._$4862(name, ctx, null);
        LoadableContext subctx = this._$4848(this._$4812);
        ctx._$4813.put(lastName, subctx);
        return ctx;
    }

    public void destroySubcontext(Name name) throws NamingException {
        LoadableContext ctx = this._$4860(name, 1);
        String lastName = name.get(name.size() - 1);
        Object entry = ctx._$4813.get(lastName);
        if (entry == null) {
            return;
        }
        this._$4862(name, ctx, entry);
        if (entry instanceof LoadableContext) {
            LoadableContext subctx = (LoadableContext)entry;
            if (subctx._$4813.size() > 0) {
                throw new ContextNotEmptyException(name.toString());
            }
        } else {
            throw new NotContextException(name.toString());
        }
        ctx._$4813.remove(lastName);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(_$4863.parse(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this._$4812 == null) {
            return new Hashtable();
        }
        return (Hashtable)this._$4812.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public NameParser getNameParser(String name) throws NamingException {
        return _$4863;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return _$4863;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        LoadableContext ctx = this._$4860(name, 0);
        return new Names(ctx._$4813.entrySet().iterator());
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(_$4863.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        LoadableContext ctx = this._$4860(name, 0);
        return new Bindings(ctx._$4813.entrySet().iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(_$4863.parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        LoadableContext ctx = this._$4860(name, 1);
        int lastIndex = name.size() - 1;
        Object entry = ctx._$4813.get(name.get(lastIndex));
        if (entry == null) {
            NameNotFoundException e = new NameNotFoundException(String.valueOf(String.valueOf(name)).concat(" not found"));
            e.setResolvedName(name.getPrefix(lastIndex));
            e.setRemainingName(name.getSuffix(lastIndex));
            throw e;
        }
        if (entry instanceof LoadableContext) {
            return this._$4848((LoadableContext)entry);
        }
        if (entry instanceof LoadableContextEntry) {
            return ((LoadableContextEntry)entry).getObject();
        }
        throw LoadableContextUtils.newNamingException("Unknown bindings in context: ".concat(String.valueOf(String.valueOf(entry))));
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(_$4863.parse(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        LoadableContext ctx = this._$4860(name, 1);
        int lastIndex = name.size() - 1;
        String lastName = name.get(lastIndex);
        if (lastName.equals("")) {
            throw new InvalidNameException(name.toString());
        }
        Object entry = ctx._$4813.get(lastName);
        if (entry instanceof LoadableContext && ((LoadableContext)entry)._$4813.size() > 0) {
            throw new ContextNotEmptyException(String.valueOf(String.valueOf(name)).concat(" not empty; cannot rebind it"));
        }
        this._$4862(name, ctx, entry);
        ctx._$4813.put(lastName, new LoadableContextEntry(obj));
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(_$4863.parse(name), obj);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this._$4812 != null) {
            return this._$4812.remove(propName);
        }
        return null;
    }

    public void rename(Name name1, Name name2) throws NamingException {
        if (name1.equals(name2)) {
            return;
        }
        LoadableContext ctx1 = this._$4860(name1, 1);
        String lastName1 = name1.get(name1.size() - 1);
        Object entry1 = ctx1._$4813.get(lastName1);
        if (entry1 == null) {
            throw new NameNotFoundException(String.valueOf(String.valueOf(name1)).concat(" not found; cannot be renamed"));
        }
        this._$4862(name1, ctx1, entry1);
        LoadableContext ctx2 = this._$4860(name2, 1);
        String lastName2 = name2.get(name2.size() - 1);
        if (lastName2.equals("")) {
            throw new InvalidNameException(name2.toString());
        }
        Object entry2 = ctx2._$4813.get(lastName2);
        if (entry2 instanceof LoadableContext && ((LoadableContext)entry2)._$4813.size() > 0) {
            throw new ContextNotEmptyException(String.valueOf(String.valueOf(name2)).concat(" not empty; cannot be target of rename"));
        }
        this._$4862(name2, ctx2, entry2);
        ctx1._$4813.remove(lastName1);
        ctx2._$4813.put(name2, entry1);
    }

    public void rename(String name1, String name2) throws NamingException {
        this.rename(_$4863.parse(name1), _$4863.parse(name2));
    }

    public void unbind(Name name) throws NamingException {
        LoadableContext ctx = this._$4860(name, 1);
        int lastIndex = name.size() - 1;
        String lastName = name.get(lastIndex);
        Object entry = ctx._$4813.get(lastName);
        this._$4862(name, ctx, entry);
        if (entry instanceof LoadableContext && ((LoadableContext)entry)._$4813.size() > 0) {
            throw new ContextNotEmptyException(String.valueOf(String.valueOf(name)).concat(" not empty; cannot unbind it"));
        }
        ctx._$4813.remove(lastName);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(_$4863.parse(name));
    }

    private LoadableContext _$4860(Name name, int remain) throws NamingException {
        int lastIndex = name.size() - remain;
        if (lastIndex < 0) {
            throw new InvalidNameException("Empty name");
        }
        LoadableContext ctx = this;
        for (int index = 0; index < lastIndex; ++index) {
            Object entry = ctx._$4813.get(name.get(index));
            if (!(entry instanceof LoadableContext)) {
                if (entry == null) {
                    NameNotFoundException e = new NameNotFoundException();
                    e.setResolvedName(name.getPrefix(index));
                    e.setRemainingName(name.getSuffix(index));
                    throw e;
                }
                NotContextException e = new NotContextException();
                e.setResolvedName(name.getPrefix(index));
                e.setRemainingName(name.getSuffix(index));
                throw e;
            }
            ctx = (LoadableContext)entry;
        }
        return ctx;
    }

    private LoadableContext _$4848(Hashtable env) {
        LoadableContext context = new LoadableContext();
        context._$4815 = this._$4815;
        context._$4812 = env != null ? (Hashtable)env.clone() : null;
        return context;
    }

    private LoadableContext _$4848(LoadableContext ctx) {
        LoadableContext context = new LoadableContext();
        context._$4815 = this._$4815;
        context._$4812 = ctx._$4812 != null ? (Hashtable)ctx._$4812.clone() : null;
        context._$4813 = ctx._$4813;
        return context;
    }

    private void _$4862(Name name, LoadableContext ctx, Object entry) throws NamingException {
        if (ctx._$4814) {
            throw new OperationNotSupportedException(String.valueOf(String.valueOf(new StringBuffer("Context of ").append(name).append(" is read only."))));
        }
        if (entry == null) {
            return;
        }
        if (entry instanceof LoadableContext && ((LoadableContext)entry)._$4814 || entry instanceof LoadableContextEntry && ((LoadableContextEntry)entry).isReadOnly()) {
            throw new OperationNotSupportedException(String.valueOf(String.valueOf(new StringBuffer("Context entry ").append(name).append(" is read only."))));
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    private static class Bindings
    implements NamingEnumeration {
        private Iterator _$4893;

        public Bindings(Iterator entries) {
            this._$4893 = entries;
        }

        public boolean hasMoreElements() {
            return this._$4893.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            try {
                Object object = this.next();
                return object;
            }
            catch (NamingException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Object next() throws NamingException {
            Map.Entry entry = (Map.Entry)this._$4893.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LoadableContext) {
                return new Binding(name, value);
            }
            if (value instanceof LoadableContextEntry) {
                Object object = ((LoadableContextEntry)value).getObject();
                return new Binding(name, object);
            }
            throw LoadableContextUtils.newNamingException("Unknown binding in context: ".concat(String.valueOf(String.valueOf(value))));
        }

        public void close() {
        }
    }

    private static class Names
    implements NamingEnumeration {
        private Iterator _$4893;

        public Names(Iterator entries) {
            this._$4893 = entries;
        }

        public boolean hasMoreElements() {
            return this._$4893.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            try {
                Object object = this.next();
                return object;
            }
            catch (NamingException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Object next() throws NamingException {
            Map.Entry entry = (Map.Entry)this._$4893.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LoadableContext) {
                return new NameClassPair(name, value.getClass().getName());
            }
            if (value instanceof LoadableContextEntry) {
                Object object = ((LoadableContextEntry)value).getObject();
                return new NameClassPair(name, object.getClass().getName());
            }
            throw LoadableContextUtils.newNamingException("Unknown bindings in context: ".concat(String.valueOf(String.valueOf(value))));
        }

        public void close() {
        }
    }
}

