/*
 * Decompiled with CFR 0.152.
 */
package com.indollar.system;

import com.indollar.naming.LoadableContextFactory;
import com.indollar.system.SystemRuntimeException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.apache.log4j.Logger;

public class SystemContext
implements Context {
    static Logger logger = Logger.getLogger((String)(class$com$indollar$system$SystemContext == null ? (class$com$indollar$system$SystemContext = SystemContext.class$("com.indollar.system.SystemContext")) : class$com$indollar$system$SystemContext).getName());
    private static SystemContext _$5399 = null;
    private Context _$4859;
    static Class class$com$indollar$system$SystemContext;

    public static synchronized SystemContext getInstance() {
        if (_$5399 == null) {
            _$5399 = new SystemContext();
        }
        return _$5399;
    }

    public static synchronized boolean isInitialized() {
        return _$5399 != null;
    }

    protected SystemContext() {
        try {
            this.init();
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    protected void init() throws NamingException {
        InitialContext initCtx = null;
        String url = null;
        String factory = null;
        try {
            initCtx = new InitialContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (initCtx != null) {
            try {
                url = (String)initCtx.lookup("java:comp/env/system/context/url");
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                factory = (String)initCtx.lookup("java:comp/env/system/context/factory");
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url == null) {
            try {
                url = System.getProperty("com.indollar.system.context.url");
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        if (factory == null) {
            try {
                factory = System.getProperty("com.indollar.system.context.factory");
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        if (factory == null) {
            factory = "com.indollar.naming.LoadableContextFactory";
        }
        this.init(url, factory);
    }

    public void init(String url) throws NamingException {
        this.init(url, null);
    }

    public void init(String url, String factory) throws NamingException {
        logger.info((Object)String.valueOf(String.valueOf(new StringBuffer("init() url :  ").append(url).append(" factory : ").append(factory))));
        Hashtable<String, String> env = new Hashtable<String, String>(10);
        if (url != null) {
            env.put("java.naming.provider.url", url);
        }
        if (factory == null) {
            this._$4859 = new LoadableContextFactory().getInitialContext((Hashtable)env);
        } else {
            env.put("java.naming.factory.initial", factory);
            this._$4859 = NamingManager.getInitialContext(env);
        }
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        try {
            int n = (Integer)this.lookup(name);
            return n;
        }
        catch (NameNotFoundException e) {
            int n = def;
            return n;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long def) {
        try {
            long l = (Long)this.lookup(name);
            return l;
        }
        catch (NameNotFoundException e) {
            long l = def;
            return l;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    public short getShort(String name, short def) {
        try {
            short s = (Short)this.lookup(name);
            return s;
        }
        catch (NameNotFoundException e) {
            short s = def;
            return s;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte getByte(String name, byte def) {
        try {
            byte by = (Byte)this.lookup(name);
            return by;
        }
        catch (NameNotFoundException e) {
            byte by = def;
            return by;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public char getChar(String name) {
        return this.getChar(name, '\u0000');
    }

    public char getChar(String name, char def) {
        try {
            char c = ((Character)this.lookup(name)).charValue();
            return c;
        }
        catch (NameNotFoundException e) {
            char c = def;
            return c;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float def) {
        try {
            float f = ((Float)this.lookup(name)).floatValue();
            return f;
        }
        catch (NameNotFoundException e) {
            float f = def;
            return f;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double def) {
        try {
            double d = (Double)this.lookup(name);
            return d;
        }
        catch (NameNotFoundException e) {
            double d = def;
            return d;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        try {
            boolean bl = (Boolean)this.lookup(name);
            return bl;
        }
        catch (NameNotFoundException e) {
            boolean bl = def;
            return bl;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String def) {
        try {
            String string = (String)this.lookup(name);
            return string;
        }
        catch (NameNotFoundException e) {
            String string = def;
            return string;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public Object getObject(String name) {
        return this.getObject(name, null);
    }

    public Object getObject(String name, Object def) {
        try {
            Object object = this.lookup(name);
            return object;
        }
        catch (NameNotFoundException e) {
            Object object = def;
            return object;
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setInt(String name, int value) {
        try {
            this.rebind(name, (Object)new Integer(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setLong(String name, long value) {
        try {
            this.rebind(name, (Object)new Long(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setShort(String name, short value) {
        try {
            this.rebind(name, (Object)new Short(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setByte(String name, byte value) {
        try {
            this.rebind(name, (Object)new Byte(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setChar(String name, char value) {
        try {
            this.rebind(name, (Object)new Character(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setFloat(String name, float value) {
        try {
            this.rebind(name, (Object)new Float(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setDouble(String name, double value) {
        try {
            this.rebind(name, (Object)new Double(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setBoolean(String name, boolean value) {
        try {
            this.rebind(name, (Object)new Boolean(value));
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setString(String name, String value) {
        try {
            this.rebind(name, (Object)value);
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public void setObject(String name, Object value) {
        try {
            this.rebind(name, value);
        }
        catch (NamingException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this._$4859.lookup(name);
    }

    public Object lookup(String name) throws NamingException {
        return this._$4859.lookup(name);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this._$4859.bind(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this._$4859.bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this._$4859.rebind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this._$4859.rebind(name, obj);
    }

    public void unbind(Name name) throws NamingException {
        this._$4859.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this._$4859.unbind(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this._$4859.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this._$4859.rename(oldName, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this._$4859.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this._$4859.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this._$4859.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this._$4859.listBindings(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this._$4859.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this._$4859.destroySubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this._$4859.createSubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this._$4859.createSubcontext(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this._$4859.lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this._$4859.lookup(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this._$4859.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this._$4859.getNameParser(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this._$4859.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this._$4859.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._$4859.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._$4859.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._$4859.getEnvironment();
    }

    public void close() throws NamingException {
        this._$4859.close();
    }

    public String getNameInNamespace() throws NamingException {
        return this._$4859.getNameInNamespace();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("<initial-context>");
        SystemContext._$6809(SystemContext.getInstance(), "    ");
        System.out.println("</initial-context>");
    }

    private static void _$6809(Context ctx, String inden) throws NamingException {
        NamingEnumeration<Binding> en = ctx.listBindings("");
        while (en.hasMore()) {
            Binding binding = en.next();
            String name = binding.getName();
            Object value = binding.getObject();
            if (value instanceof Context) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(inden))).append("<context name=").append(name).append(">"))));
                SystemContext._$6809((Context)value, String.valueOf(String.valueOf(inden)).concat("    "));
                System.out.println(String.valueOf(String.valueOf(inden)).concat("</context>"));
                continue;
            }
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(inden))).append("<entry name=").append(name).append(" value=").append(value.toString()).append(" />"))));
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    public static class TestClass {
        private Hashtable _$3033;

        public TestClass(Hashtable table) {
            this._$3033 = table;
        }

        public String toString() {
            return this._$3033.toString();
        }
    }
}

