/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.JCAConnectionFactory;
import org.jboss.management.j2ee.JCAManagedConnectionFactory;
import org.jboss.resource.connectionmanager.BaseConnectionManager2MBean;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionCacheListener;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.jmx.JMXExceptionDecoder;
import org.jboss.util.jmx.MBeanServerLocator;

public abstract class BaseConnectionManager2
extends ServiceMBeanSupport
implements BaseConnectionManager2MBean,
ConnectionCacheListener {
    private static final String SECURITY_MGR_PATH = "java:/jaas/";
    public static final String STOPPING_NOTIFICATION = "jboss.jca.connectionmanagerstopping";
    private ObjectName managedConnectionPoolName;
    private ManagedConnectionPool poolingStrategy;
    private ObjectName managedConnectionFactoryName;
    private ManagedConnectionFactory mcf;
    protected String mcfJndiName;
    private String securityDomainJndiName;
    private SubjectSecurityManager securityDomain;
    private ObjectName jaasSecurityManagerService;
    private ObjectName ccmName;
    private CachedConnectionManager ccm;
    ObjectName jcaConnectionFactory;
    ObjectName jcaManagedConnectionFactory;
    private final Map managedConnectionToListenerMap = Collections.synchronizedMap(new HashMap());
    protected final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$javax$resource$spi$ConnectionManager;
    static /* synthetic */ Class class$java$lang$String;

    public BaseConnectionManager2() {
    }

    public BaseConnectionManager2(ManagedConnectionFactory mcf, CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy) {
        this.mcf = mcf;
        this.ccm = ccm;
        this.poolingStrategy = poolingStrategy;
    }

    public ObjectName getManagedConnectionFactoryName() {
        return this.managedConnectionFactoryName;
    }

    public void setManagedConnectionFactoryName(ObjectName newManagedConnectionFactoryName) {
        this.managedConnectionFactoryName = newManagedConnectionFactoryName;
    }

    public ObjectName getManagedConnectionPool() {
        return this.managedConnectionPoolName;
    }

    public void setManagedConnectionPool(ObjectName newManagedConnectionPool) {
        this.managedConnectionPoolName = newManagedConnectionPool;
    }

    public void setCachedConnectionManager(ObjectName ccmName) {
        this.ccmName = ccmName;
    }

    public ObjectName getCachedConnectionManager() {
        return this.ccmName;
    }

    public void setSecurityDomainJndiName(String securityDomainJndiName) {
        if (securityDomainJndiName != null && securityDomainJndiName.startsWith(SECURITY_MGR_PATH)) {
            securityDomainJndiName = securityDomainJndiName.substring(SECURITY_MGR_PATH.length());
            this.log.warn((Object)"WARNING: UPDATE YOUR SecurityDomainJndiName! REMOVE java:/jaas/");
        }
        this.securityDomainJndiName = securityDomainJndiName;
    }

    public String getSecurityDomainJndiName() {
        return this.securityDomainJndiName;
    }

    public ObjectName getJaasSecurityManagerService() {
        return this.jaasSecurityManagerService;
    }

    public void setJaasSecurityManagerService(ObjectName jaasSecurityManagerService) {
        this.jaasSecurityManagerService = jaasSecurityManagerService;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public BaseConnectionManager2 getInstance() {
        return this;
    }

    public String getName() {
        return "BaseConnectionManager";
    }

    protected void createService() throws Exception {
        this.jcaConnectionFactory = JCAConnectionFactory.create((MBeanServer)this.getServer(), (String)(this.getServiceName().getKeyProperty("name") + "-" + this.getServiceName().getKeyProperty("service")), (ObjectName)this.getServiceName());
        this.jcaManagedConnectionFactory = JCAManagedConnectionFactory.create((MBeanServer)this.getServer(), (String)(this.managedConnectionFactoryName.getKeyProperty("name") + "-" + this.managedConnectionFactoryName.getKeyProperty("service")), (ObjectName)this.jcaConnectionFactory);
    }

    protected void startService() throws Exception {
        super.startService();
        try {
            this.ccm = (CachedConnectionManager)this.getServer().getAttribute(this.ccmName, "Instance");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
        if (this.ccm == null) {
            throw new DeploymentException("cached ConnectionManager not found: " + this.ccmName);
        }
        if (this.securityDomainJndiName != null && this.jaasSecurityManagerService == null) {
            throw new DeploymentException("You must supply both securityDomainJndiName and jaasSecurityManagerService to use container managed security");
        }
        if (this.securityDomainJndiName != null) {
            this.securityDomain = (SubjectSecurityManager)new InitialContext().lookup(SECURITY_MGR_PATH + this.securityDomainJndiName);
        }
        if (this.managedConnectionPoolName == null) {
            throw new DeploymentException("managedConnectionPool not set!");
        }
        try {
            this.poolingStrategy = (ManagedConnectionPool)this.getServer().getAttribute(this.managedConnectionPoolName, "ManagedConnectionPool");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
        if (this.managedConnectionFactoryName == null) {
            throw new DeploymentException("ManagedConnectionFactory not set!");
        }
        try {
            this.mcf = (ManagedConnectionFactory)this.getServer().invoke(this.managedConnectionFactoryName, "startManagedConnectionFactory", new Object[]{new ConnectionManagerProxy(this, this.serviceName)}, new String[]{(class$javax$resource$spi$ConnectionManager == null ? (class$javax$resource$spi$ConnectionManager = BaseConnectionManager2.class$("javax.resource.spi.ConnectionManager")) : class$javax$resource$spi$ConnectionManager).getName()});
            this.mcfJndiName = (String)this.getServer().getAttribute(this.managedConnectionFactoryName, "JndiName");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
        this.poolingStrategy.setManagedConnectionFactory(this.mcf);
    }

    protected void stopService() throws Exception {
        this.sendNotification(new Notification(STOPPING_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        if (this.jaasSecurityManagerService != null && this.securityDomainJndiName != null) {
            this.getServer().invoke(this.jaasSecurityManagerService, "flushAuthenticationCache", new Object[]{this.securityDomainJndiName}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = BaseConnectionManager2.class$("java.lang.String")) : class$java$lang$String).getName()});
        }
        this.shutdown();
        this.mcf = null;
        try {
            this.getServer().invoke(this.managedConnectionFactoryName, "stopManagedConnectionFactory", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not stop ManagedConnectionFactory", (Throwable)e);
        }
        this.poolingStrategy = null;
        this.securityDomain = null;
        this.ccm = null;
        super.stopService();
    }

    protected void destroyService() {
        JCAManagedConnectionFactory.destroy((MBeanServer)this.getServer(), (String)(this.managedConnectionFactoryName.getKeyProperty("name") + "-" + this.managedConnectionFactoryName.getKeyProperty("service")));
        JCAConnectionFactory.destroy((MBeanServer)this.getServer(), (String)(this.getServiceName().getKeyProperty("name") + "-" + this.getServiceName().getKeyProperty("service")));
    }

    public ManagedConnection getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ManagedConnection mc = this.poolingStrategy.getConnection(subject, cri);
        if (this.getConnectionEventListener(mc) == null) {
            this.managedConnectionToListenerMap.put(mc, this.registerConnectionEventListener(mc));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("registering ConnectionEventListener for ManagedConnection: " + mc));
            }
        }
        return mc;
    }

    public void returnManagedConnection(ManagedConnection mc, boolean kill) {
        if (kill) {
            this.managedConnectionToListenerMap.remove(mc);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("killing ManagedConnection, removing ConnectionListener: " + mc));
            }
        }
        try {
            this.poolingStrategy.returnConnection(mc, kill);
        }
        catch (ResourceException re) {
            this.log.warn((Object)("resourceException returning connection: " + mc), (Throwable)re);
        }
    }

    public int getConnectionCount() {
        return this.poolingStrategy.getConnectionCount();
    }

    public void shutdown() {
        this.log.info((Object)("shutting down pool: " + this));
        this.managedConnectionToListenerMap.clear();
        this.poolingStrategy.shutdown();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (!this.mcf.equals((Object)mcf)) {
            throw new ResourceException("Wrong ManagedConnectionFactory sent to allocateConnection!");
        }
        Subject subject = this.getSubject();
        ManagedConnection mc = this.getManagedConnection(subject, cri);
        this.managedConnectionReconnected(mc);
        Object connection = mc.getConnection(subject, cri);
        this.registerAssociation(mc, connection);
        if (this.ccm != null) {
            this.ccm.registerConnection(this, new ConnectionRecord(mc, connection, cri));
        }
        return connection;
    }

    protected abstract ConnectionListener registerConnectionEventListener(ManagedConnection var1) throws ResourceException;

    public void transactionStarted(Collection conns) throws SystemException {
    }

    public void reconnect(Collection conns, Set unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.mcfJndiName)) {
            this.log.trace((Object)"reconnect for unshareable connection: nothing to do");
            return;
        }
        HashMap<ConnectionRequestInfo, ManagedConnection> criToMCMap = new HashMap<ConnectionRequestInfo, ManagedConnection>();
        Iterator i = conns.iterator();
        while (i.hasNext()) {
            ManagedConnection mc;
            ConnectionRecord cr = (ConnectionRecord)i.next();
            if (cr.mc != null) {
                this.log.warn((Object)("reconnecting a connection handle that still has a managedConnection! " + cr.mc + " " + cr.connection));
                if (this.managedConnectionToListenerMap.containsKey(cr.mc)) {
                    throw new IllegalArgumentException("reconnect(ConnectionRecord cr) called with a non null ManagedConnection that was not killed!");
                }
            }
            if ((mc = (ManagedConnection)criToMCMap.get(cr.cri)) == null) {
                mc = this.getManagedConnection(this.getSubject(), cr.cri);
                criToMCMap.put(cr.cri, mc);
                this.managedConnectionReconnected(mc);
            }
            mc.associateConnection(cr.connection);
            this.registerAssociation(mc, cr.connection);
            cr.setManagedConnection(mc);
        }
        criToMCMap.clear();
    }

    public void disconnect(Collection crs, Set unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.mcfJndiName)) {
            this.log.trace((Object)"disconnect for unshareable connection: nothing to do");
            return;
        }
        HashSet<ManagedConnection> mcs = new HashSet<ManagedConnection>();
        Iterator i = crs.iterator();
        while (i.hasNext()) {
            ConnectionRecord cr = (ConnectionRecord)i.next();
            ManagedConnection mc = cr.mc;
            cr.setManagedConnection(null);
            this.unregisterAssociation(mc, cr.connection);
            if (mcs.contains(mc)) continue;
            mcs.add(mc);
        }
        Iterator i2 = mcs.iterator();
        while (i2.hasNext()) {
            this.managedConnectionDisconnected((ManagedConnection)i2.next());
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return super.getNotificationInfo();
    }

    protected ConnectionListener getConnectionEventListener(ManagedConnection mc) {
        return (ConnectionListener)this.managedConnectionToListenerMap.get(mc);
    }

    protected void unregisterAssociation(ManagedConnection mc, Object c) throws ResourceException {
        boolean flag = false;
        ConnectionListener cli = this.getConnectionEventListener(mc);
        if (cli == null) {
            throw new IllegalArgumentException("disconnect(ManagedConnection mc: " + mc + ", Object c: " + c + ") called with unknown managed connection");
        }
        cli.unregisterConnection(c);
        if (cli.isManagedConnectionFree()) {
            mc.cleanup();
        }
    }

    protected final CachedConnectionManager getCcm() {
        return this.ccm;
    }

    protected void managedConnectionReconnected(ManagedConnection mc) throws ResourceException {
    }

    protected void managedConnectionDisconnected(ManagedConnection mc) throws ResourceException {
    }

    private void registerAssociation(ManagedConnection mc, Object c) throws ResourceException {
        ConnectionListener cli = this.getConnectionEventListener(mc);
        cli.registerConnection(c);
    }

    private Subject getSubject() {
        Object credential;
        Principal principal;
        Subject subject = null;
        if (this.securityDomain != null && !this.securityDomain.isValid(principal = SecurityAssociation.getPrincipal(), credential = SecurityAssociation.getCredential(), subject = new Subject())) {
            throw new SecurityException("Invalid authentication attempt, principal=" + principal);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("subject: " + subject));
        }
        return subject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ConnectionManagerProxy
    implements ConnectionManager,
    Serializable {
        private transient BaseConnectionManager2 realCm;
        private final ObjectName cmName;

        ConnectionManagerProxy(BaseConnectionManager2 realCm, ObjectName cmName) {
            this.realCm = realCm;
            this.cmName = cmName;
        }

        public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
            return this.getCM().allocateConnection(mcf, cri);
        }

        private BaseConnectionManager2 getCM() throws ResourceException {
            if (this.realCm == null) {
                try {
                    this.realCm = (BaseConnectionManager2)MBeanServerLocator.locate().getAttribute(this.cmName, "Instance");
                }
                catch (Throwable t) {
                    Throwable t2 = JMXExceptionDecoder.decode((Throwable)t);
                    throw new ResourceException("Problem locating real ConnectionManager: " + t2);
                }
            }
            return this.realCm;
        }
    }

    protected abstract class BaseConnectionEventListener
    implements ConnectionListener {
        private final ManagedConnection mc;
        private int handleCount = 0;
        private final List handles = new LinkedList();
        protected final Logger log = Logger.getLogger(this.getClass());

        protected BaseConnectionEventListener(ManagedConnection mc) {
            this.mc = mc;
        }

        public ManagedConnection getManagedConnection() {
            return this.mc;
        }

        public synchronized void registerConnection(Object handle) {
            ++this.handleCount;
            this.handles.add(handle);
        }

        public synchronized void unregisterConnection(Object handle) {
            this.handles.remove(handle);
            --this.handleCount;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("unregisterConnection: " + this.handleCount));
            }
        }

        public boolean isManagedConnectionFree() {
            return this.handleCount == 0;
        }

        protected void unregisterConnections() {
            Iterator i = this.handles.iterator();
            while (i.hasNext()) {
                BaseConnectionManager2.this.getCcm().unregisterConnection(BaseConnectionManager2.this, i.next());
            }
            this.handles.clear();
            this.handleCount = 0;
        }

        public abstract void connectionErrorOccurred(ConnectionEvent var1);

        public abstract void localTransactionRolledback(ConnectionEvent var1);

        public abstract void localTransactionCommitted(ConnectionEvent var1);

        public abstract void localTransactionStarted(ConnectionEvent var1);

        public abstract void connectionClosed(ConnectionEvent var1);
    }

    static interface ConnectionListener
    extends ConnectionEventListener {
        public ManagedConnection getManagedConnection();

        public void registerConnection(Object var1);

        public void unregisterConnection(Object var1);

        public boolean isManagedConnectionFree();
    }
}

