/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.IdleRemover;
import org.jboss.resource.connectionmanager.PoolFiller;

public class InternalManagedConnectionPool {
    private final ManagedConnectionFactory mcf;
    private final Subject defaultSubject;
    private final ConnectionRequestInfo defaultCri;
    private final PoolParams poolParams;
    private final LinkedList mcs = new LinkedList();
    private final FIFOSemaphore permits;
    private final Logger log;
    private final Counter connectionCounter = new Counter();
    private boolean started = false;

    public InternalManagedConnectionPool(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo cri, PoolParams poolParams, Logger log) {
        this.mcf = mcf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolParams = poolParams;
        this.log = log;
        this.permits = new FIFOSemaphore((long)this.poolParams.maxSize);
        IdleRemover.registerPool(this, poolParams.idleTimeout);
    }

    public long getAvailableConnections() {
        return this.permits.permits();
    }

    public ManagedConnection getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        try {
            if (this.permits.attempt((long)this.poolParams.blockingTimeout)) {
                ManagedConnection mc = null;
                LinkedList linkedList = this.mcs;
                synchronized (linkedList) {
                    if (this.mcs.size() > 0) {
                        mc = ((MCHolder)this.mcs.removeFirst()).getMC();
                    }
                }
                try {
                    if (mc != null) {
                        if ((mc = this.mcf.matchManagedConnections((Set)new SetOfOne(mc), subject, cri)) == null) {
                            throw new ResourceException("Error in use of ManagedConnectionPool: matchManagedConnection failed with subject: " + subject + " and ConnectionRequestInfo: " + cri);
                        }
                        this.log.trace((Object)"returning ManagedConnection from pool");
                        return mc;
                    }
                    mc = this.createConnection(subject, cri);
                    if (!this.started) {
                        this.started = true;
                        PoolFiller.fillPool(this);
                    }
                    this.log.trace((Object)"returning new ManagedConnection");
                    return mc;
                }
                catch (ResourceException re) {
                    this.permits.release();
                    throw re;
                }
            }
            throw new ResourceException("No ManagedConnections Available!");
        }
        catch (InterruptedException ie) {
            throw new ResourceException("Interrupted while requesting permit!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void returnConnection(ManagedConnection mc, boolean kill) {
        this.log.trace((Object)"putting ManagedConnection back into pool");
        boolean wasInPool = false;
        try {
            block10: {
                try {
                    mc.cleanup();
                    if (kill) {
                        LinkedList linkedList = this.mcs;
                        synchronized (linkedList) {
                            Iterator i = this.mcs.iterator();
                            while (i.hasNext()) {
                                MCHolder mch = (MCHolder)i.next();
                                if (mch.getMC() != mc) continue;
                                i.remove();
                                wasInPool = true;
                                break;
                            }
                        }
                        this.doDestroy(mc);
                        break block10;
                    }
                    LinkedList linkedList = this.mcs;
                    synchronized (linkedList) {
                        this.mcs.addLast(new MCHolder(mc));
                    }
                }
                catch (ResourceException re) {
                    this.log.info((Object)"ResourceException returning ManagedConnection to pool:", (Throwable)re);
                    Object var10_10 = null;
                    if (wasInPool) return;
                    this.permits.release();
                    return;
                }
            }
            Object var10_9 = null;
            if (wasInPool) return;
            this.permits.release();
            return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (wasInPool) throw throwable;
            this.permits.release();
            throw throwable;
        }
    }

    public void removeTimedOut() {
        LinkedList linkedList = this.mcs;
        synchronized (linkedList) {
            Iterator i = this.mcs.iterator();
            while (i.hasNext()) {
                MCHolder mch = (MCHolder)i.next();
                if (!mch.isTimedOut()) break;
                i.remove();
                this.doDestroy(mch.getMC());
            }
        }
        PoolFiller.fillPool(this);
    }

    public void shutdown() {
        LinkedList linkedList = this.mcs;
        synchronized (linkedList) {
            Iterator i = this.mcs.iterator();
            while (i.hasNext()) {
                ManagedConnection mc = ((MCHolder)i.next()).getMC();
                i.remove();
                this.doDestroy(mc);
            }
        }
        IdleRemover.unregisterPool(this);
    }

    public void fillToMin() {
        ArrayList<ManagedConnection> newMCs = new ArrayList<ManagedConnection>();
        try {
            while (this.connectionCounter.getCount() < this.poolParams.minSize) {
                newMCs.add(this.getConnection(this.defaultSubject, this.defaultCri));
            }
        }
        catch (ResourceException re) {
            // empty catch block
        }
        Iterator i = newMCs.iterator();
        while (i.hasNext()) {
            this.returnConnection((ManagedConnection)i.next(), false);
        }
    }

    public int getConnectionCount() {
        return this.connectionCounter.getCount();
    }

    public int getConnectionCreatedCount() {
        return this.connectionCounter.getCreatedCount();
    }

    public int getConnectionDestroyedCount() {
        return this.connectionCounter.getDestroyedCount();
    }

    private ManagedConnection createConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        try {
            this.connectionCounter.inc();
            return this.mcf.createManagedConnection(subject, cri);
        }
        catch (ResourceException re) {
            this.connectionCounter.dec();
            throw re;
        }
    }

    private void doDestroy(ManagedConnection mc) {
        this.connectionCounter.dec();
        try {
            mc.destroy();
        }
        catch (ResourceException re) {
            this.log.info((Object)"Exception destroying ManagedConnection", (Throwable)re);
        }
    }

    public static class SetOfOne
    implements Set {
        private final Object object;

        public SetOfOne(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("SetOfOne must contain a non-null object!");
            }
            this.object = object;
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SetOfOne) {
                return this.object == ((SetOfOne)other).object;
            }
            return false;
        }

        public boolean add(Object param1) {
            throw new UnsupportedOperationException("can't add to SetOfOne");
        }

        public int size() {
            return 1;
        }

        public Object[] toArray() {
            return new Object[]{this.object};
        }

        public Object[] toArray(Object[] array) {
            if (array.length < 1) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            }
            array[0] = this.object;
            return array;
        }

        public boolean contains(Object object) {
            return this.object.equals(object);
        }

        public void clear() {
            throw new UnsupportedOperationException("can't clear SetOfOne");
        }

        public boolean remove(Object param1) {
            throw new UnsupportedOperationException("can't remove from SetOfOne");
        }

        public boolean isEmpty() {
            return false;
        }

        public Iterator iterator() {
            return new Iterator(){
                boolean done = false;

                public boolean hasNext() {
                    return !this.done;
                }

                public Object next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return object;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean containsAll(Collection col) {
            if (col == null || col.size() != 1) {
                return false;
            }
            return this.object.equals(col.iterator().next());
        }

        public boolean addAll(Collection param1) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection param1) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection param1) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Counter {
        private int created = 0;
        private int destroyed = 0;

        private Counter() {
        }

        synchronized int getCount() {
            return this.created - this.destroyed;
        }

        synchronized int getCreatedCount() {
            return this.created;
        }

        synchronized int getDestroyedCount() {
            return this.created;
        }

        synchronized void inc() {
            ++this.created;
        }

        synchronized void dec() {
            ++this.destroyed;
        }
    }

    private class MCHolder {
        private final ManagedConnection mc;
        private final long age;

        MCHolder(ManagedConnection mc) {
            this.mc = mc;
            this.age = System.currentTimeMillis();
        }

        ManagedConnection getMC() {
            return this.mc;
        }

        boolean isTimedOut() {
            return System.currentTimeMillis() - this.age > ((InternalManagedConnectionPool)InternalManagedConnectionPool.this).poolParams.idleTimeout;
        }
    }

    public static class PoolParams {
        public int minSize = 0;
        public int maxSize = 10;
        public int blockingTimeout = 5000;
        public long idleTimeout = 1800000L;
    }
}

