/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;
import org.jboss.resource.connectionmanager.JBossManagedConnectionPoolMBean;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.system.ServiceMBeanSupport;

public class JBossManagedConnectionPool
extends ServiceMBeanSupport
implements JBossManagedConnectionPoolMBean {
    private String criteria;
    private ManagedConnectionPool poolingStrategy;
    private final InternalManagedConnectionPool.PoolParams poolParams = new InternalManagedConnectionPool.PoolParams();
    long idleTimeout;

    public ManagedConnectionPool getManagedConnectionPool() {
        return this.poolingStrategy;
    }

    public long getAvailableConnectionCount() {
        return this.poolingStrategy.getAvailableConnectionCount();
    }

    public int getMinSize() {
        return this.poolParams.minSize;
    }

    public void setMinSize(int newMinSize) {
        this.poolParams.minSize = newMinSize;
    }

    public int getMaxSize() {
        return this.poolParams.maxSize;
    }

    public void setMaxSize(int newMaxSize) {
        this.poolParams.maxSize = newMaxSize;
    }

    public int getBlockingTimeoutMillis() {
        return this.poolParams.blockingTimeout;
    }

    public void setBlockingTimeoutMillis(int newBlockingTimeout) {
        this.poolParams.blockingTimeout = newBlockingTimeout;
    }

    public long getIdleTimeoutMinutes() {
        return this.poolParams.idleTimeout / 60000L;
    }

    public void setIdleTimeoutMinutes(long newIdleTimeoutMinutes) {
        this.poolParams.idleTimeout = newIdleTimeoutMinutes * 1000L * 60L;
    }

    public long getIdleTimeout() {
        return this.poolParams.idleTimeout;
    }

    public void setIdleTimeout(long newIdleTimeout) {
        this.poolParams.idleTimeout = newIdleTimeout;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String newCriteria) {
        this.criteria = newCriteria;
    }

    public String getName() {
        return "JBossManagedConnectionPool";
    }

    protected void startService() throws Exception {
        if ("ByContainerAndApplication".equals(this.criteria)) {
            this.poolingStrategy = new PoolBySubjectAndCri(this.poolParams, this.log);
        } else if ("ByContainer".equals(this.criteria)) {
            this.poolingStrategy = new PoolBySubject(this.poolParams, this.log);
        } else if ("ByApplication".equals(this.criteria)) {
            this.poolingStrategy = new PoolByCri(this.poolParams, this.log);
        } else if ("ByNothing".equals(this.criteria)) {
            this.poolingStrategy = new OnePool(this.poolParams, this.log);
        } else {
            throw new DeploymentException("Unknown pooling criteria: " + this.criteria);
        }
    }

    protected void stopService() {
    }

    private static class OnePool
    implements ManagedConnectionPool {
        private InternalManagedConnectionPool mcp;
        private ManagedConnectionFactory mcf;
        private final InternalManagedConnectionPool.PoolParams poolParams;
        private final Logger log;

        public OnePool(InternalManagedConnectionPool.PoolParams poolParams, Logger log) {
            this.poolParams = poolParams;
            this.log = log;
        }

        public long getAvailableConnectionCount() {
            return this.mcp.getAvailableConnections();
        }

        public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
            this.mcf = mcf;
        }

        public ManagedConnection getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
            OnePool onePool = this;
            synchronized (onePool) {
                if (this.mcp == null) {
                    this.mcp = new InternalManagedConnectionPool(this.mcf, subject, cri, this.poolParams, this.log);
                }
            }
            return this.mcp.getConnection(subject, cri);
        }

        public void returnConnection(ManagedConnection mc, boolean kill) {
            this.mcp.returnConnection(mc, kill);
        }

        public int getConnectionCount() {
            return this.mcp == null ? 0 : this.mcp.getConnectionCount();
        }

        public int getConnectionCreatedCount() {
            return this.mcp == null ? 0 : this.mcp.getConnectionCreatedCount();
        }

        public int getConnectionDestroyedCount() {
            return this.mcp == null ? 0 : this.mcp.getConnectionDestroyedCount();
        }

        public void shutdown() {
            if (this.mcp != null) {
                this.mcp.shutdown();
            }
            this.mcp = null;
            this.mcf = null;
        }
    }

    private static class PoolByCri
    extends BasePool {
        public PoolByCri(InternalManagedConnectionPool.PoolParams poolParams, Logger log) {
            super(poolParams, log);
        }

        protected Object getKey(Subject subject, ConnectionRequestInfo cri) {
            return cri;
        }
    }

    private static class PoolBySubject
    extends BasePool {
        public PoolBySubject(InternalManagedConnectionPool.PoolParams poolParams, Logger log) {
            super(poolParams, log);
        }

        protected Object getKey(Subject subject, ConnectionRequestInfo cri) {
            return subject;
        }
    }

    private static class SubjectCriKey {
        private Subject subject;
        private ConnectionRequestInfo cri;

        SubjectCriKey(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
            if (subject == null) {
                throw new ResourceException("Need non-null subject for subject/cri based pooling");
            }
            if (cri == null) {
                throw new ResourceException("Need non-null cri for subject/cri based pooling");
            }
            this.subject = subject;
            this.cri = cri;
        }

        public int hashCode() {
            return this.subject.hashCode() ^ this.cri.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof SubjectCriKey)) {
                return false;
            }
            return this.subject.equals(((SubjectCriKey)other).subject) && this.cri.equals((Object)((SubjectCriKey)other).cri);
        }
    }

    private static class PoolBySubjectAndCri
    extends BasePool {
        public PoolBySubjectAndCri(InternalManagedConnectionPool.PoolParams poolParams, Logger log) {
            super(poolParams, log);
        }

        protected Object getKey(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
            return new SubjectCriKey(subject, cri);
        }
    }

    private static abstract class BasePool
    implements ManagedConnectionPool {
        private final Map pools = new HashMap();
        private final Map mcToPoolMap = new HashMap();
        private ManagedConnectionFactory mcf;
        private final InternalManagedConnectionPool.PoolParams poolParams;
        private final Logger log;

        public BasePool(InternalManagedConnectionPool.PoolParams poolParams, Logger log) {
            this.poolParams = poolParams;
            this.log = log;
        }

        protected abstract Object getKey(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

        public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
            this.mcf = mcf;
        }

        public ManagedConnection getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
            InternalManagedConnectionPool mcp = null;
            Object key = this.getKey(subject, cri);
            Map map = this.pools;
            synchronized (map) {
                mcp = (InternalManagedConnectionPool)this.pools.get(key);
                if (mcp == null) {
                    mcp = new InternalManagedConnectionPool(this.mcf, subject, cri, this.poolParams, this.log);
                    this.pools.put(key, mcp);
                }
            }
            ManagedConnection mc = mcp.getConnection(subject, cri);
            this.mcToPoolMap.put(mc, mcp);
            return mc;
        }

        public void returnConnection(ManagedConnection mc, boolean kill) throws ResourceException {
            InternalManagedConnectionPool mcp = (InternalManagedConnectionPool)this.mcToPoolMap.get(mc);
            if (mcp == null) {
                throw new ResourceException("Returned to wrong Pool!!");
            }
            mcp.returnConnection(mc, kill);
        }

        public int getConnectionCount() {
            int count = 0;
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                count += ((InternalManagedConnectionPool)i.next()).getConnectionCount();
            }
            return count;
        }

        public int getConnectionCreatedCount() {
            int count = 0;
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                count += ((InternalManagedConnectionPool)i.next()).getConnectionCreatedCount();
            }
            return count;
        }

        public int getConnectionDestroyedCount() {
            int count = 0;
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                count += ((InternalManagedConnectionPool)i.next()).getConnectionDestroyedCount();
            }
            return count;
        }

        public long getAvailableConnectionCount() {
            long count = 0L;
            int idx = 0;
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                count += ((InternalManagedConnectionPool)i.next()).getAvailableConnections();
                ++idx;
            }
            return count;
        }

        public void shutdown() {
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                ((InternalManagedConnectionPool)i.next()).shutdown();
            }
            this.pools.clear();
            this.mcf = null;
        }
    }
}

