/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.LocalTxConnectionManagerMBean;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;

public class LocalTxConnectionManager
extends BaseConnectionManager2
implements LocalTxConnectionManagerMBean {
    private String tmName;
    private TransactionManager tm;
    private final Map txToManagedConnectionMap = new HashMap();

    public LocalTxConnectionManager() {
    }

    public LocalTxConnectionManager(ManagedConnectionFactory mcf, CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy, TransactionManager tm) {
        super(mcf, ccm, poolingStrategy);
        this.tm = tm;
    }

    public void setTransactionManager(String tmName) {
        this.tmName = tmName;
    }

    public String getTransactionManager() {
        return this.tmName;
    }

    protected void startService() throws Exception {
        this.tm = (TransactionManager)new InitialContext().lookup(this.tmName);
        super.startService();
    }

    protected void stopService() throws Exception {
        this.tm = null;
        super.stopService();
    }

    public ManagedConnection getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        block8: {
            try {
                if (this.tm.getStatus() == 6) break block8;
                Transaction tx = this.tm.getTransaction();
                ManagedConnection mc = null;
                Map map = this.txToManagedConnectionMap;
                synchronized (map) {
                    mc = (ManagedConnection)this.txToManagedConnectionMap.get(tx);
                }
                if (mc != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("getManagedConnection returning connection " + mc + " already associated with tx " + tx));
                    }
                    return mc;
                }
            }
            catch (SystemException xae) {
                throw new ResourceException("couldn't find current tx" + (Object)((Object)xae));
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.info((Object)"getManagedConnection returning unassociated connection");
        }
        return super.getManagedConnection(subject, cri);
    }

    protected BaseConnectionManager2.ConnectionListener registerConnectionEventListener(ManagedConnection mc) throws ResourceException {
        LocalConnectionEventListener cli = new LocalConnectionEventListener(mc);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    public void transactionStarted(Collection crs) throws SystemException {
        HashSet<ManagedConnection> mcs = new HashSet<ManagedConnection>();
        Iterator i = crs.iterator();
        while (i.hasNext()) {
            ConnectionRecord cr = (ConnectionRecord)i.next();
            ManagedConnection mc = cr.mc;
            if (mcs.contains(mc)) continue;
            mcs.add(mc);
            LocalConnectionEventListener cel = (LocalConnectionEventListener)this.getConnectionEventListener(mc);
            cel.enlist();
        }
        mcs.clear();
    }

    protected void managedConnectionReconnected(ManagedConnection mc) throws ResourceException {
        LocalConnectionEventListener cel = (LocalConnectionEventListener)this.getConnectionEventListener(mc);
        try {
            cel.enlist();
        }
        catch (SystemException se) {
            this.log.info((Object)"Could not enlist in transaction on entering meta-aware object!", (Throwable)se);
            throw new ResourceException("Could not enlist in transaction on entering meta-aware object!" + (Object)((Object)se));
        }
    }

    protected void managedConnectionDisconnected(ManagedConnection mc) throws ResourceException {
        LocalConnectionEventListener cel = (LocalConnectionEventListener)this.getConnectionEventListener(mc);
        if (cel == null) {
            throw new IllegalStateException("ManagedConnection with no ConnectionEventListener! " + mc);
        }
        cel.delist();
        if (cel.isManagedConnectionFree()) {
            this.returnManagedConnection(mc, false);
        }
    }

    private class LocalConnectionEventListener
    extends BaseConnectionManager2.BaseConnectionEventListener
    implements XAResource {
        private Transaction currentTx;
        private Xid currentXid;

        public LocalConnectionEventListener(ManagedConnection mc) throws ResourceException {
            super(mc);
        }

        public void enlist() throws SystemException {
            if (LocalTxConnectionManager.this.tm.getStatus() != 6) {
                Transaction newCurrentTx = LocalTxConnectionManager.this.tm.getTransaction();
                if (this.currentTx != null && this.currentTx != newCurrentTx) {
                    this.log.warn((Object)("in Enlisting tx, trying to change tx. illegal state: old: " + this.currentTx + ", new: " + newCurrentTx + ", cel: " + this));
                    throw new IllegalStateException("Trying to change Tx in enlist!");
                }
                this.currentTx = newCurrentTx;
                if (this.log.isTraceEnabled()) {
                    this.log.info((Object)("enlisting currenttx: " + this.currentTx + ", cel: " + this));
                }
            }
            if (this.currentTx != null) {
                try {
                    this.currentTx.enlistResource((XAResource)this);
                }
                catch (SystemException se) {
                    throw new SystemException("Could not get XAResource from ManagedConnection!" + (Object)((Object)se));
                }
                catch (RollbackException re) {
                    this.log.info((Object)"Could not enlist XAResource!", (Throwable)re);
                    throw new SystemException("Could not enlist XAResource!" + (Object)((Object)re));
                }
            }
        }

        public void delist() throws ResourceException {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("delisting currenttx: " + this.currentTx + ", cel: " + this));
            }
            try {
                if (LocalTxConnectionManager.this.tm.getStatus() != 6) {
                    LocalTxConnectionManager.this.tm.getTransaction().delistResource((XAResource)this, 0x2000000);
                }
            }
            catch (SystemException se) {
                throw new ResourceException("SystemException in delist!" + (Object)((Object)se));
            }
        }

        public void connectionClosed(ConnectionEvent ce) {
            this.log.trace((Object)"connectionClosed called");
            if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
                throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
            }
            try {
                LocalTxConnectionManager.this.getCcm().unregisterConnection(LocalTxConnectionManager.this, ce.getConnectionHandle());
            }
            catch (Throwable t) {
                this.log.info((Object)"throwable from unregister connection", t);
            }
            try {
                LocalConnectionEventListener t = this;
                synchronized (t) {
                    LocalTxConnectionManager.this.unregisterAssociation(this.getManagedConnection(), ce.getConnectionHandle());
                    if (this.isManagedConnectionFree()) {
                        this.delist();
                        LocalTxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), false);
                    }
                }
            }
            catch (ResourceException re) {
                this.log.error((Object)"ResourceException while closing connection handle!", (Throwable)re);
            }
        }

        public void localTransactionStarted(ConnectionEvent ce) {
            if (this.currentTx != null) {
                throw new IllegalStateException("Attempt to start local transaction while xa transaction is active!");
            }
        }

        public void localTransactionCommitted(ConnectionEvent ce) {
            if (this.currentTx != null) {
                throw new IllegalStateException("Attempt to commit local transaction while xa transaction is active!");
            }
        }

        public void localTransactionRolledback(ConnectionEvent ce) {
            if (this.currentTx != null) {
                throw new IllegalStateException("Attempt to roll back local transaction while xa transaction is active!");
            }
        }

        public void connectionErrorOccurred(ConnectionEvent ce) {
            try {
                this.getManagedConnection().getLocalTransaction().rollback();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.currentTx != null) {
                Map t = LocalTxConnectionManager.this.txToManagedConnectionMap;
                synchronized (t) {
                    LocalTxConnectionManager.this.txToManagedConnectionMap.remove(this.currentTx);
                }
            }
            this.currentXid = null;
            this.currentTx = null;
            this.unregisterConnections();
            ManagedConnection mc = (ManagedConnection)ce.getSource();
            LocalTxConnectionManager.this.returnManagedConnection(mc, true);
        }

        public void start(Xid xid, int flags) throws XAException {
            if (this.currentTx == null) {
                throw new IllegalStateException("start called, but no currentTx");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("start, xid: " + xid + ", flags: " + flags));
            }
            if (this.currentXid != null && flags == 0) {
                throw new XAException("Trying to start a new tx when old is not complete! old: " + this.currentXid + ", new " + xid + ", flags " + flags);
            }
            if (this.currentXid == null && flags != 0) {
                throw new XAException("Trying to start a new tx with wrong flags!  new " + xid + ", flags " + flags);
            }
            if (this.currentXid == null) {
                try {
                    this.getManagedConnection().getLocalTransaction().begin();
                }
                catch (ResourceException re) {
                    throw new XAException("Error trying to start local tx: " + (Object)((Object)re));
                }
                this.currentXid = xid;
                Map map = LocalTxConnectionManager.this.txToManagedConnectionMap;
                synchronized (map) {
                    LocalTxConnectionManager.this.txToManagedConnectionMap.put(this.currentTx, this.getManagedConnection());
                }
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("end on xid: " + xid + " called with flags " + flags));
            }
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (this.currentTx == null) {
                throw new IllegalStateException("commit called but no currentTx");
            }
            if (xid != this.currentXid) {
                throw new XAException("wrong xid in commit: expected: " + this.currentXid + ", got: " + xid);
            }
            Map map = LocalTxConnectionManager.this.txToManagedConnectionMap;
            synchronized (map) {
                LocalTxConnectionManager.this.txToManagedConnectionMap.remove(this.currentTx);
            }
            try {
                this.getManagedConnection().getLocalTransaction().commit();
            }
            catch (ResourceException re) {
                LocalTxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), true);
                this.currentXid = null;
                this.currentTx = null;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"commit problem: ", (Throwable)re);
                }
                throw new XAException("could not commit local tx" + (Object)((Object)re));
            }
            LocalConnectionEventListener localConnectionEventListener = this;
            synchronized (localConnectionEventListener) {
                this.currentXid = null;
                this.currentTx = null;
                if (this.isManagedConnectionFree()) {
                    LocalTxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), false);
                }
            }
        }

        public void forget(Xid xid) throws XAException {
            throw new XAException("forget not supported in local tx");
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean isSameRM(XAResource xaResource) throws XAException {
            return xaResource == this;
        }

        public int prepare(Xid xid) throws XAException {
            this.log.warn((Object)"prepare called on a local tx. You are not getting the semantics you expect!");
            return 0;
        }

        public Xid[] recover(int flag) throws XAException {
            throw new XAException("no recover with local-tx only resource managers");
        }

        public void rollback(Xid xid) throws XAException {
            if (this.currentTx == null) {
                throw new IllegalStateException("rollback called but no current tx");
            }
            if (xid != this.currentXid) {
                throw new XAException("wrong xid in rollback: expected: " + this.currentXid + ", got: " + xid);
            }
            Map map = LocalTxConnectionManager.this.txToManagedConnectionMap;
            synchronized (map) {
                LocalTxConnectionManager.this.txToManagedConnectionMap.remove(this.currentTx);
            }
            try {
                this.getManagedConnection().getLocalTransaction().rollback();
            }
            catch (ResourceException re) {
                LocalTxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), true);
                this.currentXid = null;
                this.currentTx = null;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"rollback problem: ", (Throwable)re);
                }
                throw new XAException("could not rollback local tx" + (Object)((Object)re));
            }
            LocalConnectionEventListener localConnectionEventListener = this;
            synchronized (localConnectionEventListener) {
                this.currentXid = null;
                this.currentTx = null;
                if (this.isManagedConnectionFree()) {
                    LocalTxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), false);
                }
            }
        }

        public boolean setTransactionTimeout(int seconds) throws XAException {
            return false;
        }

        public boolean isManagedConnectionFree() {
            if (this.currentTx != null) {
                return false;
            }
            return super.isManagedConnectionFree();
        }
    }
}

