/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;

public class NoTxConnectionManager
extends BaseConnectionManager2 {
    public NoTxConnectionManager() {
    }

    public NoTxConnectionManager(ManagedConnectionFactory mcf, CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy) {
        super(mcf, ccm, poolingStrategy);
    }

    protected BaseConnectionManager2.ConnectionListener registerConnectionEventListener(ManagedConnection mc) {
        NoTxConnectionEventListener cli = new NoTxConnectionEventListener(mc);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    protected void managedConnectionDisconnected(ManagedConnection mc) throws ResourceException {
        NoTxConnectionEventListener cel = (NoTxConnectionEventListener)this.getConnectionEventListener(mc);
        if (cel == null) {
            throw new IllegalStateException("ManagedConnection with no ConnectionEventListener! " + mc);
        }
        if (cel.isManagedConnectionFree()) {
            this.returnManagedConnection(mc, false);
        }
    }

    private class NoTxConnectionEventListener
    extends BaseConnectionManager2.BaseConnectionEventListener {
        private NoTxConnectionEventListener(ManagedConnection mc) {
            super(mc);
        }

        public void connectionClosed(ConnectionEvent ce) {
            NoTxConnectionManager.this.getCcm().unregisterConnection(NoTxConnectionManager.this, ce.getConnectionHandle());
            try {
                NoTxConnectionManager.this.unregisterAssociation((ManagedConnection)ce.getSource(), ce.getConnectionHandle());
                if (this.isManagedConnectionFree()) {
                    NoTxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), false);
                }
            }
            catch (ResourceException re) {
                this.log.error((Object)"ResourceException while closing connection handle!", (Throwable)re);
            }
        }

        public void localTransactionStarted(ConnectionEvent ce) {
        }

        public void localTransactionCommitted(ConnectionEvent ce) {
        }

        public void localTransactionRolledback(ConnectionEvent ce) {
        }

        public void connectionErrorOccurred(ConnectionEvent ce) {
            NoTxConnectionManager.this.getCcm().unregisterConnection(NoTxConnectionManager.this, ce.getConnectionHandle());
            ManagedConnection mc = (ManagedConnection)ce.getSource();
            NoTxConnectionManager.this.returnManagedConnection(mc, true);
        }
    }
}

