/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.util.jmx.MBeanServerLocator;

public abstract class AbstractPasswordCredentialLoginModule
extends AbstractServerLoginModule
implements NotificationListener {
    private MBeanServer server;
    private ObjectName managedConnectionFactoryName;
    private ManagedConnectionFactory mcf;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$security$AbstractPasswordCredentialLoginModule == null ? (class$org$jboss$resource$security$AbstractPasswordCredentialLoginModule = AbstractPasswordCredentialLoginModule.class$("org.jboss.resource.security.AbstractPasswordCredentialLoginModule")) : class$org$jboss$resource$security$AbstractPasswordCredentialLoginModule));
    static /* synthetic */ Class class$org$jboss$resource$security$AbstractPasswordCredentialLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        try {
            this.managedConnectionFactoryName = new ObjectName((String)options.get("managedConnectionFactoryName"));
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Malformed ObjectName: " + (String)options.get("managedConnectionFactoryName"));
        }
        if (this.managedConnectionFactoryName == null) {
            throw new IllegalArgumentException("Must supply a managedConnectionFactoryName!");
        }
        this.server = MBeanServerLocator.locate();
        this.getMcf();
    }

    public boolean login() throws LoginException {
        if (this.mcf == null) {
            return false;
        }
        return super.login();
    }

    protected ManagedConnectionFactory getMcf() {
        if (this.mcf == null) {
            try {
                this.mcf = (ManagedConnectionFactory)this.server.getAttribute(this.managedConnectionFactoryName, "ManagedConnectionFactory");
                NotificationFilterSupport nf = new NotificationFilterSupport();
                nf.enableType("jboss.jca.connectionmanagerstopping");
                this.server.addNotificationListener(this.managedConnectionFactoryName, this, (NotificationFilter)nf, new Object());
            }
            catch (Exception e) {
                log.error((Object)("The ConnectionManager mbean: " + this.managedConnectionFactoryName + " specified in a ConfiguredIdentityLoginModule could not be found.  ConnectionFactory will be unusable!"));
                throw new IllegalArgumentException("Managed Connection Factory not found: " + this.managedConnectionFactoryName);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("mcfname: " + this.managedConnectionFactoryName));
            }
        }
        return this.mcf;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getSource().equals(this.managedConnectionFactoryName)) {
            this.removeCredentials();
            this.mcf = null;
            try {
                this.server.removeNotificationListener(this.managedConnectionFactoryName, this);
            }
            catch (Exception e) {
                log.error((Object)("The ConnectionManager mbean: " + this.managedConnectionFactoryName + " could not have the login module " + this + " removed.  This may result in a memory leak!"));
            }
        }
    }

    public boolean logout() throws LoginException {
        this.removeCredentials();
        return super.logout();
    }

    protected void removeCredentials() {
        this.sharedState.remove("javax.security.auth.login.name");
        this.sharedState.remove("javax.security.auth.login.password");
        Set<Object> credentials = this.subject.getPrivateCredentials();
        Iterator<Object> i = credentials.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof PasswordCredential) || ((PasswordCredential)o).getManagedConnectionFactory() != this.mcf) continue;
            i.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

