/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EJBModuleMBean;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEApplication;
import org.jboss.management.j2ee.J2EEDeployedObject;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEModule;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.StateManagement;

public class EJBModule
extends J2EEModule
implements EJBModuleMBean {
    public static final String J2EE_TYPE = "EJBModule";
    private List mEJBs = new ArrayList();
    private StateManagement mState;
    private ObjectName mService;
    private static final Map mCreatedParents = new HashMap();
    static /* synthetic */ Class class$org$jboss$management$j2ee$EJBModule;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class array$Ljavax$management$ObjectName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectName create(MBeanServer pServer, String pApplicationName, String pName, URL pURL, ObjectName pService) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$EJBModule == null ? (class$org$jboss$management$j2ee$EJBModule = EJBModule.class$("org.jboss.management.j2ee.EJBModule")) : class$org$jboss$management$j2ee$EJBModule));
        if (!J2EEServer.sIsActive) {
            return null;
        }
        String lDD = null;
        ObjectName lApplication = null;
        ObjectName lCreated = null;
        try {
            ObjectName serverQuery = new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*");
            Set<ObjectName> servers = pServer.queryNames(serverQuery, null);
            if (servers.size() != 1) {
                return null;
            }
            ObjectName lServer = servers.iterator().next();
            String lServerName = lServer.getKeyPropertyList().get("j2eeType") + "=" + lServer.getKeyPropertyList().get("name");
            lLog.debug((Object)("EJBModule.create(), server name: " + lServerName));
            if (pName.compareTo(pApplicationName) != 0) {
                ObjectName parentAppQuery = new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEApplication" + "," + "name=" + pApplicationName + "," + lServerName + "," + "*");
                Set<ObjectName> parentApps = pServer.queryNames(parentAppQuery, null);
                if (parentApps.size() == 0) {
                    lApplication = lCreated = J2EEApplication.create(pServer, pApplicationName, null);
                } else {
                    if (parentApps.size() != 1) return null;
                    lApplication = parentApps.iterator().next();
                }
            } else {
                Hashtable<String, String> lProperties = new Hashtable<String, String>();
                lProperties.put("J2EEServer", lServer.getKeyPropertyList().get("name"));
                lProperties.put("name", " ");
                lApplication = new ObjectName(J2EEManagedObject.getDomainName(), lProperties);
            }
            lDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 2);
        }
        catch (Exception e) {
            return null;
        }
        try {
            lLog.debug((Object)("Create EJB-Module, name: " + pName + ", application: " + lApplication));
            if (lLog.isTraceEnabled()) {
                lLog.trace((Object)("Deployment Descriptor:\n" + lDD));
            }
            ObjectName lEJBModule = pServer.createMBean("org.jboss.management.j2ee.EJBModule", null, new Object[]{pName, lApplication, null, lDD, pService}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = EJBModule.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = EJBModule.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (array$Ljavax$management$ObjectName == null ? (array$Ljavax$management$ObjectName = EJBModule.class$("[Ljavax.management.ObjectName;")) : array$Ljavax$management$ObjectName).getName(), (class$java$lang$String == null ? (class$java$lang$String = EJBModule.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = EJBModule.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
            if (lCreated == null) return lEJBModule;
            mCreatedParents.put(lEJBModule, lCreated);
            return lEJBModule;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pModuleName) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$EJBModule == null ? (class$org$jboss$management$j2ee$EJBModule = EJBModule.class$("org.jboss.management.j2ee.EJBModule")) : class$org$jboss$management$j2ee$EJBModule));
        if (!J2EEServer.sIsActive) {
            return;
        }
        try {
            ObjectName lName = new ObjectName(pModuleName);
            pServer.unregisterMBean(lName);
            ObjectName lParent = (ObjectName)mCreatedParents.get(lName);
            if (lParent != null) {
                lLog.info((Object)("Remove fake JSR-77 parent Application: " + lParent.toString()));
                J2EEApplication.destroy(pServer, lParent.toString());
            }
        }
        catch (InstanceNotFoundException infe) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public EJBModule(String pName, ObjectName pApplication, ObjectName[] pJVMs, String pDeploymentDescriptor, ObjectName pService) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pApplication, pJVMs, pDeploymentDescriptor);
        this.mService = pService;
        this.mState = new StateManagement(this);
    }

    public ObjectName[] getEJBs() {
        return this.mEJBs.toArray(new ObjectName[0]);
    }

    public ObjectName getEJB(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mEJBs.size()) {
            return (ObjectName)this.mEJBs.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("EntityBean".equals(lType) || "StatelessSessionBean".equals(lType) || "StatefulSessionBean".equals(lType) || "MessageDrivenBean".equals(lType)) {
            this.mEJBs.add(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("EntityBean".equals(lType) || "StatelessSessionBean".equals(lType) || "StatefulSessionBean".equals(lType) || "MessageDrivenBean".equals(lType)) {
            this.mEJBs.remove(pChild);
        }
    }

    public void postCreation() {
        try {
            this.getServer().addNotificationListener(this.mService, this.mState, null, null);
        }
        catch (JMException jMException) {
            // empty catch block
        }
        this.sendNotification(new Notification(StateManagement.sTypes[0], this.getName(), 1L, System.currentTimeMillis(), "EJB Module created"));
    }

    public void preDestruction() {
        this.sendNotification(new Notification(StateManagement.sTypes[1], this.getName(), 1L, System.currentTimeMillis(), "EJB Module deleted"));
        try {
            this.getServer().removeNotificationListener(this.mService, this.mState);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String[] getEventTypes() {
        return StateManagement.sTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.sTypes.length) {
            return StateManagement.sTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        try {
            this.getServer().invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Start of EJBModule failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        try {
            this.mejbStart();
        }
        catch (Exception e) {
            this.getLog().error((Object)"Recursive Start of EJBModule failed", (Throwable)e);
        }
    }

    public void mejbStop() {
        try {
            this.getServer().invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of EJBMOdule failed", (Throwable)e);
        }
    }

    public String toString() {
        return "EJBModule[ " + super.toString() + "EJBs: " + this.mEJBs + " ]";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("J2EEApplication", lProperties.get("name"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

