/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EventProvider;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObjectMBean;
import org.jboss.management.j2ee.StateManageable;
import org.jboss.management.j2ee.StatisticsProvider;
import org.jboss.system.ServiceMBeanSupport;

public abstract class J2EEManagedObject
extends ServiceMBeanSupport
implements J2EEManagedObjectMBean,
Serializable {
    public static final String TYPE = "j2eeType";
    public static final String NAME = "name";
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$J2EEManagedObject == null ? (class$org$jboss$management$j2ee$J2EEManagedObject = J2EEManagedObject.class$("org.jboss.management.j2ee.J2EEManagedObject")) : class$org$jboss$management$j2ee$J2EEManagedObject));
    private ObjectName mParent = null;
    private ObjectName mName = null;
    private static String sDomainName = null;
    static /* synthetic */ Class class$org$jboss$management$j2ee$J2EEManagedObject;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static String getDomainName() {
        return sDomainName;
    }

    protected static String getType(ObjectName pName) {
        String lType = null;
        if (pName != null) {
            lType = pName.getKeyPropertyList().get(TYPE);
        }
        return lType == null ? "" : lType;
    }

    protected static void removeObject(MBeanServer pServer, String pSearchCriteria) throws JMException {
        Set<ObjectName> lNames = pServer.queryNames(new ObjectName(pSearchCriteria), null);
        if (!lNames.isEmpty()) {
            pServer.unregisterMBean(lNames.iterator().next());
        }
    }

    public J2EEManagedObject(String pDomainName, String pType, String pName) throws MalformedObjectNameException {
        if (pDomainName == null) {
            throw new InvalidParameterException("Domain Name must be set");
        }
        sDomainName = pDomainName;
        Hashtable<String, String> lProperties = new Hashtable<String, String>();
        lProperties.put(TYPE, pType);
        lProperties.put(NAME, pName);
        this.mName = new ObjectName(J2EEManagedObject.getDomainName(), lProperties);
        log.debug((Object)("create root with name: " + this.mName));
    }

    public J2EEManagedObject(String pType, String pName, ObjectName pParent) throws MalformedObjectNameException, InvalidParentException {
        Hashtable lProperties = this.getParentKeys(pParent);
        lProperties.put(TYPE, pType);
        lProperties.put(NAME, pName);
        this.mName = new ObjectName(J2EEManagedObject.getDomainName(), lProperties);
        this.setParent(pParent);
    }

    public ObjectName getObjectName() {
        log.debug((Object)("getObjectName(), name: " + this.mName));
        return this.mName;
    }

    public ObjectName getParent() {
        return this.mParent;
    }

    public void setParent(ObjectName pParent) throws InvalidParentException {
        if (pParent == null) {
            throw new InvalidParameterException("Parent must be set");
        }
        this.mParent = pParent;
    }

    public void addChild(ObjectName pChild) {
    }

    public void removeChild(ObjectName pChild) {
    }

    public boolean isStateManageable() {
        return this instanceof StateManageable;
    }

    public boolean isStatisticsProvider() {
        return this instanceof StatisticsProvider;
    }

    public boolean isEventProvider() {
        return this instanceof EventProvider;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) {
        return this.getObjectName();
    }

    public final void postRegister(Boolean pRegistrationDone) {
        try {
            log.debug((Object)("postRegister(), parent: " + this.mParent));
            if (pRegistrationDone.booleanValue()) {
                this.postCreation();
                if (this.mParent != null) {
                    try {
                        if (this.mParent.getKeyProperty(NAME).compareTo(" ") != 0) {
                            this.getServer().invoke(this.mParent, "addChild", new Object[]{this.mName}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = J2EEManagedObject.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
                        } else {
                            ObjectName lServer = this.getServer().queryNames(new ObjectName(J2EEManagedObject.getDomainName() + ":" + TYPE + "=" + "J2EEServer" + "," + "name=" + this.mParent.getKeyProperty("J2EEServer") + "," + "*"), null).iterator().next();
                            this.getServer().invoke(lServer, "addChild", new Object[]{this.mName}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = J2EEManagedObject.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
                        }
                        super.postRegister(pRegistrationDone);
                    }
                    catch (JMException jme) {
                        super.postRegister(new Boolean(false));
                    }
                }
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"Caught Runtime Exception is postRegister()", (Throwable)re);
            throw re;
        }
    }

    public final void preDeregister() throws Exception {
        log.debug((Object)("preDeregister(), parent: " + this.mParent));
        try {
            if (this.mParent != null) {
                try {
                    this.getServer().invoke(this.mParent, "removeChild", new Object[]{this.mName}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = J2EEManagedObject.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
                }
                catch (InstanceNotFoundException infe) {
                    // empty catch block
                }
            }
            this.preDestruction();
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String toString() {
        return "J2EEManagedObject [ name: " + this.mName + ", parent: " + this.mParent + " ];";
    }

    protected void postCreation() {
    }

    protected void preDestruction() {
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        return new Hashtable();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

