/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.JCAConnectionFactoryMBean;
import org.jboss.management.j2ee.JCAResource;
import org.jboss.management.j2ee.StateManagement;

public class JCAConnectionFactory
extends J2EEManagedObject
implements JCAConnectionFactoryMBean {
    public static final String J2EE_TYPE = "JCAConnectionFactory";
    private StateManagement mState;
    private ObjectName mService;
    private ObjectName mManagedConnectionFactory;
    static /* synthetic */ Class class$org$jboss$management$j2ee$JCAConnectionFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static ObjectName create(MBeanServer pServer, String pName, ObjectName pService) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JCAConnectionFactory == null ? (class$org$jboss$management$j2ee$JCAConnectionFactory = JCAConnectionFactory.class$("org.jboss.management.j2ee.JCAConnectionFactory")) : class$org$jboss$management$j2ee$JCAConnectionFactory));
        if (!J2EEServer.sIsActive) {
            return null;
        }
        ObjectName lServer = null;
        try {
            lServer = pServer.queryNames(new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            return null;
        }
        ObjectName lJCAResource = null;
        try {
            Set<ObjectName> lNames = pServer.queryNames(new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "JCAResource" + "," + "*"), null);
            lJCAResource = lNames.isEmpty() ? JCAResource.create(pServer, "JCA") : lNames.iterator().next();
        }
        catch (Exception e) {
            return null;
        }
        try {
            return pServer.createMBean("org.jboss.management.j2ee.JCAConnectionFactory", null, new Object[]{pName, lJCAResource, pService}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = JCAConnectionFactory.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JCAConnectionFactory.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JCAConnectionFactory.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pName) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JCAConnectionFactory == null ? (class$org$jboss$management$j2ee$JCAConnectionFactory = JCAConnectionFactory.class$("org.jboss.management.j2ee.JCAConnectionFactory")) : class$org$jboss$management$j2ee$JCAConnectionFactory));
        if (!J2EEServer.sIsActive) {
            return;
        }
        try {
            J2EEManagedObject.removeObject(pServer, J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + J2EE_TYPE + "," + "name=" + pName + "," + "*");
            JCAResource.destroy(pServer, "JCA");
        }
        catch (InstanceNotFoundException infe) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public JCAConnectionFactory(String pName, ObjectName pServer, ObjectName pService) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pServer);
        this.mService = pService;
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.sTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.sTypes.length) {
            return StateManagement.sTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        try {
            this.getServer().invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Start of JCA Connection Factory failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        try {
            this.mejbStart();
        }
        catch (Exception e) {
            this.getLog().error((Object)"Recursive Start of JCA Connection Factory failed", (Throwable)e);
        }
    }

    public void mejbStop() {
        try {
            this.getServer().invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of JCA Connection Factory failed", (Throwable)e);
        }
    }

    public ObjectName getManagedConnectionFactory() {
        return this.mManagedConnectionFactory;
    }

    public void postCreation() {
        try {
            this.getServer().addNotificationListener(this.mService, this.mState, null, null);
        }
        catch (JMException jMException) {
            // empty catch block
        }
        this.sendNotification(new Notification(StateManagement.sTypes[0], this.getName(), 1L, System.currentTimeMillis(), "JCA Connection Factory created"));
    }

    public void preDestruction() {
        Logger lLog = this.getLog();
        if (lLog.isInfoEnabled()) {
            lLog.info((Object)("JCAConnectionFactory.preDeregister(): " + this.getName()));
        }
        this.sendNotification(new Notification(StateManagement.sTypes[1], this.getName(), 1L, System.currentTimeMillis(), "JCA Connection Factory deleted"));
        try {
            this.getServer().removeNotificationListener(this.mService, this.mState);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String toString() {
        return "JCAConnectionFactory { " + super.toString() + " } [ " + " ]";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("JCAResource", lProperties.get("name"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

