/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.JCAResourceMBean;
import org.jboss.management.j2ee.StateManagement;

public class JCAResource
extends J2EEResource
implements JCAResourceMBean {
    public static final String J2EE_TYPE = "JCAResource";
    private StateManagement mState;
    private ObjectName mService;
    private List mConnectionFactories = new ArrayList();
    static /* synthetic */ Class class$org$jboss$management$j2ee$JCAResource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static ObjectName create(MBeanServer pServer, String pName) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JCAResource == null ? (class$org$jboss$management$j2ee$JCAResource = JCAResource.class$("org.jboss.management.j2ee.JCAResource")) : class$org$jboss$management$j2ee$JCAResource));
        if (!J2EEServer.sIsActive) {
            return null;
        }
        ObjectName lServer = null;
        try {
            lServer = pServer.queryNames(new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            return null;
        }
        try {
            return pServer.createMBean("org.jboss.management.j2ee.JCAResource", null, new Object[]{pName, lServer}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = JCAResource.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JCAResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pName) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JCAResource == null ? (class$org$jboss$management$j2ee$JCAResource = JCAResource.class$("org.jboss.management.j2ee.JCAResource")) : class$org$jboss$management$j2ee$JCAResource));
        if (!J2EEServer.sIsActive) {
            return;
        }
        try {
            ObjectName lJCAResource;
            ObjectName[] lConnectionFactories;
            ObjectName lSearch = new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + J2EE_TYPE + "," + "name=" + pName + "," + "*");
            Set<ObjectName> lNames = pServer.queryNames(lSearch, null);
            if (!lNames.isEmpty() && (lConnectionFactories = (ObjectName[])pServer.getAttribute(lJCAResource = lNames.iterator().next(), "ConnectionFactories")).length == 0) {
                pServer.unregisterMBean(lJCAResource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JCAResource(String pName, ObjectName pServer) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pServer);
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.sTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.sTypes.length) {
            return StateManagement.sTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        try {
            this.getServer().invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Start of JCA Resource failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        this.mejbStart();
        Iterator i = this.mConnectionFactories.iterator();
        ObjectName lJCAResource = null;
        while (i.hasNext()) {
            lJCAResource = (ObjectName)i.next();
            try {
                this.getServer().invoke(lJCAResource, "start", new Object[0], new String[0]);
            }
            catch (JMException jme) {
                this.getLog().error((Object)"Recursive Start of JCA Resource failed", (Throwable)jme);
            }
        }
    }

    public void mejbStop() {
        try {
            this.getServer().invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of JCA Resource failed", (Throwable)e);
        }
    }

    public void postCreation() {
        this.sendNotification(new Notification(StateManagement.sTypes[0], this.getName(), 1L, System.currentTimeMillis(), "JCA Resource created"));
    }

    public void preDestruction() {
        this.sendNotification(new Notification(StateManagement.sTypes[1], this.getName(), 1L, System.currentTimeMillis(), "JCA Resource deleted"));
    }

    public ObjectName[] getConnectionFactories() {
        return this.mConnectionFactories.toArray(new ObjectName[this.mConnectionFactories.size()]);
    }

    public ObjectName getConnectionFactory(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mConnectionFactories.size()) {
            return (ObjectName)this.mConnectionFactories.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JCAConnectionFactory".equals(lType)) {
            this.mConnectionFactories.add(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JCAConnectionFactory".equals(lType)) {
            this.mConnectionFactories.remove(pChild);
        }
    }

    public String toString() {
        return "JCAResource { " + super.toString() + " } [ " + "Connection Factories: " + this.mConnectionFactories + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

