/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.JNDIResourceMBean;
import org.jboss.management.j2ee.StateManagement;

public class JNDIResource
extends J2EEResource
implements JNDIResourceMBean {
    public static final String J2EE_TYPE = "JNDIResource";
    private StateManagement mState;
    private ObjectName mService;
    private static final String[] sTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted", "state.stopped", "state.stopping", "state.starting", "state.running", "state.failed"};
    static /* synthetic */ Class class$org$jboss$management$j2ee$JNDIResource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static ObjectName create(MBeanServer pServer, String pName, ObjectName pService) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JNDIResource == null ? (class$org$jboss$management$j2ee$JNDIResource = JNDIResource.class$("org.jboss.management.j2ee.JNDIResource")) : class$org$jboss$management$j2ee$JNDIResource));
        if (!J2EEServer.sIsActive) {
            return null;
        }
        ObjectName lServer = null;
        try {
            lServer = pServer.queryNames(new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            return null;
        }
        try {
            return pServer.createMBean("org.jboss.management.j2ee.JNDIResource", null, new Object[]{pName, lServer, pService}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = JNDIResource.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JNDIResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JNDIResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pName) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JNDIResource == null ? (class$org$jboss$management$j2ee$JNDIResource = JNDIResource.class$("org.jboss.management.j2ee.JNDIResource")) : class$org$jboss$management$j2ee$JNDIResource));
        if (!J2EEServer.sIsActive) {
            return;
        }
        try {
            J2EEManagedObject.removeObject(pServer, J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + J2EE_TYPE + "," + "name=" + pName + "," + "*");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JNDIResource(String pName, ObjectName pServer, ObjectName pService) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pServer);
        Logger log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service name: " + pService));
        }
        this.mService = pService;
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.sTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.sTypes.length) {
            return StateManagement.sTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        try {
            this.getServer().invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Start of JNDI Resource failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        this.mejbStart();
    }

    public void mejbStop() {
        try {
            this.getServer().invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of JNDI Resource failed", (Throwable)e);
        }
    }

    public void postCreation() {
        try {
            this.getServer().addNotificationListener(this.mService, this.mState, null, null);
        }
        catch (JMException jMException) {
            // empty catch block
        }
        this.sendNotification(new Notification(StateManagement.sTypes[0], this.getName(), 1L, System.currentTimeMillis(), "JNDI Resource created"));
    }

    public void preDestruction() {
        this.sendNotification(new Notification(StateManagement.sTypes[1], this.getName(), 1L, System.currentTimeMillis(), "JNDI Resource deleted"));
        try {
            this.getServer().removeNotificationListener(this.mService, this.mState);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String toString() {
        return "JNDIResource { " + super.toString() + " } [ " + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

