/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.security.InvalidParameterException;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.jboss.management.j2ee.J2EEManagedObject;

public class StateManagement
implements NotificationListener {
    public static final String[] sTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted", "state.starting", "state.running", "state.stopping", "state.stopped", "state.failed"};
    private long mStartTime = -1L;
    private int mState = 0;
    private J2EEManagedObject mTarget;

    public static int convertState(boolean pFromService, int pState) {
        if (pFromService) {
            switch (pState) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 0: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
        } else {
            switch (pState) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 4;
                }
            }
        }
        return -1;
    }

    public StateManagement(J2EEManagedObject pTarget) {
        if (pTarget == null) {
            throw new InvalidParameterException("Target for State Management must be defined");
        }
        this.mTarget = pTarget;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(long pTime) {
        this.mStartTime = pTime;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int pState) {
        if (pState != this.mState) {
            this.mState = pState;
            this.mTarget.sendNotification(new Notification(sTypes[this.mState + 2], this.mTarget.getName(), 1L, System.currentTimeMillis(), "State changed"));
        }
    }

    public void handleNotification(Notification pNotification, Object pHandback) {
        AttributeChangeNotification lChange;
        if (pNotification instanceof AttributeChangeNotification && "State".equals((lChange = (AttributeChangeNotification)pNotification).getAttributeName())) {
            int lState = (Integer)lChange.getNewValue();
            long lStartTime = -1L;
            if (lState == 3) {
                lStartTime = lChange.getTimeStamp();
            }
            this.setStartTime(lStartTime);
            this.setState(StateManagement.convertState(true, lState));
        }
    }

    public String toString() {
        return "StateManagement [ State: " + this.mState + ", Start Time: " + this.mStartTime + " ]";
    }
}

