/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import org.jboss.management.j2ee.Statistic;

public class TimeStatistic
extends Statistic
implements javax.management.j2ee.TimeStatistic {
    protected long mCount;
    protected long mMinTime;
    protected long mMaxTime;
    protected long mTotalTime;
    protected double mRequestRate;
    private long mStart = System.currentTimeMillis();

    public TimeStatistic(String pName, String pUnit, String pDescription) {
        super(pName, pUnit, pDescription);
    }

    public long getCount() {
        return this.mCount;
    }

    public long getMinTime() {
        return this.mMinTime;
    }

    public long getMaxTime() {
        return this.mMaxTime;
    }

    public long getTotalTime() {
        return this.mTotalTime;
    }

    public double getRequestRate() {
        return this.mRequestRate;
    }

    public String toString() {
        return "TimStatistic [ Count: " + this.getCount() + ", Min. Time: " + this.getMinTime() + ", Max. Time: " + this.getMaxTime() + ", Total Time: " + this.getTotalTime() + ", Request Rate: " + this.getRequestRate() + ", " + super.toString() + " ]";
    }

    public void add(long pTime) {
        ++this.mCount;
        if (pTime == 0L) {
            this.mMinTime = 1L;
        }
        if (this.mMinTime == 0L) {
            this.mMinTime = pTime;
        }
        this.mMinTime = pTime < this.mMinTime ? pTime : this.mMinTime;
        this.mMaxTime = pTime > this.mMaxTime ? pTime : this.mMaxTime;
        this.mTotalTime += pTime;
        this.mRequestRate = (System.currentTimeMillis() - this.mStart) / (this.mCount * 1000L);
    }

    public void reset() {
        this.mCount = 0L;
        this.mMinTime = 0L;
        this.mMaxTime = 0L;
        this.mTotalTime = 0L;
        this.mRequestRate = 0.0;
    }
}

