/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import org.jboss.ha.framework.interfaces.HARMIProxy;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.MarshalledInvocation;

public class HARMIClient
implements HARMIProxy,
InvocationHandler,
Serializable {
    protected String key = null;
    protected ArrayList targets = null;
    protected LoadBalancePolicy loadBalancePolicy;
    protected transient long currentViewId = 0L;
    protected transient Object local = null;

    public HARMIClient() {
    }

    public HARMIClient(ArrayList targets, LoadBalancePolicy policy, String key) {
        this.targets = targets;
        this.loadBalancePolicy = policy;
        this.loadBalancePolicy.init(this);
        this.key = key;
    }

    public HARMIClient(ArrayList targets, LoadBalancePolicy policy, String key, Object local) {
        this.targets = targets;
        this.loadBalancePolicy = policy;
        this.loadBalancePolicy.init(this);
        this.key = key;
        this.local = local;
    }

    public ArrayList getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList newTargets) {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.clear();
            this.targets.addAll(newTargets);
        }
    }

    public Object getRemoteTarget() {
        if (this.targets.size() == 0) {
            return null;
        }
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            Object object = this.loadBalancePolicy.chooseTarget(this.targets);
            return object;
        }
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    public Method findLocalMethod(Method method, Object[] args) throws Exception {
        return method;
    }

    public Object invokeRemote(Object proxy, Method method, Object[] args) throws Throwable {
        HARMIServer target = (HARMIServer)this.getRemoteTarget();
        while (target != null) {
            try {
                MarshalledInvocation mi = new MarshalledInvocation(null, method, args, null, null, null);
                mi.setObjectName((Object)"");
                HARMIResponse rsp = target.invoke(this.currentViewId, mi);
                if (rsp.newReplicants != null) {
                    this.setTargets(rsp.newReplicants);
                    this.currentViewId = rsp.currentViewId;
                }
                return rsp.response;
            }
            catch (ConnectException ce) {
            }
            catch (ConnectIOException cioe) {
            }
            catch (NoSuchObjectException nsoe) {
            }
            catch (UnmarshalException ue) {
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            this.remoteTargetHasFailed(target);
            target = (HARMIServer)this.getRemoteTarget();
        }
        throw new RemoteException("Service unavailable.");
    }

    public boolean isLocal() {
        return this.local != null;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("isLocal") && (args == null || args.length == 0)) {
            return method.invoke((Object)this, args);
        }
        if (this.local != null) {
            try {
                Method localMethod = this.findLocalMethod(method, args);
                return localMethod.invoke(this.local, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        return this.invokeRemote(null, method, args);
    }

    protected void removeDeadTarget(Object target) {
        if (this.targets != null) {
            ArrayList arrayList = this.targets;
            synchronized (arrayList) {
                int length = this.targets.size();
                int i = 0;
                while (i < length) {
                    if (this.targets.get(i) == target) {
                        this.targets.remove(i);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.key = stream.readUTF();
        this.targets = (ArrayList)stream.readObject();
        this.loadBalancePolicy = (LoadBalancePolicy)stream.readObject();
        HARMIServer server = (HARMIServer)HARMIServer.rmiServers.get(this.key);
        this.loadBalancePolicy.init(this);
        if (server != null) {
            ArrayList arrayList = this.targets;
            synchronized (arrayList) {
                try {
                    this.targets = (ArrayList)server.getReplicants();
                    this.local = server.getLocal();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.key);
        stream.writeObject(this.targets);
        stream.writeObject(this.loadBalancePolicy);
    }
}

