/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.DistributedReplicantManagerImplMBean;
import org.jboss.logging.Logger;

public class DistributedReplicantManagerImpl
implements DistributedReplicantManagerImplMBean,
HAPartition.HAMembershipExtendedListener,
HAPartition.HAPartitionStateTransfer {
    protected static final String SERVICE_NAME = "DistributedReplicantManager";
    protected HashMap localReplicants = new HashMap();
    protected HashMap replicants = new HashMap();
    protected HashMap keyListeners = new HashMap();
    protected HashMap intraviewIdCache = new HashMap();
    protected HAPartition partition;
    protected Logger log;
    protected MBeanServer mbeanserver;
    protected ObjectName jmxName;
    protected String nodeName = null;
    protected Latch partitionNameKnown = new Latch();

    public DistributedReplicantManagerImpl(HAPartition partition, MBeanServer server) {
        this.partition = partition;
        this.mbeanserver = server;
        this.log = Logger.getLogger((String)(partition.getPartitionName() + ":ReplicantManager"));
    }

    public void init() throws Exception {
        this.log.debug((Object)"registerRPCHandler");
        this.partition.registerRPCHandler(SERVICE_NAME, this);
        this.log.debug((Object)"subscribeToStateTransferEvents");
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, this);
        this.log.debug((Object)"registerMembershipListener");
        this.partition.registerMembershipListener(this);
        String name = "jboss:service=DistributedReplicantManager,partitionName=" + this.partition.getPartitionName();
        this.jmxName = new ObjectName(name);
        this.mbeanserver.registerMBean(this, this.jmxName);
    }

    public void start() throws Exception {
        this.nodeName = this.partition.getNodeName();
        this.partitionNameKnown.release();
    }

    public void stop() throws Exception {
        this.mbeanserver.unregisterMBean(this.jmxName);
    }

    public String listContent() throws Exception {
        Collection services = this.getAllServices();
        StringBuffer result = new StringBuffer();
        Iterator catsIter = services.iterator();
        result.append("<pre>");
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            HashMap content = (HashMap)this.replicants.get(category);
            if (content == null) {
                content = new HashMap();
            }
            Iterator keysIter = content.keySet().iterator();
            result.append("-----------------------------------------------\n");
            result.append("Service : ").append(category).append("\n\n");
            Serializable local = this.lookupLocalReplicant(category);
            if (local == null) {
                result.append("\t- Service is *not* available locally\n");
            } else {
                result.append("\t- Service *is* also available locally\n");
            }
            while (keysIter.hasNext()) {
                String location = (String)keysIter.next();
                result.append("\t- ").append(location).append("\n");
            }
            result.append("\n");
        }
        result.append("</pre>");
        return result.toString();
    }

    public String listXmlContent() throws Exception {
        Collection services = this.getAllServices();
        StringBuffer result = new StringBuffer();
        result.append("<ReplicantManager>\n");
        Iterator catsIter = services.iterator();
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            HashMap content = (HashMap)this.replicants.get(category);
            if (content == null) {
                content = new HashMap();
            }
            Iterator keysIter = content.keySet().iterator();
            result.append("\t<Service>\n");
            result.append("\t\t<ServiceName>").append(category).append("</ServiceName>\n");
            Serializable local = this.lookupLocalReplicant(category);
            if (local != null) {
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"True\">").append(this.nodeName).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            while (keysIter.hasNext()) {
                String location = (String)keysIter.next();
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"False\">").append(location).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            result.append("\t<Service>\n");
        }
        result.append("<ReplicantManager>\n");
        return result.toString();
    }

    public Serializable getCurrentState() {
        Collection services = this.getAllServices();
        HashMap<String, HashMap> result = new HashMap<String, HashMap>();
        Iterator catsIter = services.iterator();
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            HashMap content = (HashMap)this.replicants.get(category);
            content = content == null ? new HashMap() : (HashMap)content.clone();
            Serializable local = this.lookupLocalReplicant(category);
            if (local != null) {
                content.put(this.nodeName, local);
            }
            result.put(category, content);
        }
        Object[] globalResult = new Object[]{result, this.intraviewIdCache};
        return globalResult;
    }

    public void setCurrentState(Serializable newState) {
        Object[] globalState = (Object[])newState;
        this.replicants = (HashMap)globalState[0];
        this.intraviewIdCache = (HashMap)globalState[1];
    }

    public Collection getAllServices() {
        HashSet services = new HashSet();
        services.addAll(this.localReplicants.keySet());
        services.addAll(this.replicants.keySet());
        return services;
    }

    public void membershipChangedDuringMerge(Vector deadMembers, Vector newMembers, Vector allMembers, Vector originatingGroups) {
        this.log.info((Object)"Merging partitions...");
        this.log.info((Object)("Dead members: " + deadMembers.size()));
        this.log.info((Object)("Originating groups: " + originatingGroups));
        this.purgeDeadMembers(deadMembers);
        if (newMembers.size() > 0) {
            new MergeMembers().start();
        }
    }

    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        this.log.info((Object)("Dead members: " + deadMembers.size()));
        this.purgeDeadMembers(deadMembers);
    }

    public void add(String key, Serializable replicant) throws Exception {
        this.partitionNameKnown.acquire();
        Object[] args = new Object[]{key, this.nodeName, replicant};
        this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_add", args, true);
        HashMap hashMap = this.localReplicants;
        synchronized (hashMap) {
            this.localReplicants.put(key, replicant);
            this.notifyKeyListeners(key, this.lookupReplicants(key));
        }
    }

    public void remove(String key) throws Exception {
        this.partitionNameKnown.acquire();
        if (this.localReplicants.containsKey(key)) {
            Object[] args = new Object[]{key, this.nodeName};
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, true);
            HashMap hashMap = this.localReplicants;
            synchronized (hashMap) {
                this.localReplicants.remove(key);
                ArrayList result = this.lookupReplicants(key);
                if (result == null) {
                    result = new ArrayList();
                }
                this.notifyKeyListeners(key, result);
            }
        }
    }

    public Serializable lookupLocalReplicant(String key) {
        HashMap hashMap = this.localReplicants;
        synchronized (hashMap) {
            Serializable serializable = (Serializable)this.localReplicants.get(key);
            return serializable;
        }
    }

    public List lookupReplicants(String key) {
        Serializable local = this.lookupLocalReplicant(key);
        HashMap hashMap = this.replicants;
        synchronized (hashMap) {
            HashMap replicant = (HashMap)this.replicants.get(key);
            if (replicant == null && local == null) {
                List list = null;
                return list;
            }
            ArrayList<Serializable> rtn = new ArrayList<Serializable>();
            if (local != null) {
                rtn.add(local);
            }
            if (replicant != null) {
                rtn.addAll(replicant.values());
            }
            ArrayList<Serializable> arrayList = rtn;
            return arrayList;
        }
    }

    public List lookupReplicantsNodeNames(String key) {
        boolean locallyReplicated = this.localReplicants.containsKey(key);
        HashMap hashMap = this.replicants;
        synchronized (hashMap) {
            HashMap replicant = (HashMap)this.replicants.get(key);
            if (replicant == null && !locallyReplicated) {
                List list = null;
                return list;
            }
            ArrayList<String> rtn = new ArrayList<String>();
            if (locallyReplicated) {
                rtn.add(this.nodeName);
            }
            if (replicant != null) {
                rtn.addAll(replicant.keySet());
            }
            ArrayList<String> arrayList = rtn;
            return arrayList;
        }
    }

    public void registerListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList<DistributedReplicantManager.ReplicantListener> listeners = (ArrayList<DistributedReplicantManager.ReplicantListener>)this.keyListeners.get(key);
            if (listeners == null) {
                listeners = new ArrayList<DistributedReplicantManager.ReplicantListener>();
                this.keyListeners.put(key, listeners);
            }
            listeners.add(subscriber);
        }
    }

    public void unregisterListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(key);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove(key);
            }
        }
    }

    public int getReplicantsViewId(String key) {
        Integer result = (Integer)this.intraviewIdCache.get(key);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public boolean isMasterReplica(String key) {
        if (!this.localReplicants.containsKey(key)) {
            return false;
        }
        Vector allNodes = this.partition.getCurrentView();
        HashMap repForKey = (HashMap)this.replicants.get(key);
        if (repForKey == null) {
            return true;
        }
        Vector replicaNodes = new Vector(repForKey.keySet());
        int i = 0;
        while (i < allNodes.size()) {
            String aMember = (String)allNodes.elementAt(i);
            if (replicaNodes.contains(aMember)) {
                return false;
            }
            if (aMember.equals(this.nodeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void _add(String key, String nodeName, Serializable replicant) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("_add(" + key + ", " + nodeName));
        }
        try {
            this.addReplicant(key, nodeName, replicant);
            this.notifyKeyListeners(key, this.lookupReplicants(key));
        }
        catch (Exception ex) {
            this.log.error((Object)"_add failed", (Throwable)ex);
        }
    }

    public void _remove(String key, String nodeName) {
        try {
            if (this.removeReplicant(key, nodeName)) {
                this.notifyKeyListeners(key, this.lookupReplicants(key));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"_remove failed", (Throwable)ex);
        }
    }

    protected boolean removeReplicant(String key, String nodeName) throws Exception {
        HashMap hashMap = this.replicants;
        synchronized (hashMap) {
            HashMap replicant = (HashMap)this.replicants.get(key);
            if (replicant == null) {
                boolean bl = false;
                return bl;
            }
            Object removed = replicant.remove(nodeName);
            if (removed != null) {
                Collection values = replicant.values();
                if (values.size() == 0) {
                    this.replicants.remove(key);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Object[] lookupLocalReplicants() throws Exception {
        this.partitionNameKnown.acquire();
        Object[] rtn = new Object[]{this.nodeName, this.localReplicants};
        this.log.debug((Object)("lookupLocalReplicants called (" + rtn[0] + "). Return: " + this.localReplicants.size()));
        return rtn;
    }

    protected int calculateReplicantsHash(List members) {
        int result = 0;
        Object obj = null;
        int i = 0;
        while (i < members.size()) {
            obj = members.get(i);
            if (obj != null) {
                result += obj.hashCode();
            }
            ++i;
        }
        return result;
    }

    protected int updateReplicantsHashId(String key) {
        List nodes = this.lookupReplicantsNodeNames(key);
        int result = 0;
        if (nodes == null || nodes.size() == 0) {
            this.intraviewIdCache.remove(key);
        } else {
            result = this.calculateReplicantsHash(nodes);
            this.intraviewIdCache.put(key, new Integer(result));
        }
        return result;
    }

    protected void addReplicant(String key, String nodeName, Serializable replicant) {
        this.addReplicant(this.replicants, key, nodeName, replicant);
    }

    protected void addReplicant(HashMap map, String key, String nodeName, Serializable replicant) {
        HashMap hashMap = map;
        synchronized (hashMap) {
            HashMap<String, Serializable> rep = (HashMap<String, Serializable>)map.get(key);
            if (rep == null) {
                this.log.debug((Object)"_adding new HashMap");
                rep = new HashMap<String, Serializable>();
                map.put(key, rep);
            }
            rep.put(nodeName, replicant);
        }
    }

    protected Vector getKeysReplicatedByNode(String nodeName) {
        Vector<String> result = new Vector<String>();
        HashMap hashMap = this.replicants;
        synchronized (hashMap) {
            Iterator keysIter = this.replicants.keySet().iterator();
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                HashMap values = (HashMap)this.replicants.get(key);
                if (values == null || !values.containsKey(nodeName)) continue;
                result.add(key);
            }
        }
        return result;
    }

    protected boolean replicantEntryAlreadyExists(String key, String nodeName) {
        return this.replicantEntryAlreadyExists(this.replicants, key, nodeName);
    }

    protected boolean replicantEntryAlreadyExists(HashMap map, String key, String nodeName) {
        HashMap rep = (HashMap)map.get(key);
        if (rep == null) {
            return false;
        }
        return rep.containsKey(nodeName);
    }

    protected void notifyKeyListeners(String key, List newReplicants) {
        this.log.debug((Object)"notifyKeyListeners");
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            int newId = this.updateReplicantsHashId(key);
            ArrayList listeners = (ArrayList)this.keyListeners.get(key);
            if (listeners == null) {
                this.log.debug((Object)"listeners is null");
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("notifying " + listeners.size() + " listeners for key change: " + key));
            }
            int i = 0;
            while (i < listeners.size()) {
                DistributedReplicantManager.ReplicantListener listener = (DistributedReplicantManager.ReplicantListener)listeners.get(i);
                listener.replicantsChanged(key, newReplicants, newId);
                ++i;
            }
        }
    }

    protected void mergeMembers() {
        try {
            this.log.debug((Object)"Start MergeMembers in DRM");
            HashSet<String> notifies = new HashSet<String>();
            ArrayList rsp = this.partition.callMethodOnCluster(SERVICE_NAME, "lookupLocalReplicants", null, true);
            if (rsp.size() == 0) {
                this.log.info((Object)"No responses from lookupLocalReplicants!");
            } else {
                this.log.info((Object)("lookupLocalReplicants size() = " + rsp.size()));
            }
            int i = 0;
            while (i < rsp.size()) {
                Object[] objs = (Object[])rsp.get(i);
                if (objs == null) {
                    this.log.warn((Object)"mergeMembers received NULL from lookupLocalReplicants");
                } else {
                    String node = (String)objs[0];
                    HashMap replicants = (HashMap)objs[1];
                    Iterator keys = replicants.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (this.replicantEntryAlreadyExists(key, node)) continue;
                        this.addReplicant(key, node, (Serializable)replicants.get(key));
                        notifies.add(key);
                    }
                    Vector currentStatus = this.getKeysReplicatedByNode(node);
                    if (currentStatus.size() > replicants.size()) {
                        int currentKeysId = 0;
                        int currentKeysMax = currentStatus.size();
                        while (currentKeysId < currentKeysMax) {
                            String theKey = (String)currentStatus.elementAt(currentKeysId);
                            if (!replicants.containsKey(theKey)) {
                                this.removeReplicant(theKey, node);
                                notifies.add(theKey);
                            }
                            ++currentKeysId;
                        }
                    }
                }
                ++i;
            }
            Iterator notifIter = notifies.iterator();
            while (notifIter.hasNext()) {
                String key = (String)notifIter.next();
                this.notifyKeyListeners(key, this.lookupReplicants(key));
            }
            this.log.debug((Object)"--------------end MergeMembers");
        }
        catch (Exception ex) {
            this.log.error((Object)"merge failed", (Throwable)ex);
        }
    }

    protected void purgeDeadMembers(Vector deadMembers) {
        if (deadMembers.size() <= 0) {
            return;
        }
        try {
            HashMap hashMap = this.replicants;
            synchronized (hashMap) {
                Iterator keys = this.replicants.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    HashMap replicant = (HashMap)this.replicants.get(key);
                    boolean modified = false;
                    int i = 0;
                    while (i < deadMembers.size()) {
                        String node = deadMembers.elementAt(i).toString();
                        this.log.debug((Object)("trying to remove deadMember " + node + " for key " + key));
                        Object removed = replicant.remove(node);
                        if (removed != null) {
                            this.log.debug((Object)(node + " was removed"));
                            modified = true;
                        } else {
                            this.log.debug((Object)(node + " was NOT removed!!!"));
                        }
                        ++i;
                    }
                    if (!modified) continue;
                    this.notifyKeyListeners(key, this.lookupReplicants(key));
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"membershipChanged failed", (Throwable)ex);
        }
    }

    protected void cleanupKeyListeners() {
    }

    protected class MergeMembers
    extends Thread {
        protected MergeMembers() {
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"Sleeping for 50ms second just in case");
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DistributedReplicantManagerImpl.this.mergeMembers();
        }
    }
}

