/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.DistributedMap;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.DistributedStateImplMBean;
import org.jboss.logging.Logger;
import org.jboss.system.Registry;

public class DistributedStateImpl
implements DistributedStateImplMBean,
DistributedMap,
HAPartition.HAPartitionStateTransfer {
    protected static final String SERVICE_NAME = "DistributedState";
    protected HashMap categories = new HashMap();
    protected HashMap keyListeners = new HashMap();
    protected HashMap dmListeners = new HashMap();
    protected HAPartition partition;
    protected Logger log = null;
    protected MBeanServer mbeanServer = null;
    protected String name = null;
    protected boolean trace;

    public DistributedStateImpl() {
    }

    public DistributedStateImpl(HAPartition partition, MBeanServer server) {
        this.partition = partition;
        this.mbeanServer = server;
        this.log = Logger.getLogger(this.getClass());
    }

    public void init() throws Exception {
        this.trace = this.log.isTraceEnabled();
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, this);
        this.partition.registerRPCHandler(SERVICE_NAME, this);
        this.log.debug((Object)"Registered as RPCHandler: DistributedState");
        this.name = "jboss:service=DistributedState,partitionName=" + this.partition.getPartitionName();
        ObjectName jmxName = new ObjectName(this.name);
        this.mbeanServer.registerMBean(this, jmxName);
        Registry.bind((Object)this.name, (Object)this);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        Registry.unbind((Object)this.name);
        ObjectName jmxName = new ObjectName(this.name);
        this.mbeanServer.unregisterMBean(jmxName);
    }

    public String listContent() throws Exception {
        StringBuffer result = new StringBuffer();
        Collection cats = this.getAllCategories();
        Iterator catsIter = cats.iterator();
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            Iterator keysIter = this.getAllKeys(category).iterator();
            result.append("-----------------------------------------------\n");
            result.append("Category : ").append(category).append("\n\n");
            result.append("KEY\t:\tVALUE\n");
            while (keysIter.hasNext()) {
                String key = keysIter.next().toString();
                String value = this.get(category, key).toString();
                result.append("\"").append(key).append("\"\t:\t\"").append(value).append("\"\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public String listXmlContent() throws Exception {
        StringBuffer result = new StringBuffer();
        Collection cats = this.getAllCategories();
        Iterator catsIter = cats.iterator();
        result.append("<DistributedState>\n");
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            Iterator keysIter = this.getAllKeys(category).iterator();
            result.append("\t<Category>\n");
            result.append("\t\t<CategoryName>").append(category).append("</CategoryName>\n");
            while (keysIter.hasNext()) {
                String key = keysIter.next().toString();
                String value = this.get(category, key).toString();
                result.append("\t\t<Entry>\n");
                result.append("\t\t\t<Key>").append(key).append("</Key>\n");
                result.append("\t\t\t<Value>").append(value).append("</Value>\n");
                result.append("\t\t</Entry>\n");
                result.append("\"").append(key).append("\"\t:\t\"").append(value).append("\"\n");
            }
            result.append("\t</Category>\n");
        }
        result.append("</DistributedState>\n");
        return result.toString();
    }

    public void set(String category, String key, Serializable value) throws Exception {
        this.set(category, (Serializable)((Object)key), value, true);
    }

    public void set(String category, String key, Serializable value, boolean asynchronousCall) throws Exception {
        this.set(category, (Serializable)((Object)key), value, asynchronousCall);
    }

    public Serializable remove(String category, String key) throws Exception {
        return this.remove(category, (Serializable)((Object)key), true);
    }

    public Serializable remove(String category, String key, boolean asynchronousCall) throws Exception {
        return this.remove(category, (Serializable)((Object)key), asynchronousCall);
    }

    public Serializable get(String category, String key) {
        return this.get(category, (Serializable)((Object)key));
    }

    public Collection getAllCategories() {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            Set set = this.categories.keySet();
            return set;
        }
    }

    public Collection getAllKeys(String category) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Collection collection = null;
                return collection;
            }
            Set set = cat.keySet();
            return set;
        }
    }

    public Collection getAllValues(String category) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Collection collection = null;
                return collection;
            }
            Collection collection = cat.values();
            return collection;
        }
    }

    public void registerDSListener(String category, DistributedState.DSListener subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList<DistributedState.DSListener> listeners = (ArrayList<DistributedState.DSListener>)this.keyListeners.get(category);
            if (listeners == null) {
                listeners = new ArrayList<DistributedState.DSListener>();
                this.keyListeners.put(category, listeners);
            }
            listeners.add(subscriber);
        }
    }

    public void unregisterDSListener(String category, DistributedState.DSListener subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove(category);
            }
        }
    }

    public void registerDMListener(String category, DistributedMap.DMListener subscriber) {
        HashMap hashMap = this.dmListeners;
        synchronized (hashMap) {
            ArrayList<DistributedMap.DMListener> listeners = (ArrayList<DistributedMap.DMListener>)this.dmListeners.get(category);
            if (listeners == null) {
                listeners = new ArrayList<DistributedMap.DMListener>();
                this.dmListeners.put(category, listeners);
            }
            listeners.add(subscriber);
        }
    }

    public void unregisterDMListener(String category, DistributedMap.DMListener subscriber) {
        HashMap hashMap = this.dmListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.dmListeners.get(category);
            if (this.dmListeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.dmListeners.remove(category);
            }
        }
    }

    public Serializable get(String category, Serializable key) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            Serializable value = null;
            if (cat != null) {
                value = (Serializable)cat.get(key);
            }
            Serializable serializable = value;
            return serializable;
        }
    }

    public Serializable remove(String category, Serializable key) throws Exception {
        return this.remove(category, key, true);
    }

    public Serializable remove(String category, Serializable key, boolean asynchronousCall) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("remove, category=" + category + ", key=" + key + ", asynchronousCall=" + asynchronousCall));
        }
        Object[] args = new Object[]{category, key};
        if (asynchronousCall) {
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, true);
        } else {
            this.partition.callMethodOnCluster(SERVICE_NAME, "_remove", args, true);
        }
        Serializable removed = this._removeInternal(category, key);
        if (this.trace) {
            this.log.trace((Object)("remove, category=" + category + ", key=" + key + ", removed=" + removed));
        }
        this.notifyKeyListenersOfRemove(category, key, removed, true);
        return removed;
    }

    public void set(String category, Serializable key, Serializable value) throws Exception {
        this.set(category, key, value, true);
    }

    public void set(String category, Serializable key, Serializable value, boolean asynchronousCall) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("set, category=" + category + ", key=" + key + ", value=" + value + ", asynchronousCall=" + asynchronousCall));
        }
        Object[] args = new Object[]{category, key, value};
        if (asynchronousCall) {
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_set", args, true);
        } else {
            this.partition.callMethodOnCluster(SERVICE_NAME, "_set", args, true);
        }
        this._setInternal(category, key, value);
        this.notifyKeyListeners(category, key, value, true);
    }

    public void _set(String category, String key, Serializable value) throws Exception {
        this._set(category, (Serializable)((Object)key), value);
    }

    public void _set(String category, Serializable key, Serializable value) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("_set, category=" + category + ", key=" + key + ", value=" + value));
        }
        this._setInternal(category, key, value);
        this.notifyKeyListeners(category, key, value, false);
    }

    public void _setInternal(String category, String key, Serializable value) throws Exception {
        this._setInternal(category, (Serializable)((Object)key), value);
    }

    public void _setInternal(String category, Serializable key, Serializable value) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("_setInternal, category=" + category + ", key=" + key + ", value=" + value));
        }
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap<Serializable, Serializable> cat = (HashMap<Serializable, Serializable>)this.categories.get(category);
            if (cat == null) {
                cat = new HashMap<Serializable, Serializable>();
                this.categories.put(category, cat);
            }
            cat.put(key, value);
        }
    }

    public void _remove(String category, String key) throws Exception {
        Serializable removed = this._removeInternal(category, key);
        this.notifyKeyListenersOfRemove(category, (Serializable)((Object)key), removed, false);
    }

    public Serializable _removeInternal(String category, String key) throws Exception {
        return this._removeInternal(category, (Serializable)((Object)key));
    }

    public Serializable _removeInternal(String category, Serializable key) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("_removeInternal, category=" + category + ", key=" + key));
        }
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Serializable serializable = null;
                return serializable;
            }
            Object removed = cat.remove(key);
            if (removed != null && cat.size() == 0) {
                this.categories.remove(category);
            }
            if (this.trace) {
                this.log.trace((Object)("_removeInternal, removed=" + removed));
            }
            Serializable serializable = (Serializable)removed;
            return serializable;
        }
    }

    public Serializable getCurrentState() {
        return this.categories;
    }

    public void setCurrentState(Serializable newState) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            this.categories.clear();
            this.categories.putAll((HashMap)newState);
            if (this.keyListeners.size() > 0) {
                this.cleanupKeyListeners();
            }
        }
    }

    protected void notifyKeyListeners(String category, String key, Serializable value, boolean locallyModified) {
        this.notifyKeyListeners(category, (Serializable)((Object)key), value, locallyModified);
    }

    protected void notifyKeyListeners(String category, Serializable key, Serializable value, boolean locallyModified) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners != null) {
                String strKey = key.toString();
                int i = 0;
                while (i < listeners.size()) {
                    DistributedState.DSListener listener = (DistributedState.DSListener)listeners.get(i);
                    listener.valueHasChanged(category, strKey, value, locallyModified);
                    ++i;
                }
            }
            if ((listeners = (ArrayList)this.dmListeners.get(category)) != null) {
                int i = 0;
                while (i < listeners.size()) {
                    DistributedMap.DMListener listener = (DistributedMap.DMListener)listeners.get(i);
                    listener.valueHasChanged(category, key, value, locallyModified);
                    ++i;
                }
            }
        }
    }

    protected void notifyKeyListenersOfRemove(String category, Serializable key, Serializable oldContent, boolean locallyModified) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners != null) {
                String strKey = key.toString();
                int i = 0;
                while (i < listeners.size()) {
                    DistributedState.DSListener listener = (DistributedState.DSListener)listeners.get(i);
                    listener.keyHasBeenRemoved(category, strKey, oldContent, locallyModified);
                    ++i;
                }
            }
            if ((listeners = (ArrayList)this.dmListeners.get(category)) != null) {
                int i = 0;
                while (i < listeners.size()) {
                    DistributedMap.DMListener listener = (DistributedMap.DMListener)listeners.get(i);
                    listener.keyHasBeenRemoved(category, key, oldContent, locallyModified);
                    ++i;
                }
            }
        }
    }

    protected void cleanupKeyListeners() {
    }
}

