/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.deployment.scanner.URLDeploymentScanner;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.FarmMemberServiceMBean;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;

public class FarmMemberService
extends URLDeploymentScanner
implements FarmMemberServiceMBean {
    private MBeanServer mServer;
    protected ObjectName mClusterPartitionName = null;
    protected String mBackgroundPartition = "DefaultPartition";
    private File mTempDirectory;
    protected static final String SERVICE_NAME = "FarmMemberService";
    protected HashMap parentDUMap = new HashMap();

    public String getPartitionName() {
        return this.mBackgroundPartition;
    }

    public void setPartitionName(String pPartitionName) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.mBackgroundPartition = pPartitionName;
        }
    }

    public void setFarmDeployDirectory(String urls) throws MalformedURLException {
        super.setURLs(urls);
    }

    public void setScannerName(String name) {
        this.log.warn((Object)"ScannerName does nothing");
    }

    public String getName() {
        return "Farm Member Service";
    }

    public ObjectName preRegister(MBeanServer pServer, ObjectName pName) throws Exception {
        this.mServer = pServer;
        return super.preRegister(pServer, pName);
    }

    protected void createService() throws Exception {
        super.createService();
        ServerConfig lConfig = ServerConfigLocator.locate();
        this.mTempDirectory = lConfig.getServerTempDir();
    }

    protected void startService() throws Exception {
        this.scannerThread.doScan();
        this.mClusterPartitionName = new ObjectName("jboss:service=" + this.mBackgroundPartition);
        this.log.debug((Object)"registerRPCHandler");
        HAPartition lHAPartition = (HAPartition)this.mServer.getAttribute(this.mClusterPartitionName, "HAPartition");
        lHAPartition.registerRPCHandler(SERVICE_NAME, this);
        ArrayList response = lHAPartition.callMethodOnCluster(SERVICE_NAME, "farmDeployments", new Object[0], true);
        this.log.debug((Object)("Found " + response.size() + " farmDeployments responses"));
        int i = 0;
        while (i < response.size()) {
            Object map = response.get(i);
            if (map != null && map instanceof HashMap) {
                HashMap farmed = (HashMap)map;
                this.pullNewDeployments(lHAPartition, farmed);
            }
            ++i;
        }
        this.scannerThread.setEnabled(this.scanEnabled.get());
    }

    protected void pullNewDeployments(HAPartition partition, HashMap farmed) throws Exception {
        this.log.info((Object)"**** pullNewDeployments ****");
        Iterator it = farmed.keySet().iterator();
        while (it.hasNext()) {
            Date theLast;
            String depName = (String)it.next();
            URLDeploymentScanner.DeployedURL du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(depName);
            Date last = (Date)farmed.get(depName);
            if (du != null && !(theLast = new Date(du.getFile().lastModified())).before(last)) continue;
            ArrayList files = partition.callMethodOnCluster(SERVICE_NAME, "getFarmedDeployment", new Object[]{depName}, true);
            int i = 0;
            while (i < files.size()) {
                Object obj = files.get(i);
                if (obj != null && obj instanceof FarmMemberServiceMBean.FileContent) {
                    FarmMemberServiceMBean.FileContent content = (FarmMemberServiceMBean.FileContent)obj;
                    String parentName = depName.substring(0, depName.indexOf(47));
                    this.farmDeploy(parentName, content, last);
                }
                ++i;
            }
        }
    }

    protected File findParent(String parentName) {
        URL[] urls = this.urlList.toArray(new URL[0]);
        int i = 0;
        while (i < this.urlList.size()) {
            File file;
            if (urls[i].getProtocol().equals("file") && (file = new File(urls[i].getFile())).isDirectory() && file.getName().equals(parentName)) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public HashMap farmDeployments() {
        this.log.debug((Object)("farmDeployments request, parentDUMap.size=" + this.parentDUMap.size()));
        Iterator it = this.parentDUMap.keySet().iterator();
        HashMap<String, Date> farmed = new HashMap<String, Date>();
        while (it.hasNext()) {
            String key = (String)it.next();
            URLDeploymentScanner.DeployedURL du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(key);
            farmed.put(key, new Date(du.getFile().lastModified()));
        }
        return farmed;
    }

    public void farmDeploy(String parentName, FarmMemberServiceMBean.FileContent file, Date date) {
        try {
            File parent = this.findParent(parentName);
            if (parent == null) {
                this.log.info((Object)("Could not find parent: " + parentName + " for deployment: " + file + ", data: " + date));
                return;
            }
            URLDeploymentScanner.DeployedURL du = null;
            HashMap hashMap = this.parentDUMap;
            synchronized (hashMap) {
                du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(parentName + "/" + file.mFile.getName());
            }
            boolean deployIt = false;
            if (du == null) {
                deployIt = true;
            } else {
                Date lastChanged = new Date(du.getFile().lastModified());
                deployIt = lastChanged.before(date);
            }
            if (deployIt) {
                File lFile = new File(this.mTempDirectory, file.mFile.getName());
                FileOutputStream lOutput = new FileOutputStream(lFile);
                lOutput.write(file.mContent);
                lOutput.close();
                this.log.info((Object)("farmDeployment(), deploy locally: " + lFile));
                File lFarmFile = new File(parent, file.mFile.getName());
                if (lFarmFile.exists()) {
                    lFarmFile.delete();
                }
                lFile.setLastModified(date.getTime());
                lFile.renameTo(lFarmFile);
            } else {
                this.log.info((Object)(file.mFile.getName() + " is already deployed by farm service on this node"));
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void farmUndeploy(String parentName, String fileName) {
        try {
            this.log.info((Object)("doUndeployment(), File: " + parentName + "/" + fileName));
            File parent = this.findParent(parentName);
            if (parent == null) {
                this.log.info((Object)("Could not find parent: " + parentName + " for undeployment: " + fileName));
                return;
            }
            File deployed = new File(parent, fileName);
            if (deployed.exists()) {
                deployed.delete();
                this.log.info((Object)("farmUndeployment(), removed file" + deployed));
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    protected FarmMemberServiceMBean.FileContent getFileContent(File pFile) {
        try {
            byte[] lBuffer = new byte[1024];
            FileInputStream lInput = new FileInputStream(pFile);
            ByteArrayOutputStream lOutput = new ByteArrayOutputStream();
            int j = 0;
            while ((j = ((InputStream)lInput).read(lBuffer)) > 0) {
                lOutput.write(lBuffer, 0, j);
            }
            return new FarmMemberServiceMBean.FileContent(pFile, lOutput.toByteArray());
        }
        catch (FileNotFoundException fnfe) {
            this.logException(fnfe);
        }
        catch (IOException ioe) {
            this.logException(ioe);
        }
        return null;
    }

    public FarmMemberServiceMBean.FileContent getFarmedDeployment(String depName) {
        try {
            URLDeploymentScanner.DeployedURL du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(depName);
            File file = du.getFile();
            return this.getFileContent(file);
        }
        catch (Exception ex) {
            this.logException(ex);
            return null;
        }
    }

    protected void deploy(URLDeploymentScanner.DeployedURL du) {
        super.deploy(du);
        File file = du.getFile();
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        HashMap hashMap = this.parentDUMap;
        synchronized (hashMap) {
            this.parentDUMap.put(parent.getName() + "/" + file.getName(), du);
        }
        if (this.getState() == 2) {
            return;
        }
        try {
            FarmMemberServiceMBean.FileContent fileContent = this.getFileContent(file);
            Date fileDate = new Date(file.lastModified());
            HAPartition lHAPartition = (HAPartition)this.mServer.getAttribute(this.mClusterPartitionName, "HAPartition");
            lHAPartition.callMethodOnCluster(SERVICE_NAME, "farmDeploy", new Object[]{parent.getName(), fileContent, fileDate}, true);
        }
        catch (Exception ex) {
            this.logException(ex);
        }
    }

    protected void undeploy(URLDeploymentScanner.DeployedURL du) {
        File file = du.getFile();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        String fileName = file.getName();
        super.undeploy(du);
        HashMap hashMap = this.parentDUMap;
        synchronized (hashMap) {
            this.parentDUMap.remove(parent.getName() + "/" + file.getName());
        }
        if (this.getState() == 1) {
            return;
        }
        try {
            HAPartition lHAPartition = (HAPartition)this.mServer.getAttribute(this.mClusterPartitionName, "HAPartition");
            lHAPartition.callMethodOnCluster(SERVICE_NAME, "farmUndeploy", new Object[]{parentName, fileName}, true);
        }
        catch (Exception ex) {
            this.logException(ex);
        }
    }

    private void logException(Throwable e) {
        if (e instanceof RuntimeErrorException) {
            e = ((RuntimeErrorException)e).getTargetError();
        } else if (e instanceof RuntimeMBeanException) {
            e = ((RuntimeMBeanException)e).getTargetException();
        } else if (e instanceof RuntimeOperationsException) {
            e = ((RuntimeOperationsException)e).getTargetException();
        } else if (e instanceof MBeanException) {
            e = ((MBeanException)e).getTargetException();
        } else if (e instanceof ReflectionException) {
            e = ((ReflectionException)e).getTargetException();
        }
        e.printStackTrace();
        this.log.error((Object)e);
    }
}

