/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.MergeView;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.MethodCall;
import org.javagroups.blocks.MethodLookup;
import org.javagroups.blocks.MethodLookupClos;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;
import org.jboss.ha.framework.interfaces.DistributedMap;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.DistributedReplicantManagerImpl;
import org.jboss.ha.framework.server.DistributedStateImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;

public class HAPartitionImpl
extends RpcDispatcher
implements MessageListener,
MembershipListener,
HAPartition {
    final MethodLookup method_lookup_clos = new MethodLookupClos();
    protected HashMap rpcHandlers = new HashMap();
    protected HashMap stateHandlers = new HashMap();
    protected ArrayList listeners = new ArrayList();
    protected Vector members;
    protected String partitionName;
    protected String nodeName;
    protected int timeout = 60000;
    protected JChannel channel;
    protected DistributedReplicantManagerImpl replicantManager;
    protected DistributedStateImpl dsManager;
    protected Logger log;
    protected long currentViewId = -1L;
    protected MBeanServer server;
    static /* synthetic */ Class class$org$jboss$ha$framework$server$HAPartitionImpl;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public HAPartitionImpl(String partitionName, JChannel channel, boolean deadlock_detection, MBeanServer server) throws Exception {
        this(partitionName, channel, deadlock_detection);
        this.server = server;
    }

    public HAPartitionImpl(String partitionName, JChannel channel, boolean deadlock_detection) throws Exception {
        super((Channel)channel, null, null, new Object(), false);
        this.log = Logger.getLogger((String)((class$org$jboss$ha$framework$server$HAPartitionImpl == null ? (class$org$jboss$ha$framework$server$HAPartitionImpl = HAPartitionImpl.class$("org.jboss.ha.framework.server.HAPartitionImpl")) : class$org$jboss$ha$framework$server$HAPartitionImpl).getName() + "." + partitionName));
        this.channel = channel;
        this.partitionName = partitionName;
    }

    public void init() throws Exception {
        this.log.info((Object)"Initializing");
        this.log.debug((Object)"setMembershipListener");
        this.setMembershipListener(this);
        this.log.debug((Object)"setMessageListener");
        this.setMessageListener(this);
        this.log.debug((Object)"create replicant manager");
        this.replicantManager = new DistributedReplicantManagerImpl(this, this.server);
        this.log.debug((Object)"init replicant manager");
        this.replicantManager.init();
        this.log.debug((Object)"bind replicant manager");
        this.log.debug((Object)"create distributed state");
        this.dsManager = new DistributedStateImpl(this, this.server);
        this.log.debug((Object)"init distributed state service");
        this.dsManager.init();
        this.log.debug((Object)"bind distributed state service");
        InitialContext ctx = new InitialContext();
        this.bind("/HAPartition/" + this.partitionName, this, class$org$jboss$ha$framework$server$HAPartitionImpl == null ? (class$org$jboss$ha$framework$server$HAPartitionImpl = HAPartitionImpl.class$("org.jboss.ha.framework.server.HAPartitionImpl")) : class$org$jboss$ha$framework$server$HAPartitionImpl, ctx);
        this.log.debug((Object)"done initing.");
    }

    public void startPartition() throws Exception {
        this.log.debug((Object)"get nodeName");
        this.nodeName = this.channel.getLocalAddress().toString();
        this.log.debug((Object)"Get current members");
        View view = this.channel.getView();
        this.members = (Vector)view.getMembers().clone();
        this.log.info((Object)("Number of cluster members: " + this.members.size()));
        int m = 0;
        while (m > this.members.size()) {
            Object node = this.members.get(m);
            this.log.debug(node);
            ++m;
        }
        this.currentViewId = view.getVid().getId();
        boolean rc = this.channel.getState(null, 8000L);
        if (rc) {
            this.log.debug((Object)"State was retrieved successfully");
        } else {
            this.log.debug((Object)"State could not be retrieved, (must be first member of group)");
        }
        this.replicantManager.start();
        this.dsManager.start();
    }

    public void closePartition() throws Exception {
        this.log.info((Object)("Closing partition " + this.partitionName));
        try {
            this.replicantManager.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.dsManager.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        String boundName = "/HAPartition/" + this.partitionName;
        InitialContext ctx = new InitialContext();
        try {
            ctx.unbind(boundName);
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        NonSerializableFactory.unbind((String)boundName);
        this.log.info((Object)("Partition " + this.partitionName + " closed."));
    }

    public Object getState() {
        boolean debug = this.log.isDebugEnabled();
        this.log.debug((Object)"getState called.");
        try {
            HashMap<String, Serializable> state = new HashMap<String, Serializable>();
            Iterator keys = this.stateHandlers.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                HAPartition.HAPartitionStateTransfer subscriber = (HAPartition.HAPartitionStateTransfer)this.stateHandlers.get(key);
                if (debug) {
                    this.log.debug((Object)("getState for " + key));
                }
                state.put(key, subscriber.getCurrentState());
            }
            return state;
        }
        catch (Exception ex) {
            this.log.error((Object)"GetState failed", (Throwable)ex);
            return null;
        }
    }

    public void setState(Object obj) {
        try {
            this.log.debug((Object)"setState called");
            if (obj == null) {
                this.log.debug((Object)"state is null");
                return;
            }
            HashMap state = (HashMap)obj;
            Iterator keys = state.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.log.debug((Object)("setState for " + key));
                Object someState = state.get(key);
                HAPartition.HAPartitionStateTransfer subscriber = (HAPartition.HAPartitionStateTransfer)this.stateHandlers.get(key);
                if (subscriber != null) {
                    subscriber.setCurrentState((Serializable)someState);
                    continue;
                }
                this.log.debug((Object)("There is no stateHandler for: " + key));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"setState failed", (Throwable)ex);
        }
    }

    public void receive(Message msg) {
    }

    public void suspect(Address suspected_mbr) {
        this.log.info((Object)("Suspected member: " + suspected_mbr));
    }

    public void block() {
    }

    public void viewAccepted(View newView) {
        boolean debug = this.log.isDebugEnabled();
        try {
            this.currentViewId = newView.getVid().getId();
            if (debug) {
                this.log.info((Object)("New cluster view: " + this.currentViewId + " (" + newView.getMembers() + ")"));
            }
            if (this.members == null) {
                this.members = (Vector)newView.getMembers().clone();
                this.log.debug((Object)"ViewAccepted: initial members set");
                return;
            }
            Vector oldMembers = this.members;
            Vector allMembers = newView.getMembers();
            if (debug) {
                this.log.debug((Object)("membership changed from " + this.members.size() + " to " + allMembers.size()));
            }
            Vector deadMembers = this.getDeadMembers(oldMembers, allMembers);
            Vector newMembers = this.getNewMembers(oldMembers, allMembers);
            this.members = (Vector)allMembers.clone();
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                boolean isAMerge = newView instanceof MergeView;
                Vector originatingGroups = null;
                if (isAMerge) {
                    originatingGroups = ((MergeView)newView).getSubgroups();
                }
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        HAPartition.HAMembershipListener aListener = (HAPartition.HAMembershipListener)this.listeners.get(i);
                        if (isAMerge && aListener instanceof HAPartition.HAMembershipExtendedListener) {
                            ((HAPartition.HAMembershipExtendedListener)aListener).membershipChangedDuringMerge(deadMembers, newMembers, allMembers, originatingGroups);
                        } else {
                            aListener.membershipChanged(deadMembers, newMembers, allMembers);
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"a problem in a listener should not prevent other members to receive the new view", (Throwable)e);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"ViewAccepted failed", (Throwable)ex);
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public DistributedReplicantManager getDistributedReplicantManager() {
        return this.replicantManager;
    }

    public DistributedState getDistributedStateService() {
        return this.dsManager;
    }

    public DistributedMap getDistributedMapService() {
        return this.dsManager;
    }

    public long getCurrentViewId() {
        return this.currentViewId;
    }

    public Vector getCurrentView() {
        Vector<String> result = new Vector<String>(this.members.size());
        if (this.members != null) {
            int i = 0;
            while (i < this.members.size()) {
                result.add(this.members.elementAt(i).toString());
                ++i;
            }
        }
        return result;
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.put(objName, subscriber);
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.remove(objName);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, boolean excludeSelf) throws Exception {
        ArrayList<Object> rtn = new ArrayList<Object>();
        MethodCall m = new MethodCall(objName + "." + methodName, args);
        RspList rsp = this.callRemoteMethods(null, m, 2, this.timeout);
        if (rsp != null) {
            int i = 0;
            while (i < rsp.size()) {
                Object item = rsp.elementAt(i);
                if (item instanceof Rsp) {
                    item = ((Rsp)item).getValue();
                }
                rtn.add(item);
                ++i;
            }
        }
        if (!excludeSelf) {
            m.setName(methodName);
            Object handler = this.rpcHandlers.get(objName);
            Object retval = m.invoke(handler, this.method_lookup_clos);
            if (retval != null) {
                rtn.add(retval);
            }
        }
        return rtn;
    }

    public void callAsynchMethodOnCluster(String objName, String methodName, Object[] args, boolean excludeSelf) throws Exception {
        MethodCall m = new MethodCall(objName + "." + methodName, args);
        this.callRemoteMethods(null, m, 6, this.timeout);
        if (!excludeSelf) {
            m.setName(methodName);
            Object handler = this.rpcHandlers.get(objName);
            m.invoke(handler, this.method_lookup_clos);
        }
    }

    public void subscribeToStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.put(objectName, subscriber);
    }

    public void unsubscribeFromStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.remove(objectName);
    }

    public void registerMembershipListener(HAPartition.HAMembershipListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public void unregisterMembershipListener(HAPartition.HAMembershipListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public Object handle(Message req) {
        Object body = null;
        Object retval = null;
        MethodCall method_call = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Partition " + this.partitionName + " received msg"));
        }
        if (req == null || req.getBuffer() == null) {
            this.log.warn((Object)"RpcProtocol.Handle(): message or message buffer is null !");
            return null;
        }
        try {
            body = Util.objectFromByteBuffer((byte[])req.getBuffer());
        }
        catch (Exception e) {
            this.log.warn((Object)("RpcProtocol.Handle(): " + e));
            return null;
        }
        if (body == null || !(body instanceof MethodCall)) {
            this.log.warn((Object)"RpcProtocol.Handle(): message does not contain a MethodCall object !");
            return null;
        }
        method_call = (MethodCall)body;
        String methodName = method_call.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("pre methodName: " + methodName));
        }
        int idx = methodName.lastIndexOf(46);
        String handlerName = methodName.substring(0, idx);
        String newMethodName = methodName.substring(idx + 1);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("handlerName: " + handlerName + " methodName: " + newMethodName));
            this.log.debug((Object)("Handle: " + methodName));
        }
        method_call.setName(newMethodName);
        Object handler = this.rpcHandlers.get(handlerName);
        retval = method_call.invoke(handler, this.method_lookup_clos);
        return retval;
    }

    protected void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext" + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, (class$org$jboss$naming$NonSerializableFactory == null ? (class$org$jboss$naming$NonSerializableFactory = HAPartitionImpl.class$("org.jboss.naming.NonSerializableFactory")) : class$org$jboss$naming$NonSerializableFactory).getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    protected Vector getDeadMembers(Vector oldMembers, Vector newMembers) {
        boolean debug = this.log.isDebugEnabled();
        Vector dead = new Vector();
        int i = 0;
        while (i < oldMembers.size()) {
            if (debug) {
                this.log.debug((Object)("is node " + oldMembers.elementAt(i).toString() + "dead?"));
            }
            if (!newMembers.contains(oldMembers.elementAt(i))) {
                if (debug) {
                    this.log.debug((Object)("node " + oldMembers.elementAt(i).toString() + "is dead"));
                }
                dead.add(oldMembers.elementAt(i));
            } else if (debug) {
                this.log.debug((Object)("node " + oldMembers.elementAt(i).toString() + "is NOT dead"));
            }
            ++i;
        }
        return dead;
    }

    protected Vector getNewMembers(Vector oldMembers, Vector allMembers) {
        Vector newMembers = new Vector();
        int i = 0;
        while (i < allMembers.size()) {
            if (!oldMembers.contains(allMembers.elementAt(i))) {
                newMembers.add(allMembers.elementAt(i));
            }
            ++i;
        }
        return newMembers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

