/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HARMIClient;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;

public class HARMIServerImpl
implements HARMIServer {
    protected Object handler;
    protected Map invokerMap = new HashMap();
    protected Logger log;
    protected RemoteStub rmistub;
    protected Object stub;
    protected String key;
    protected Class intf;
    protected HATarget target;
    static /* synthetic */ Class class$org$jboss$ha$framework$interfaces$HARMIProxy;

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws Exception {
        this.handler = handler;
        this.log = Logger.getLogger(this.getClass());
        this.intf = intf;
        this.key = partition.getPartitionName() + "/" + replicantName;
        Method[] methods = handler.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Long methodkey = new Long(MarshalledInvocation.calculateHash((Method)methods[i]));
            this.invokerMap.put(methodkey, methods[i]);
            ++i;
        }
        this.rmistub = (RemoteStub)UnicastRemoteObject.exportObject(this, port, csf, ssf);
        this.target = new HATarget(partition, replicantName, this.rmistub);
        HARMIServer.rmiServers.put(this.key, this);
    }

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler) throws Exception {
        this(partition, replicantName, intf, handler, 0, null, null);
    }

    public Object createHAStub(LoadBalancePolicy policy) {
        HARMIClient client = new HARMIClient(this.target.getReplicants(), policy, this.key, this.handler);
        return Proxy.newProxyInstance(this.intf.getClassLoader(), new Class[]{this.intf, class$org$jboss$ha$framework$interfaces$HARMIProxy == null ? (class$org$jboss$ha$framework$interfaces$HARMIProxy = HARMIServerImpl.class$("org.jboss.ha.framework.interfaces.HARMIProxy")) : class$org$jboss$ha$framework$interfaces$HARMIProxy}, (InvocationHandler)client);
    }

    public void destroy() {
        try {
            this.target.destroy();
            HARMIServer.rmiServers.remove(this.key);
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HARMIResponse invoke(long clientViewId, MarshalledInvocation mi) throws Exception {
        mi.setMethodMap(this.invokerMap);
        Method method = mi.getMethod();
        try {
            HARMIResponse rsp = new HARMIResponse();
            if (clientViewId != this.target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(this.target.getReplicants());
                rsp.currentViewId = this.target.getCurrentViewId();
            }
            rsp.response = method.invoke(this.handler, mi.getArguments());
            return rsp;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (InvocationTargetException ite) {
            throw (Exception)ite.getTargetException();
        }
    }

    public List getReplicants() throws Exception {
        return this.target.getReplicants();
    }

    public Object getLocal() throws Exception {
        return this.handler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

