/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.logging.Logger;

public class HATarget
implements DistributedReplicantManager.ReplicantListener {
    protected String replicantName;
    protected ArrayList replicants = new ArrayList();
    protected HAPartition partition = null;
    protected Logger log;
    protected int clusterViewId = 0;
    protected Serializable target;

    public HATarget(HAPartition partition, String replicantName, Serializable target) throws Exception {
        this.replicantName = replicantName;
        this.log = Logger.getLogger(this.getClass());
        this.target = target;
        this.updateHAPartition(partition);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('{');
        buffer.append("replicantName=" + this.replicantName);
        buffer.append("partition=" + this.partition.getPartitionName());
        buffer.append("clusterViewId=" + this.clusterViewId);
        buffer.append("replicants=" + this.replicants);
        buffer.append('}');
        return buffer.toString();
    }

    public long getCurrentViewId() {
        return this.clusterViewId;
    }

    public void destroy() {
        try {
            this.cleanExistenceInCurrentHAPartition();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getReplicants() {
        return this.replicants;
    }

    public void updateHAPartition(HAPartition partition) throws Exception {
        this.cleanExistenceInCurrentHAPartition();
        this.partition = partition;
        DistributedReplicantManager drm = partition.getDistributedReplicantManager();
        drm.registerListener(this.replicantName, this);
        drm.add(this.replicantName, this.target);
    }

    public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("replicantsChanged '" + this.replicantName + "' to " + newReplicants.size() + " (intra-view id: " + newReplicantsViewId + ")"));
        }
        ArrayList arrayList = this.replicants;
        synchronized (arrayList) {
            this.replicants.clear();
            this.replicants.addAll(newReplicants);
        }
        this.clusterViewId = newReplicantsViewId;
    }

    protected void cleanExistenceInCurrentHAPartition() {
        if (this.partition != null) {
            try {
                DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
                drm.unregisterListener(this.replicantName, this);
                drm.remove(this.replicantName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

