/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.http.interfaces.Util;
import org.jboss.logging.Logger;

public class HttpInvokerProxyHA
implements Invoker,
Externalizable {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$invocation$http$interfaces$HttpInvokerProxyHA == null ? (class$org$jboss$invocation$http$interfaces$HttpInvokerProxyHA = HttpInvokerProxyHA.class$("org.jboss.invocation.http.interfaces.HttpInvokerProxyHA")) : class$org$jboss$invocation$http$interfaces$HttpInvokerProxyHA));
    protected ArrayList targets = null;
    protected LoadBalancePolicy loadBalancePolicy;
    protected transient long currentViewId = 0L;
    protected transient boolean trace = false;
    static /* synthetic */ Class class$org$jboss$invocation$http$interfaces$HttpInvokerProxyHA;

    public HttpInvokerProxyHA() {
    }

    public HttpInvokerProxyHA(ArrayList targets, LoadBalancePolicy policy) {
        this.targets = targets;
        this.loadBalancePolicy = policy;
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("Init, targets: " + targets + ", policy=" + this.loadBalancePolicy));
        }
    }

    public String getServerHostName() throws Exception {
        return null;
    }

    public ArrayList getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList newTargets) {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.clear();
            this.targets.addAll(newTargets);
            if (this.trace) {
                log.trace((Object)("Updated targets: " + this.targets));
            }
        }
    }

    public Object getRemoteTarget() {
        Object target = null;
        if (this.targets.size() > 0) {
            ArrayList arrayList = this.targets;
            synchronized (arrayList) {
                target = this.loadBalancePolicy.chooseTarget(this.targets);
            }
        }
        if (this.trace) {
            log.trace((Object)("Choose remoteTarget: " + target));
        }
        return target;
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    protected void removeDeadTarget(Object target) {
        if (this.targets != null) {
            boolean removed = this.targets.remove(target);
            if (this.trace) {
                log.trace((Object)("removeDeadTarget(" + target + "), removed=" + removed + ", targets.size=" + this.targets.size()));
            }
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        int failoverCounter = 0;
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setValue((Object)"CLUSTER_VIEW_ID", (Object)new Long(this.currentViewId));
        String target = (String)this.getRemoteTarget();
        URL externalURL = Util.resolveURL((String)target);
        while (externalURL != null) {
            block7: {
                invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), 0);
                try {
                    if (this.trace) {
                        log.trace((Object)("Invoking on target=" + externalURL));
                    }
                    Object rtn = Util.invoke((URL)externalURL, (Invocation)mi);
                    HARMIResponse rsp = (HARMIResponse)rtn;
                    if (rsp.newReplicants != null) {
                        this.setTargets(rsp.newReplicants);
                        this.currentViewId = rsp.currentViewId;
                    }
                    return rsp.response;
                }
                catch (GenericClusteringException e) {
                    if (e.getCompletionStatus() != GenericClusteringException.COMPLETED_NO) {
                        throw new ServerException("Cannot proceed beyond target=" + externalURL, e);
                    }
                }
                catch (Throwable e) {
                    if (!this.trace) break block7;
                    log.trace((Object)("Invoke failed, target=" + externalURL), e);
                }
            }
            this.remoteTargetHasFailed(target);
            target = (String)this.getRemoteTarget();
            externalURL = Util.resolveURL((String)target);
            ++failoverCounter;
        }
        throw new RemoteException("Service unavailable.");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.targets);
        out.writeObject(this.loadBalancePolicy);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targets = (ArrayList)in.readObject();
        this.loadBalancePolicy = (LoadBalancePolicy)in.readObject();
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("Init, targets: " + this.targets + ", policy=" + this.loadBalancePolicy));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

