/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.io.Serializable;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.http.server.HttpProxyFactory;
import org.jboss.invocation.http.server.HttpProxyFactoryHAMBean;
import org.jboss.system.Registry;

public class HttpProxyFactoryHA
extends HttpProxyFactory
implements HttpProxyFactoryHAMBean {
    private ObjectName invokerHAName;
    private String partitionName;
    private Class policyClass;
    private InvokerHA invokerHA;
    private HATarget invokerTarget;

    public ObjectName getInvokerHAName() {
        return this.invokerHAName;
    }

    public void setInvokerHAName(ObjectName name) {
        this.invokerHAName = name;
    }

    public Class getLoadBalancePolicy() {
        return this.policyClass;
    }

    public void setLoadBalancePolicy(Class policyClass) {
        this.policyClass = policyClass;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String name) {
        this.partitionName = name;
    }

    protected Invoker createInvoker() throws Exception {
        InitialContext iniCtx = new InitialContext();
        HAPartition partition = (HAPartition)iniCtx.lookup("/HAPartition/" + this.partitionName);
        this.invokerHA = (InvokerHA)Registry.lookup((Object)this.invokerHAName);
        if (this.invokerHA == null) {
            throw new RuntimeException("InvokerHA is null: " + this.invokerHAName);
        }
        ObjectName jmxInvokerName = this.getInvokerName();
        Serializable invokerStub = this.invokerHA.getStub();
        this.invokerTarget = new HATarget(partition, jmxInvokerName.toString(), invokerStub);
        this.invokerHA.registerBean(jmxInvokerName, this.invokerTarget);
        LoadBalancePolicy policy = (LoadBalancePolicy)this.policyClass.newInstance();
        Invoker delegateInvoker = this.invokerHA.createProxy(jmxInvokerName, policy);
        return delegateInvoker;
    }

    public void destroy() {
        super.destroy();
        try {
            ObjectName jmxInvokerName = this.getInvokerName();
            this.invokerHA.unregisterBean(jmxInvokerName);
            this.invokerTarget.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

