/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy;

public class JRMPInvokerProxyHA
extends JRMPInvokerProxy
implements Externalizable {
    protected ArrayList targets = null;
    protected LoadBalancePolicy loadBalancePolicy;
    protected transient long currentViewId = 0L;
    public static final HashSet colocation = new HashSet();

    public JRMPInvokerProxyHA() {
    }

    public JRMPInvokerProxyHA(ArrayList targets, LoadBalancePolicy policy) {
        this.targets = targets;
        this.loadBalancePolicy = policy;
    }

    public ArrayList getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList newTargets) {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.clear();
            this.targets.addAll(newTargets);
        }
    }

    public Object getRemoteTarget() {
        if (this.targets.size() == 0) {
            return null;
        }
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            Object object = this.loadBalancePolicy.chooseTarget(this.targets);
            return object;
        }
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    protected void removeDeadTarget(Object target) {
        if (this.targets != null) {
            ArrayList arrayList = this.targets;
            synchronized (arrayList) {
                int length = this.targets.size();
                int i = 0;
                while (i < length) {
                    if (this.targets.get(i) == target) {
                        this.targets.remove(i);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isLocal(Invocation invocation) {
        return colocation.contains(invocation.getObjectName());
    }

    public Object invoke(Invocation invocation) throws Exception {
        int failoverCounter = 0;
        invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), 0);
        if (this.isLocal(invocation)) {
            return InvokerInterceptor.getLocal().invoke(invocation);
        }
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        mi.setValue((Object)"CLUSTER_VIEW_ID", (Object)new Long(this.currentViewId));
        Invoker target = (Invoker)this.getRemoteTarget();
        while (target != null) {
            block10: {
                try {
                    HARMIResponse rsp = (HARMIResponse)((MarshalledObject)target.invoke((Invocation)mi)).get();
                    if (rsp.newReplicants != null) {
                        this.setTargets(rsp.newReplicants);
                        this.currentViewId = rsp.currentViewId;
                    }
                    return rsp.response;
                }
                catch (ConnectException ce) {
                }
                catch (ConnectIOException cioe) {
                }
                catch (NoSuchObjectException nsoe) {
                }
                catch (UnmarshalException ue) {
                }
                catch (UnknownHostException uhe) {
                }
                catch (GenericClusteringException gce) {
                    if (gce.getCompletionStatus() == GenericClusteringException.COMPLETED_NO) break block10;
                    throw new RemoteException(gce.getMessage());
                }
            }
            this.remoteTargetHasFailed(target);
            target = (Invoker)this.getRemoteTarget();
            mi.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(++failoverCounter), 0);
        }
        throw new RemoteException("Service unavailable.");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.targets);
        out.writeObject(this.loadBalancePolicy);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targets = (ArrayList)in.readObject();
        this.loadBalancePolicy = (LoadBalancePolicy)in.readObject();
    }
}

