/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyConnectionMetaData;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyXAResourceManager;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.ServerIL;

public class Connection
implements Serializable,
javax.jms.Connection {
    public static ThreadGroup threadGroup = new ThreadGroup("JBossMQ Client Threads");
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$Connection == null ? (class$org$jboss$mq$Connection = Connection.class$("org.jboss.mq.Connection")) : class$org$jboss$mq$Connection));
    public HashMap destinationSubscriptions = new HashMap();
    public HashMap subscriptions = new HashMap();
    public boolean modeStop;
    protected ServerIL serverIL;
    protected String clientID;
    protected ConnectionToken connectionToken;
    protected ClientILService clientILService;
    protected static ClockDaemon clockDaemon = new ClockDaemon();
    protected long pingPeriod = 60000L;
    protected boolean ponged = true;
    Semaphore pingTaskSemaphore = new Semaphore(1L);
    Object pingTaskId;
    protected volatile boolean closing = false;
    private volatile boolean setClientIdAllowed = true;
    HashSet createdSessions;
    int subscriptionCounter = Integer.MIN_VALUE;
    boolean closed;
    SpyXAResourceManager spyXAResourceManager;
    GenericConnectionFactory genericConnectionFactory;
    private int lastMessageID;
    private ExceptionListener exceptionListener;
    private StringBuffer sb = new StringBuffer();
    private char[] charStack = new char[22];
    String sessionId;
    static /* synthetic */ Class class$org$jboss$mq$Connection;

    Connection(String userName, String password, GenericConnectionFactory genericConnectionFactory) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Connection Initializing");
        }
        this.createdSessions = new HashSet();
        this.connectionToken = null;
        this.closed = false;
        this.lastMessageID = 0;
        this.modeStop = true;
        if (trace) {
            log.trace((Object)"Getting the serverIL");
        }
        this.genericConnectionFactory = genericConnectionFactory;
        this.serverIL = genericConnectionFactory.createServerIL();
        if (trace) {
            log.trace((Object)("serverIL=" + this.serverIL));
            log.trace((Object)"Authenticating");
        }
        this.authenticate(userName, password);
        if (userName != null) {
            this.askForAnID(userName, password);
        }
        if (trace) {
            log.trace((Object)"Starting the clientIL service");
        }
        this.startILService();
        this.spyXAResourceManager = new SpyXAResourceManager(this);
        this.startPingThread();
        if (trace) {
            log.trace((Object)"Connection establishment successful");
        }
    }

    Connection(GenericConnectionFactory genericConnectionFactory) throws JMSException {
        this(null, null, genericConnectionFactory);
    }

    public void setClientID(String cID) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (this.clientID != null) {
            throw new IllegalStateException("The connection has already a clientID");
        }
        if (!this.setClientIdAllowed) {
            throw new IllegalStateException("SetClientID was not called emediately after creation of connection");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("SetClientID(" + this.clientID + ")"));
        }
        try {
            this.serverIL.checkID(cID);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot connect to the JMSServer", e);
        }
        this.clientID = cID;
        this.connectionToken.setClientID(this.clientID);
    }

    public String getClientID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        this.exceptionListener = listener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        return new SpyConnectionMetaData();
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Closing sessions, ClientID=" + this.connectionToken.getClientID()));
        }
        this.closing = true;
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            Object[] vect = this.createdSessions.toArray();
            int i = 0;
            while (i < vect.length) {
                ((SpySession)vect[i]).close();
                ++i;
            }
        }
        if (trace) {
            log.trace((Object)"Closed sessions");
            log.debug((Object)"Notifiying the server of close");
        }
        try {
            this.serverIL.connectionClosing(this.connectionToken);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot close properly the connection", e);
        }
        this.stopPingThread();
        if (trace) {
            log.trace((Object)"Stoping the ClientIL service");
        }
        this.stopILService();
        if (trace) {
            log.trace((Object)"Disconnected from server");
        }
        this.closed = true;
    }

    public void start() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        if (!this.modeStop) {
            return;
        }
        this.modeStop = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting connection, ClientID=" + this.connectionToken.getClientID()));
        }
        try {
            this.serverIL.setEnabled(this.connectionToken, true);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot enable the connection with the JMS server", e);
        }
    }

    public void stop() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        if (this.modeStop) {
            return;
        }
        this.modeStop = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Stoping connection, ClientID=" + this.connectionToken.getClientID()));
        }
        try {
            this.serverIL.setEnabled(this.connectionToken, false);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot disable the connection with the JMS server", e);
        }
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    public void asynchClose() {
    }

    public void asynchDeleteTemporaryDestination(SpyDestination dest) {
        try {
            this.deleteTemporaryDestination(dest);
        }
        catch (JMSException e) {
            this.asynchFailure(e.getMessage(), e.getLinkedException());
        }
    }

    public void asynchDeliver(ReceiveRequest[] requests) {
        try {
            int i = 0;
            while (i < requests.length) {
                SpyConsumer consumer = (SpyConsumer)this.subscriptions.get(requests[i].subscriptionId);
                requests[i].message.createAcknowledgementRequest(requests[i].subscriptionId);
                if (consumer == null) {
                    this.send(requests[i].message.getAcknowledgementRequest(false));
                    log.debug((Object)"WARNING: NACK issued due to non existent subscription");
                } else {
                    consumer.addMessage(requests[i].message);
                }
                ++i;
            }
        }
        catch (JMSException e) {
            this.asynchFailure(e.getMessage(), e.getLinkedException());
        }
    }

    public void asynchFailure(String reason, Exception e) {
        if (this.closing) {
            return;
        }
        SpyJMSException excep = new SpyJMSException(reason, e);
        excep.fillInStackTrace();
        if (this.exceptionListener != null) {
            ExceptionListener exceptionListener = this.exceptionListener;
            synchronized (exceptionListener) {
                this.exceptionListener.onException((JMSException)excep);
            }
        } else {
            log.warn((Object)"Connection failure: ", (Throwable)((Object)excep));
        }
    }

    public void asynchPong(long serverTime) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("PONG, serverIL=" + this.serverIL));
        }
        this.ponged = true;
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SpyConnection: deleteDestination(dest=" + dest.toString() + ")"));
        }
        try {
            HashMap hashMap = this.subscriptions;
            synchronized (hashMap) {
                this.destinationSubscriptions.remove(dest);
            }
            HashSet hashSet = this.createdSessions;
            synchronized (hashSet) {
                Iterator i = this.createdSessions.iterator();
                while (i.hasNext()) {
                    ((SpySession)i.next()).deleteTemporaryDestination(dest);
                }
            }
            this.serverIL.deleteTemporaryDestination(this.connectionToken, dest);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot delete the TemporaryDestination", e);
        }
    }

    protected synchronized void checkClientID() throws JMSException {
        if (!this.setClientIdAllowed) {
            return;
        }
        boolean trace = log.isTraceEnabled();
        this.setClientIdAllowed = false;
        if (trace) {
            log.trace((Object)("Checking clientID :" + this.clientID));
        }
        if (this.clientID == null) {
            this.askForAnID();
            if (this.clientID == null) {
                throw new JMSException("Could not get a clientID");
            }
            this.connectionToken.setClientID(this.clientID);
            if (trace) {
                log.trace((Object)"Connection establishment successful");
            }
        }
    }

    protected void askForAnID() throws JMSException {
        try {
            this.clientID = this.serverIL.getID();
        }
        catch (Exception e) {
            log.debug((Object)"Cannot get a client ID:", (Throwable)e);
            throw new SpyJMSException("Cannot get a client ID: " + e.getMessage(), e);
        }
    }

    protected void askForAnID(String userName, String password) throws JMSException {
        try {
            this.clientID = this.serverIL.checkUser(userName, password);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot get a client ID", e);
        }
    }

    protected void authenticate(String userName, String password) throws JMSException {
        try {
            log.trace((Object)("Authenticating user " + userName));
            this.sessionId = this.serverIL.authenticate(userName, password);
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot authenticate user", e);
        }
    }

    protected void send(AcknowledgementRequest item) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            this.serverIL.acknowledge(this.connectionToken, item);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot acknowlege a message", e);
        }
    }

    protected void send(TransactionRequest transaction) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            this.serverIL.transact(this.connectionToken, transaction);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot process a transaction", e);
        }
    }

    protected void startILService() throws JMSException {
        try {
            this.clientILService = this.genericConnectionFactory.createClientILService(this);
            this.clientILService.start();
            this.connectionToken = new ConnectionToken(this.clientID, this.clientILService.getClientIL(), this.sessionId);
            this.serverIL.setConnectionToken(this.connectionToken);
        }
        catch (Exception e) {
            log.debug((Object)"Cannot start a the client IL service", (Throwable)e);
            throw new SpyJMSException("Cannot start a the client IL service", e);
        }
    }

    protected void stopILService() throws JMSException {
        try {
            this.clientILService.stop();
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot stop a the client IL service", e);
        }
    }

    String getNewMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        StringBuffer stringBuffer = this.sb;
        synchronized (stringBuffer) {
            this.sb.setLength(0);
            this.sb.append(this.clientID);
            this.sb.append('-');
            long time = System.currentTimeMillis();
            int count = 0;
            do {
                this.charStack[count] = (char)(48L + time % 10L);
                ++count;
            } while ((time /= 10L) != 0L);
            --count;
            while (count >= 0) {
                this.sb.append(this.charStack[count]);
                --count;
            }
            ++this.lastMessageID;
            if (this.lastMessageID < 0) {
                this.lastMessageID = 0;
            }
            int id = this.lastMessageID;
            count = 0;
            do {
                this.charStack[count] = (char)(48 + id % 10);
                ++count;
            } while ((id /= 10) != 0);
            --count;
            while (count >= 0) {
                this.sb.append(this.charStack[count]);
                --count;
            }
            String string = this.sb.toString();
            return string;
        }
    }

    void addConsumer(SpyConsumer consumer) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        Subscription req = consumer.getSubscription();
        req.subscriptionId = this.subscriptionCounter++;
        req.connectionToken = this.connectionToken;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connection: addConsumer(dest=" + req.destination.toString() + ")"));
        }
        try {
            HashMap hashMap = this.subscriptions;
            synchronized (hashMap) {
                this.subscriptions.put(new Integer(req.subscriptionId), consumer);
                LinkedList<SpyConsumer> ll = (LinkedList<SpyConsumer>)this.destinationSubscriptions.get(req.destination);
                if (ll == null) {
                    ll = new LinkedList<SpyConsumer>();
                    this.destinationSubscriptions.put(req.destination, ll);
                }
                ll.add(consumer);
            }
            this.serverIL.subscribe(this.connectionToken, req);
        }
        catch (JMSSecurityException ex) {
            this.removeConsumerInternal(consumer);
            throw ex;
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot subscribe to this Destination: " + e.getMessage(), e);
        }
    }

    SpyMessage[] browse(Queue queue, String selector) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            return this.serverIL.browse(this.connectionToken, (Destination)queue, selector);
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot browse the Queue", e);
        }
    }

    void pingServer(long clientTime) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"PING");
            }
            this.serverIL.ping(this.connectionToken, clientTime);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot ping the JMS server", e);
        }
    }

    SpyMessage receive(Subscription sub, long wait) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            SpyMessage message = this.serverIL.receive(this.connectionToken, sub.subscriptionId, wait);
            if (message != null) {
                message.createAcknowledgementRequest(sub.subscriptionId);
            }
            return message;
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot create a ConnectionReceiver", e);
        }
    }

    void removeConsumer(SpyConsumer consumer) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        Subscription req = consumer.getSubscription();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection: removeSession(dest=" + req.destination + ")"));
        }
        try {
            this.serverIL.unsubscribe(this.connectionToken, req.subscriptionId);
            this.removeConsumerInternal(consumer);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot unsubscribe to this destination", e);
        }
    }

    private void removeConsumerInternal(SpyConsumer consumer) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            Subscription req = consumer.getSubscription();
            this.subscriptions.remove(new Integer(req.subscriptionId));
            LinkedList ll = (LinkedList)this.destinationSubscriptions.get(req.destination);
            if (ll != null) {
                ll.remove(consumer);
                if (ll.size() == 0) {
                    this.destinationSubscriptions.remove(req.destination);
                }
            }
        }
    }

    void sendToServer(SpyMessage mes) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            this.serverIL.addMessage(this.connectionToken, mes);
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot send a message to the JMS server", e);
        }
    }

    void sessionClosing(SpySession who) {
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.remove(who);
        }
    }

    void unsubscribe(DurableSubscriptionID id) throws JMSException {
        try {
            this.serverIL.destroySubscription(this.connectionToken, id);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot destroy durable subscription " + id, e);
        }
    }

    private void startPingThread() {
        if (this.pingPeriod == 0L) {
            return;
        }
        this.pingTaskId = clockDaemon.executePeriodically(this.pingPeriod, (Runnable)new PingTask(), true);
    }

    private void stopPingThread() {
        if (this.pingPeriod == 0L) {
            return;
        }
        ClockDaemon.cancel((Object)this.pingTaskId);
        try {
            this.pingTaskSemaphore.attempt(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log.debug((Object)"Setting the clockDaemon's thread factory");
        clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(threadGroup, r, "Connection Monitor Thread");
                t.setDaemon(true);
                return t;
            }
        });
    }

    class PingTask
    implements Runnable {
        PingTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Connection.this.pingTaskSemaphore.acquire();
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                try {
                    if (!Connection.this.ponged) {
                        throw new SpyJMSException("", new IOException("ping timeout."));
                    }
                    Connection.this.ponged = false;
                    Connection.this.pingServer(System.currentTimeMillis());
                }
                catch (JMSException e) {
                    Connection.this.asynchFailure("Connection Failed", e.getLinkedException());
                    Object var3_4 = null;
                    Connection.this.pingTaskSemaphore.release();
                    return;
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                Connection.this.pingTaskSemaphore.release();
                throw throwable;
            }
            Connection.this.pingTaskSemaphore.release();
        }
    }
}

