/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;

public class SpyBytesMessage
extends SpyMessage
implements Cloneable,
BytesMessage,
Externalizable {
    byte[] InternalArray = null;
    private transient ByteArrayOutputStream ostream = null;
    private transient DataOutputStream p = null;
    private transient ByteArrayInputStream istream = null;
    private transient DataInputStream m = null;
    private static final long serialVersionUID = -6572727147964701014L;

    public SpyBytesMessage() {
        this.header.msgReadOnly = false;
        this.ostream = new ByteArrayOutputStream();
        this.p = new DataOutputStream(this.ostream);
    }

    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return this.m.readBoolean();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return this.m.readByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkRead();
        try {
            return this.m.readUnsignedByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return this.m.readShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkRead();
        try {
            return this.m.readUnsignedShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return this.m.readChar();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return this.m.readInt();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return this.m.readLong();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return this.m.readFloat();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return this.m.readDouble();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public String readUTF() throws JMSException {
        this.checkRead();
        try {
            return this.m.readUTF();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        try {
            return this.m.read(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkRead();
        try {
            return this.m.read(value, 0, length);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeBoolean(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeByte(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeShort(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeChar(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeInt(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeLong(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeFloat(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeDouble(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.writeUTF(value);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.write(value, 0, value.length);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        try {
            this.p.write(value, offset, length);
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void writeObject(Object value) throws JMSException {
        block12: {
            if (this.header.msgReadOnly) {
                throw new MessageNotWriteableException("the message body is read-only");
            }
            try {
                if (value instanceof String) {
                    this.p.writeChars((String)value);
                    break block12;
                }
                if (value instanceof Boolean) {
                    this.p.writeBoolean((Boolean)value);
                    break block12;
                }
                if (value instanceof Byte) {
                    this.p.writeByte(((Byte)value).byteValue());
                    break block12;
                }
                if (value instanceof Short) {
                    this.p.writeShort(((Short)value).shortValue());
                    break block12;
                }
                if (value instanceof Integer) {
                    this.p.writeInt((Integer)value);
                    break block12;
                }
                if (value instanceof Long) {
                    this.p.writeLong((Long)value);
                    break block12;
                }
                if (value instanceof Float) {
                    this.p.writeFloat(((Float)value).floatValue());
                    break block12;
                }
                if (value instanceof Double) {
                    this.p.writeDouble((Double)value);
                    break block12;
                }
                if (value instanceof byte[]) {
                    this.p.write((byte[])value, 0, ((byte[])value).length);
                    break block12;
                }
                throw new MessageFormatException("Invalid object for properties");
            }
            catch (IOException e) {
                throw new JMSException("IOException");
            }
        }
    }

    public void reset() throws JMSException {
        try {
            if (!this.header.msgReadOnly) {
                this.p.flush();
                this.InternalArray = this.ostream.toByteArray();
                this.ostream.close();
            }
            this.ostream = null;
            this.istream = null;
            this.m = null;
            this.p = null;
            this.header.msgReadOnly = true;
        }
        catch (IOException e) {
            throw new JMSException("IOException");
        }
    }

    public void clearBody() throws JMSException {
        try {
            if (!this.header.msgReadOnly) {
                this.ostream.close();
            } else if (this.istream != null) {
                this.istream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ostream = new ByteArrayOutputStream();
        this.p = new DataOutputStream(this.ostream);
        this.InternalArray = null;
        this.istream = null;
        this.m = null;
        super.clearBody();
    }

    public SpyMessage myClone() throws JMSException {
        SpyBytesMessage result = MessagePool.getBytesMessage();
        this.reset();
        result.copyProps(this);
        if (this.InternalArray != null) {
            result.InternalArray = new byte[this.InternalArray.length];
            System.arraycopy(this.InternalArray, 0, result.InternalArray, 0, this.InternalArray.length);
        }
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] arrayToSend = null;
        if (!this.header.msgReadOnly) {
            this.p.flush();
            arrayToSend = this.ostream.toByteArray();
        } else {
            arrayToSend = this.InternalArray;
        }
        super.writeExternal(out);
        if (arrayToSend == null) {
            out.writeInt(0);
        } else {
            out.writeInt(arrayToSend.length);
            out.write(arrayToSend);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int length = in.readInt();
        if (length < 0) {
            this.InternalArray = null;
        } else {
            this.InternalArray = new byte[length];
            in.readFully(this.InternalArray);
        }
    }

    private void checkRead() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotWriteableException("readByte while the buffer is writeonly");
        }
        if (this.istream == null || this.m == null) {
            this.istream = new ByteArrayInputStream(this.InternalArray);
            this.m = new DataInputStream(this.istream);
        }
    }
}

