/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.jms.JMSException;
import org.jboss.util.NestedException;
import org.jboss.util.NestedThrowable;

public class SpyJMSException
extends JMSException
implements NestedThrowable {
    protected Throwable nested;

    public SpyJMSException(String msg) {
        super(msg);
        this.nested = null;
    }

    public SpyJMSException(String msg, String code) {
        super(msg, code);
        this.nested = null;
    }

    public SpyJMSException(String msg, Throwable nested) {
        super(msg);
        this.nested = nested;
        NestedThrowable.Util.checkNested((NestedThrowable)this, (Throwable)nested);
    }

    public SpyJMSException(Throwable nested) {
        this(nested.getMessage(), nested);
    }

    public Throwable getNested() {
        return this.nested;
    }

    public Throwable getCause() {
        return this.nested;
    }

    public void setLinkedException(Exception e) {
        this.nested = e;
    }

    public Exception getLinkedException() {
        if (this.nested instanceof Exception) {
            return (Exception)this.nested;
        }
        return new NestedException(this.nested);
    }

    public String getMessage() {
        return NestedThrowable.Util.getMessage((String)super.getMessage(), (Throwable)this.nested);
    }

    public void printStackTrace(PrintStream stream) {
        if (this.nested == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(stream);
        }
        NestedThrowable.Util.print((Throwable)this.nested, (PrintStream)stream);
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.nested == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(writer);
        }
        NestedThrowable.Util.print((Throwable)this.nested, (PrintWriter)writer);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

